/*
 * Decompiled with CFR 0.152.
 */
package openllet.core.el;

import java.util.Set;
import openllet.aterm.ATermAppl;
import openllet.core.el.Trigger;
import openllet.core.utils.ATermUtils;
import openllet.core.utils.MultiValueMap;
import openllet.core.utils.SetUtils;

class ConceptInfo {
    private final ATermAppl _concept;
    private final Set<Trigger> _triggers;
    private final MultiValueMap<ATermAppl, ConceptInfo> _successors;
    private final MultiValueMap<ATermAppl, ConceptInfo> _predecessors = new MultiValueMap();
    private final Set<ConceptInfo> superClasses = SetUtils.create();

    public ConceptInfo(ATermAppl c, boolean storeSuccessors, boolean noTriggers) {
        this._concept = c;
        this._successors = storeSuccessors ? new MultiValueMap() : null;
        this._predecessors.clear();
        this._triggers = noTriggers ? null : SetUtils.create();
    }

    public boolean addSuccessor(ATermAppl p, ConceptInfo ci) {
        if (ci._predecessors.add(p, this)) {
            if (this._successors != null) {
                this._successors.add(p, ci);
            }
            return true;
        }
        return false;
    }

    public boolean addSuperClass(ConceptInfo sup) {
        return this.superClasses.add(sup);
    }

    public boolean addTrigger(Trigger trigger) {
        return this._triggers.add(trigger);
    }

    public boolean equals(Object obj) {
        return obj instanceof ConceptInfo && ((ConceptInfo)obj)._concept == this._concept;
    }

    public ATermAppl getConcept() {
        return this._concept;
    }

    public MultiValueMap<ATermAppl, ConceptInfo> getSuccessors() {
        return this._successors;
    }

    public MultiValueMap<ATermAppl, ConceptInfo> getPredecessors() {
        return this._predecessors;
    }

    public Set<ConceptInfo> getSuperClasses() {
        return this.superClasses;
    }

    public Set<Trigger> getTriggers() {
        return this._triggers;
    }

    public boolean hasSuccessor(ATermAppl p, ConceptInfo ci) {
        return ci._predecessors.contains(p, this);
    }

    public int hashCode() {
        return this._concept.hashCode();
    }

    public boolean hasSuperClass(ConceptInfo ci) {
        return this.superClasses.contains(ci);
    }

    public String toString() {
        return ATermUtils.toString(this._concept);
    }
}

