/*
 * Decompiled with CFR 0.152.
 */
package openllet.core.el;

import java.util.Collections;
import java.util.Map;
import java.util.Set;
import openllet.aterm.ATermAppl;
import openllet.core.taxonomy.Taxonomy;
import openllet.core.taxonomy.TaxonomyImpl;
import openllet.core.taxonomy.TaxonomyNode;
import openllet.core.utils.ATermUtils;
import openllet.core.utils.MultiValueMap;
import openllet.core.utils.SetUtils;

public class GenericTaxonomyBuilder {
    private Taxonomy<ATermAppl> _taxonomyImpl;
    private MultiValueMap<ATermAppl, ATermAppl> _subsumers;

    public Taxonomy<ATermAppl> build(MultiValueMap<ATermAppl, ATermAppl> subsumers) {
        this._subsumers = subsumers;
        this._taxonomyImpl = new TaxonomyImpl<ATermAppl>(null, ATermUtils.TOP, ATermUtils.BOTTOM);
        for (ATermAppl aTermAppl : (Set)subsumers.get(ATermUtils.TOP)) {
            if (!ATermUtils.isPrimitive(aTermAppl)) continue;
            this._taxonomyImpl.addEquivalentNode(aTermAppl, this._taxonomyImpl.getTop());
        }
        for (Map.Entry entry : subsumers.entrySet()) {
            ATermAppl c = (ATermAppl)entry.getKey();
            if (!ATermUtils.isPrimitive(c)) continue;
            if (((Set)entry.getValue()).contains(ATermUtils.BOTTOM)) {
                this._taxonomyImpl.addEquivalentNode(c, this._taxonomyImpl.getBottomNode());
                continue;
            }
            this.add(c);
        }
        return this._taxonomyImpl;
    }

    private TaxonomyNode<ATermAppl> add(ATermAppl c) {
        TaxonomyNode<ATermAppl> node = this._taxonomyImpl.getNode(c);
        if (node == null) {
            Set<ATermAppl> equivalents = SetUtils.create();
            Set<TaxonomyNode<ATermAppl>> subsumerNodes = SetUtils.create();
            for (ATermAppl subsumer : (Set)this._subsumers.get(c)) {
                if (c.equals(subsumer) || !ATermUtils.isPrimitive(subsumer)) continue;
                if (((Set)this._subsumers.get(subsumer)).contains(c)) {
                    equivalents.add(subsumer);
                    continue;
                }
                TaxonomyNode<ATermAppl> supNode = this.add(subsumer);
                subsumerNodes.add(supNode);
            }
            node = this.add(c, subsumerNodes);
            for (ATermAppl eq : equivalents) {
                this._taxonomyImpl.addEquivalentNode(eq, node);
            }
        }
        return node;
    }

    private TaxonomyNode<ATermAppl> add(ATermAppl c, Set<TaxonomyNode<ATermAppl>> subsumers) {
        Set<TaxonomyNode<ATermAppl>> parents = SetUtils.create(subsumers);
        Set supers = SetUtils.create();
        Set<ATermAppl> subs = Collections.singleton(ATermUtils.BOTTOM);
        for (TaxonomyNode<ATermAppl> subsumer : subsumers) {
            parents.removeAll(subsumer.getSupers());
        }
        for (TaxonomyNode<ATermAppl> parent : parents) {
            supers.add(parent.getName());
            parent.removeSub(this._taxonomyImpl.getBottomNode());
        }
        return this._taxonomyImpl.addNode(Collections.singleton(c), supers, subs, false);
    }
}

