/*
 * Decompiled with CFR 0.152.
 */
package openllet.core.expressivity;

import openllet.aterm.ATermAppl;
import openllet.core.KnowledgeBase;
import openllet.core.el.ELExpressivityChecker;
import openllet.core.expressivity.DLExpressivityChecker;
import openllet.core.expressivity.Expressivity;
import openllet.core.utils.ATermUtils;

public class ExpressivityChecker {
    private final KnowledgeBase _KB;
    private final ELExpressivityChecker _ELChecker;
    private final DLExpressivityChecker _DLChecker;
    private volatile Expressivity _expressivity;

    public ExpressivityChecker(KnowledgeBase kb) {
        this(kb, new Expressivity());
    }

    public ExpressivityChecker(KnowledgeBase kb, Expressivity expr) {
        this._KB = kb;
        this._ELChecker = new ELExpressivityChecker(this._KB);
        this._DLChecker = new DLExpressivityChecker(this._KB);
        this._expressivity = expr;
    }

    public void prepare() {
        this._expressivity = new Expressivity();
        if (this._ELChecker.compute(this._expressivity)) {
            return;
        }
        this._expressivity = new Expressivity();
        this._expressivity.setHasAllValues(true);
        this._DLChecker.compute(this._expressivity);
    }

    public Expressivity getExpressivity() {
        return this._expressivity;
    }

    public Expressivity getExpressivityWith(ATermAppl c) {
        if (c == null) {
            return this._expressivity;
        }
        Expressivity newExp = new Expressivity(this._expressivity);
        this._DLChecker.updateWith(newExp, c);
        return newExp;
    }

    public void updateWithIndividual(ATermAppl i, ATermAppl concept) {
        ATermAppl nominal = ATermUtils.makeValue(i);
        if (concept.equals(nominal)) {
            return;
        }
        this._DLChecker.updateWith(this._expressivity, concept);
    }
}

