/*
 * Decompiled with CFR 0.152.
 */
package openllet.core.knowledge;

import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import openllet.aterm.ATerm;
import openllet.aterm.ATermAppl;
import openllet.core.KnowledgeBase;
import openllet.core.OpenlletOptions;
import openllet.core.PropertyType;
import openllet.core.boxes.rbox.Role;
import openllet.core.el.SimplifiedELClassifier;
import openllet.core.exceptions.UndefinedEntityException;
import openllet.core.expressivity.ExpressivityChecker;
import openllet.core.knowledge.Boxes;
import openllet.core.knowledge.DatatypeVisitor;
import openllet.core.knowledge.FullyDefinedClassVisitor;
import openllet.core.taxonomy.CDOptimizedTaxonomyBuilder;
import openllet.core.taxonomy.TaxonomyBuilder;
import openllet.core.utils.ATermUtils;
import openllet.core.utils.progress.ProgressMonitor;

public interface Base
extends Boxes {
    public Set<ATermAppl> getIndividuals();

    default public boolean isIndividual(ATerm ind) {
        return this.getIndividuals().contains(ind);
    }

    public Map<ATermAppl, Set<ATermAppl>> getInstances();

    public TaxonomyBuilder getBuilder();

    public ExpressivityChecker getExpChecker();

    public EnumSet<KnowledgeBase.ChangeType> getChanges();

    public Map<ATermAppl, Map<ATermAppl, Set<ATermAppl>>> getAnnotations();

    public static void handleUndefinedEntity(String s) {
        if (!OpenlletOptions.SILENT_UNDEFINED_ENTITY_HANDLING) {
            throw new UndefinedEntityException(s);
        }
    }

    public Optional<TaxonomyBuilder> getOptTaxonomyBuilder();

    public void setOptTaxonomyBuilder(Optional<TaxonomyBuilder> var1);

    public void ensureConsistency();

    public boolean isSatisfiable(ATermAppl var1);

    public void realize();

    public void prepare();

    public void classify();

    public KnowledgeBase getKnowledgeBase();

    public boolean isClassified();

    public boolean isRealized();

    public ProgressMonitor getBuilderProgressMonitor();

    public void setBuilderProgressMonitor(ProgressMonitor var1);

    public FullyDefinedClassVisitor getFullyDefinedVisitor();

    public DatatypeVisitor getDatatypeVisitor();

    default public TaxonomyBuilder getTaxonomyBuilder() {
        if (!this.getOptTaxonomyBuilder().isPresent()) {
            this.prepare();
            CDOptimizedTaxonomyBuilder builder = this.getExpChecker().getExpressivity().isEL() && !OpenlletOptions.DISABLE_EL_CLASSIFIER ? new SimplifiedELClassifier(this.getKnowledgeBase()) : new CDOptimizedTaxonomyBuilder(this.getKnowledgeBase());
            if (this.getBuilderProgressMonitor() != null) {
                builder.setProgressMonitor(this.getBuilderProgressMonitor());
            }
            this.setOptTaxonomyBuilder(Optional.of(builder));
        }
        return this.getOptTaxonomyBuilder().get();
    }

    public Set<Set<ATermAppl>> getSuperClasses(ATermAppl var1, boolean var2);

    public boolean isSubClassOf(ATermAppl var1, ATermAppl var2);

    default public Set<ATermAppl> getProperties() {
        HashSet<ATermAppl> set = new HashSet<ATermAppl>();
        for (Role role : this.getRBox().getRoles().values()) {
            ATermAppl p = role.getName();
            if (!ATermUtils.isPrimitive(p) || !role.isObjectRole() && !role.isDatatypeRole() && !role.isAnnotationRole()) continue;
            set.add(p);
        }
        return set;
    }

    default public Set<ATermAppl> getAnnotationSubjects() {
        return this.getAnnotations().keySet();
    }

    default public PropertyType getPropertyType(ATerm r) {
        Role role = this.getProperty(r);
        return role == null ? PropertyType.UNTYPED : role.getType();
    }

    default public boolean isClass(ATerm c) {
        if (this.getTBox().getClasses().contains(c) || c.equals(ATermUtils.TOP)) {
            return true;
        }
        if (ATermUtils.isComplexClass(c)) {
            return this.getFullyDefinedVisitor().isFullyDefined((ATermAppl)c);
        }
        return false;
    }

    default public boolean isDatatypeProperty(ATerm p) {
        return null != p && this.getPropertyType(p) == PropertyType.DATATYPE;
    }

    default public boolean isDatatype(ATermAppl c) {
        if (null == c) {
            return false;
        }
        return this.getDatatypeVisitor().isDatatype(c);
    }

    default public boolean isObjectProperty(ATerm p) {
        return null != p && this.getPropertyType(p) == PropertyType.OBJECT;
    }

    default public boolean isABoxProperty(ATerm p) {
        if (null == p) {
            return false;
        }
        PropertyType type = this.getPropertyType(p);
        return type == PropertyType.OBJECT || type == PropertyType.DATATYPE;
    }

    default public boolean isAnnotationProperty(ATerm p) {
        return p != null && this.getPropertyType(p) == PropertyType.ANNOTATION;
    }

    default public boolean isProperty(ATerm p) {
        return this.getRBox().isRole(p);
    }

    default public Set<ATermAppl> getClasses() {
        return Collections.unmodifiableSet(this.getTBox().getClasses());
    }

    default public Set<ATermAppl> getAllClasses() {
        return Collections.unmodifiableSet(this.getTBox().getAllClasses());
    }

    default public Stream<ATermAppl> allClasses() {
        return this.getTBox().allClasses();
    }

    default public Role getRole(ATerm term) {
        return this.getRBox().getRole(term);
    }

    default public Role getProperty(ATerm r) {
        return this.getRBox().getRole(r);
    }

    default public Set<ATermAppl> getExplanationSet() {
        return this.getABox().getExplanationSet();
    }

    default public void setDoExplanation(boolean doExplanation) {
        this.getABox().setDoExplanation(doExplanation);
    }

    default public boolean doExplanation() {
        return this.getABox().doExplanation();
    }

    default public String getExplanation() {
        return this.getABox().getExplanation();
    }

    public void binaryInstanceRetrieval(ATermAppl var1, List<ATermAppl> var2, Collection<ATermAppl> var3);
}

