/*
 * Decompiled with CFR 0.152.
 */
package openllet.core.rules;

import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.NoSuchElementException;
import openllet.core.rules.BindingGenerator;
import openllet.core.rules.BindingHelper;
import openllet.core.rules.VariableBinding;

public class BindingGeneratorImpl
implements BindingGenerator {
    private final Collection<BindingHelper> _helpers;
    private VariableBinding _initialBinding;

    public BindingGeneratorImpl(VariableBinding initialBinding, Collection<BindingHelper> helpers) {
        this._helpers = helpers;
        this._initialBinding = initialBinding;
    }

    public BindingGeneratorImpl() {
        this._helpers = Collections.emptySet();
    }

    @Override
    public Iterator<VariableBinding> iterator() {
        return new BindingIterator();
    }

    private class BindingIterator
    implements Iterator<VariableBinding> {
        private VariableBinding _binding;
        private BindingHelper[] _helperChain;

        public BindingIterator() {
            this._helperChain = new BindingHelper[BindingGeneratorImpl.this._helpers.size()];
            this._helperChain = BindingGeneratorImpl.this._helpers.toArray(this._helperChain);
            if (this._helperChain.length > 0) {
                this._helperChain[0].rebind(BindingGeneratorImpl.this._initialBinding);
            }
        }

        private VariableBinding getBinding(int max) {
            VariableBinding newBinding = new VariableBinding(BindingGeneratorImpl.this._initialBinding);
            for (int i = 0; i <= max; ++i) {
                this._helperChain[i].setCurrentBinding(newBinding);
            }
            return newBinding;
        }

        @Override
        public boolean hasNext() {
            if (this._binding != null) {
                return true;
            }
            VariableBinding newBinding = null;
            int position = this._helperChain.length - 1;
            while (position >= 0) {
                if (this._helperChain[position].selectNextBinding()) {
                    if (newBinding == null) {
                        newBinding = this.getBinding(position);
                    } else {
                        this._helperChain[position].setCurrentBinding(newBinding);
                    }
                    if (position < this._helperChain.length - 1) {
                        this._helperChain[position + 1].rebind(newBinding);
                        ++position;
                        continue;
                    }
                    this._binding = newBinding;
                    return true;
                }
                newBinding = null;
                --position;
            }
            return false;
        }

        @Override
        public VariableBinding next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            VariableBinding result = this._binding;
            this._binding = null;
            return result;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

