/*
 * Decompiled with CFR 0.152.
 */
package openllet.core.rules;

import java.util.HashSet;
import openllet.core.rules.VariableUtils;
import openllet.core.rules.builtins.BuiltIn;
import openllet.core.rules.builtins.BuiltInRegistry;
import openllet.core.rules.builtins.NoSuchBuiltIn;
import openllet.core.rules.model.AtomVariable;
import openllet.core.rules.model.BuiltInAtom;
import openllet.core.rules.model.DataRangeAtom;
import openllet.core.rules.model.Rule;
import openllet.core.rules.model.RuleAtom;
import openllet.core.rules.model.RuleAtomVisitor;
import openllet.core.rules.model.SameIndividualAtom;

public class UsableRuleFilter {
    private static BodyAtomFilter bodyFilter = new BodyAtomFilter();
    private static HeadAtomFilter headFilter = new HeadAtomFilter();

    public static boolean isUsable(Rule rule) {
        return UsableRuleFilter.explainNotUsable(rule) == null;
    }

    public static String explainNotUsable(Rule rule) {
        String notUsableExplanation;
        HashSet<AtomVariable> bodyVars = new HashSet<AtomVariable>();
        for (RuleAtom ruleAtom : rule.getBody()) {
            notUsableExplanation = bodyFilter.explainNotUsable(ruleAtom);
            if (notUsableExplanation != null) {
                return notUsableExplanation;
            }
            bodyVars.addAll(VariableUtils.getVars(ruleAtom));
        }
        for (RuleAtom ruleAtom : rule.getHead()) {
            if (!bodyVars.containsAll(VariableUtils.getVars(ruleAtom))) {
                return "Head atom " + ruleAtom + " contains variables not found in body.";
            }
            notUsableExplanation = headFilter.explainNotUsable(ruleAtom);
            if (notUsableExplanation == null) continue;
            return notUsableExplanation;
        }
        return null;
    }

    private static class HeadAtomFilter
    extends UsableFilter {
        private HeadAtomFilter() {
        }

        @Override
        public void visit(BuiltInAtom atom) {
            this._notUsableMessage = "Builtin atoms in rule heads are not currently supported";
        }

        @Override
        public void visit(DataRangeAtom atom) {
            this._notUsableMessage = "DataRange atoms in rule heads are not currently supported";
        }
    }

    private static class BodyAtomFilter
    extends UsableFilter {
        private BodyAtomFilter() {
        }

        @Override
        public void visit(BuiltInAtom atom) {
            BuiltIn builtin = BuiltInRegistry.instance.getBuiltIn((String)atom.getPredicate());
            if (builtin.equals(NoSuchBuiltIn.instance)) {
                this._notUsableMessage = "No builtin for " + (String)atom.getPredicate();
            }
        }

        @Override
        public void visit(SameIndividualAtom atom) {
            this._notUsableMessage = "SameIndividual atom is not supported in rule body: " + atom;
        }
    }

    private static class UsableFilter
    implements RuleAtomVisitor {
        protected String _notUsableMessage;

        private UsableFilter() {
        }

        public String explainNotUsable(RuleAtom atom) {
            this._notUsableMessage = null;
            atom.accept(this);
            return this._notUsableMessage;
        }
    }
}

