/*
 * Decompiled with CFR 0.152.
 */
package openllet.core.rules;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import openllet.aterm.ATermAppl;
import openllet.core.OpenlletOptions;
import openllet.core.boxes.abox.ABox;
import openllet.core.boxes.abox.Individual;
import openllet.core.boxes.abox.Literal;
import openllet.core.boxes.abox.Node;
import openllet.core.datatypes.exceptions.InvalidLiteralException;
import openllet.core.datatypes.exceptions.UnrecognizedDatatypeException;
import openllet.core.exceptions.InternalReasonerException;
import openllet.core.rules.model.AtomDConstant;
import openllet.core.rules.model.AtomDObject;
import openllet.core.rules.model.AtomDVariable;
import openllet.core.rules.model.AtomIConstant;
import openllet.core.rules.model.AtomIObject;
import openllet.core.rules.model.AtomIVariable;
import openllet.core.rules.model.AtomObjectVisitor;
import openllet.core.rules.model.AtomVariable;
import openllet.shared.tools.Log;

public class VariableBinding {
    private static final Logger _logger = Log.getLogger(VariableBinding.class);
    private final ABox _abox;
    private final Map<AtomDVariable, Literal> _dataVars = new HashMap<AtomDVariable, Literal>();
    private final Map<AtomIVariable, Individual> _instanceVars = new HashMap<AtomIVariable, Individual>();

    public VariableBinding(ABox abox) {
        this._abox = abox;
    }

    public VariableBinding(VariableBinding binding) {
        this._abox = binding._abox;
        this._dataVars.putAll(binding._dataVars);
        this._instanceVars.putAll(binding._instanceVars);
    }

    public boolean containsKey(AtomDVariable key) {
        return this._dataVars.containsKey(key);
    }

    public boolean containsKey(AtomIVariable key) {
        return this._instanceVars.containsKey(key);
    }

    public Set<Map.Entry<AtomDVariable, Literal>> dataEntrySet() {
        return this._dataVars.entrySet();
    }

    public Set<Map.Entry<? extends AtomVariable, ? extends Node>> entrySet() {
        HashSet<Map.Entry<? extends AtomVariable, ? extends Node>> entries = new HashSet<Map.Entry<? extends AtomVariable, ? extends Node>>();
        entries.addAll(this._dataVars.entrySet());
        entries.addAll(this._instanceVars.entrySet());
        return entries;
    }

    public boolean equals(Object other) {
        if (other instanceof VariableBinding) {
            VariableBinding otherBinding = (VariableBinding)other;
            if (this._dataVars.equals(otherBinding._dataVars) && this._instanceVars.equals(otherBinding._instanceVars)) {
                return true;
            }
        }
        return false;
    }

    public Literal get(AtomDObject key) {
        DataValueCollector collector = new DataValueCollector();
        key.accept(collector);
        return collector.getValue();
    }

    public Individual get(AtomIObject key) {
        IndividualValueCollector collector = new IndividualValueCollector();
        key.accept(collector);
        return collector.getValue();
    }

    public ABox getABox() {
        return this._abox;
    }

    public int hashCode() {
        return this._dataVars.hashCode() + this._instanceVars.hashCode();
    }

    public Literal set(AtomDObject key, Literal value) {
        ValueSettingVisitor visitor = new ValueSettingVisitor(null, value);
        key.accept(visitor);
        return visitor.getData();
    }

    public Literal set(AtomDVariable key, ATermAppl value) {
        AtomDConstant constant = new AtomDConstant(value);
        DataValueCollector collector = new DataValueCollector();
        constant.accept(collector);
        return this.set((AtomDObject)key, collector.getValue());
    }

    public Individual set(AtomIObject key, Individual value) {
        ValueSettingVisitor visitor = new ValueSettingVisitor(value, null);
        key.accept(visitor);
        return visitor.getIndividual();
    }

    public Individual set(AtomIVariable key, ATermAppl value) {
        AtomIConstant constant = new AtomIConstant(value);
        IndividualValueCollector collector = new IndividualValueCollector();
        constant.accept(collector);
        return this.set((AtomIObject)key, collector.getValue());
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer("{");
        buffer.append(this._instanceVars);
        buffer.append(", ");
        buffer.append(this._dataVars);
        buffer.append("}");
        return buffer.toString();
    }

    private class ValueSettingVisitor
    implements AtomObjectVisitor {
        private Literal _data;
        private Individual _individual;

        public ValueSettingVisitor(Individual individual, Literal data) {
            this._data = data;
            this._individual = individual;
        }

        public Literal getData() {
            return this._data;
        }

        public Individual getIndividual() {
            return this._individual;
        }

        @Override
        public void visit(AtomDConstant constant) {
            this._data = null;
        }

        @Override
        public void visit(AtomDVariable var) {
            if (this._data != null) {
                this._data = VariableBinding.this._dataVars.put(var, this._data);
            }
        }

        @Override
        public void visit(AtomIConstant constant) {
            this._individual = null;
        }

        @Override
        public void visit(AtomIVariable var) {
            if (this._individual != null) {
                this._individual = VariableBinding.this._instanceVars.put(var, this._individual);
            }
        }
    }

    private class IndividualValueCollector
    implements AtomObjectVisitor {
        private Individual value = null;

        private IndividualValueCollector() {
        }

        public Individual getValue() {
            return this.value;
        }

        @Override
        public void visit(AtomIConstant constant) {
            VariableBinding.this._abox.copyOnWrite();
            this.value = VariableBinding.this._abox.getIndividual(constant.getValue());
        }

        @Override
        public void visit(AtomIVariable variable) {
            this.value = (Individual)VariableBinding.this._instanceVars.get(variable);
        }
    }

    private class DataValueCollector
    implements AtomObjectVisitor {
        private Literal _value = null;

        private DataValueCollector() {
        }

        public Literal getValue() {
            return this._value;
        }

        @Override
        public void visit(AtomDConstant constant) {
            ATermAppl canonical;
            ATermAppl literal = constant.getValue();
            try {
                canonical = VariableBinding.this._abox.getKB().getDatatypeReasoner().getCanonicalRepresentation(literal);
            }
            catch (InvalidLiteralException e) {
                String msg = String.format("Invalid literal (%s) in SWRL _data constant: %s", literal, e.getMessage());
                if (OpenlletOptions.INVALID_LITERAL_AS_INCONSISTENCY) {
                    canonical = literal;
                }
                _logger.severe(msg);
                throw new InternalReasonerException(msg, e);
            }
            catch (UnrecognizedDatatypeException e) {
                String msg = String.format("Unrecognized datatype in literal appearing (%s) in SWRL _data constant: %s", literal, e.getMessage());
                _logger.severe(msg);
                throw new InternalReasonerException(msg, e);
            }
            VariableBinding.this._abox.copyOnWrite();
            this._value = VariableBinding.this._abox.getLiteral(canonical);
            if (this._value == null) {
                this._value = VariableBinding.this._abox.addLiteral(canonical);
            }
        }

        @Override
        public void visit(AtomDVariable variable) {
            this._value = (Literal)VariableBinding.this._dataVars.get(variable);
        }
    }
}

