/*
 * Decompiled with CFR 0.152.
 */
package openllet.core.rules;

import java.util.Collection;
import java.util.HashSet;
import openllet.core.rules.model.AtomDVariable;
import openllet.core.rules.model.AtomIVariable;
import openllet.core.rules.model.AtomObject;
import openllet.core.rules.model.AtomObjectVisitor;
import openllet.core.rules.model.AtomVariable;
import openllet.core.rules.model.RuleAtom;

public class VariableUtils {
    public static Collection<AtomDVariable> getDVars(RuleAtom atom) {
        VisitingDCollector collector = new VisitingDCollector();
        for (AtomObject atomObject : atom.getAllArguments()) {
            atomObject.accept(collector);
        }
        return collector.getVariables();
    }

    public static Collection<AtomIVariable> getIVars(RuleAtom atom) {
        VisitingICollector collector = new VisitingICollector();
        for (AtomObject atomObject : atom.getAllArguments()) {
            atomObject.accept(collector);
        }
        return collector.getVariables();
    }

    public static Collection<AtomVariable> getVars(RuleAtom atom) {
        VisitingCollector collector = new VisitingCollector();
        for (AtomObject atomObject : atom.getAllArguments()) {
            atomObject.accept(collector);
        }
        return collector.getVariables();
    }

    public static boolean isVariable(AtomObject obj) {
        VisitingCollector collector = new VisitingCollector();
        obj.accept(collector);
        return collector.getVariables().size() == 1;
    }

    private static class VisitingICollector
    implements AtomObjectVisitor {
        private final Collection<AtomIVariable> _variables = new HashSet<AtomIVariable>();

        private VisitingICollector() {
        }

        public Collection<AtomIVariable> getVariables() {
            return this._variables;
        }

        @Override
        public void visit(AtomIVariable var) {
            this._variables.add(var);
        }
    }

    private static class VisitingDCollector
    implements AtomObjectVisitor {
        private final Collection<AtomDVariable> _variables = new HashSet<AtomDVariable>();

        private VisitingDCollector() {
        }

        public Collection<AtomDVariable> getVariables() {
            return this._variables;
        }

        @Override
        public void visit(AtomDVariable var) {
            this._variables.add(var);
        }
    }

    private static class VisitingCollector
    implements AtomObjectVisitor {
        private final Collection<AtomVariable> _variables = new HashSet<AtomVariable>();

        private VisitingCollector() {
        }

        public Collection<AtomVariable> getVariables() {
            return this._variables;
        }

        @Override
        public void visit(AtomDVariable var) {
            this._variables.add(var);
        }

        @Override
        public void visit(AtomIVariable var) {
            this._variables.add(var);
        }
    }
}

