/*
 * Decompiled with CFR 0.152.
 */
package openllet.core.rules.builtins;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import openllet.core.boxes.abox.ABox;
import openllet.core.boxes.abox.Literal;
import openllet.core.exceptions.InternalReasonerException;
import openllet.core.rules.BindingHelper;
import openllet.core.rules.VariableBinding;
import openllet.core.rules.VariableUtils;
import openllet.core.rules.builtins.BuiltIn;
import openllet.core.rules.builtins.BuiltInRegistry;
import openllet.core.rules.builtins.GeneralFunction;
import openllet.core.rules.model.AtomDObject;
import openllet.core.rules.model.AtomDVariable;
import openllet.core.rules.model.AtomVariable;
import openllet.core.rules.model.BuiltInAtom;
import openllet.core.utils.SetUtils;

public class GeneralFunctionBuiltIn
implements BuiltIn {
    private final GeneralFunction _function;

    public GeneralFunctionBuiltIn(GeneralFunction function) {
        this._function = function;
    }

    @Override
    public BindingHelper createHelper(BuiltInAtom atom) {
        return new GeneralFunctionHelper(atom);
    }

    @Override
    public boolean apply(ABox abox, Literal[] args) {
        return this._function.apply(abox, args);
    }

    private class GeneralFunctionHelper
    implements BindingHelper {
        private final BuiltInAtom _atom;
        private VariableBinding _partial;
        private boolean _used;

        public GeneralFunctionHelper(BuiltInAtom atom) {
            this._atom = atom;
        }

        @Override
        public Collection<? extends AtomVariable> getBindableVars(Collection<AtomVariable> bound) {
            if (!this.isApplicable(bound)) {
                return Collections.emptySet();
            }
            return SetUtils.difference(VariableUtils.getVars(this._atom), bound);
        }

        @Override
        public Collection<? extends AtomVariable> getPrerequisiteVars(Collection<AtomVariable> bound) {
            Collection<AtomVariable> vars = VariableUtils.getVars(this._atom);
            vars.removeAll(this.getBindableVars(bound));
            return vars;
        }

        private boolean isApplicable(Collection<AtomVariable> bound) {
            boolean[] boundPositions = new boolean[this._atom.getAllArguments().size()];
            for (int i = 0; i < boundPositions.length; ++i) {
                boundPositions[i] = bound.contains(this._atom.getAllArguments().get(i));
            }
            return GeneralFunctionBuiltIn.this._function.isApplicable(boundPositions);
        }

        @Override
        public void rebind(VariableBinding newBinding) {
            Object[] arguments = new Literal[this._atom.getAllArguments().size()];
            for (int i = 0; i < arguments.length; ++i) {
                arguments[i] = newBinding.get(this._atom.getAllArguments().get(i));
            }
            if (GeneralFunctionBuiltIn.this._function.apply(newBinding.getABox(), (Literal[])arguments)) {
                VariableBinding newPartial = new VariableBinding(newBinding.getABox());
                for (int i = 0; i < arguments.length; ++i) {
                    AtomDObject arg = this._atom.getAllArguments().get(i);
                    Object result = arguments[i];
                    Literal current = newBinding.get(arg);
                    if (current != null && !current.equals(result)) {
                        if (newBinding.get(arg) != null) {
                            throw new InternalReasonerException("General Function implementation overwrote one of its arguments!");
                        }
                        BuiltInRegistry._logger.info("Function results in multiple simultaneous values for variable");
                        return;
                    }
                    if (current != null) continue;
                    newBinding.set(arg, (Literal)result);
                }
                this._used = false;
                this._partial = newPartial;
            } else {
                System.out.println("Function failure: " + this._atom);
                System.out.println("Arguments: " + Arrays.toString(arguments));
            }
        }

        @Override
        public boolean selectNextBinding() {
            if (this._partial != null && !this._used) {
                this._used = true;
                return true;
            }
            return false;
        }

        @Override
        public void setCurrentBinding(VariableBinding currentBinding) {
            for (Map.Entry<AtomDVariable, Literal> entry : this._partial.dataEntrySet()) {
                currentBinding.set((AtomDObject)entry.getKey(), entry.getValue());
            }
        }
    }
}

