/*
 * Decompiled with CFR 0.152.
 */
package openllet.core.rules.builtins;

import openllet.core.boxes.abox.ABox;
import openllet.core.boxes.abox.Literal;
import openllet.core.rules.builtins.BuiltInRegistry;
import openllet.core.rules.builtins.Function;
import openllet.core.rules.builtins.FunctionApplicationVisitor;
import openllet.core.rules.builtins.NumberToLiteralVisitor;
import openllet.core.rules.builtins.NumericFunction;
import openllet.core.rules.builtins.NumericPromotion;

public class NumericAdapter
implements Function {
    private final NumericFunction _function;

    public NumericAdapter(NumericFunction function) {
        this._function = function;
    }

    @Override
    public Literal apply(ABox abox, Literal expected, Literal ... args) {
        Number expectedNum = null;
        Number result = null;
        Literal resultLit = null;
        if (expected != null) {
            if (!(expected.getValue() instanceof Number)) {
                BuiltInRegistry._logger.info("Testing non-numeric against the result of a numeric _function '" + this._function + "': " + expected);
                return null;
            }
            expectedNum = (Number)expected.getValue();
        }
        Number[] numArgs = new Number[args.length];
        for (int i = 0; i < args.length; ++i) {
            if (!(args[i].getValue() instanceof Number)) {
                BuiltInRegistry._logger.info("Non numeric arguments to numeric _function '" + this._function + "': " + args[i]);
                return null;
            }
            numArgs[i] = (Number)args[i].getValue();
        }
        NumericPromotion promoter = new NumericPromotion();
        promoter.promote(numArgs);
        FunctionApplicationVisitor visitor = new FunctionApplicationVisitor(this._function, expectedNum);
        promoter.accept(visitor);
        result = visitor.getResult();
        if (result != null) {
            if (expected != null) {
                resultLit = expected;
            } else {
                NumberToLiteralVisitor converter = new NumberToLiteralVisitor(abox);
                promoter.promote(result);
                promoter.accept(converter);
                resultLit = converter.getLiteral();
            }
        }
        return resultLit;
    }
}

