/*
 * Decompiled with CFR 0.152.
 */
package openllet.core.rules.builtins;

import openllet.aterm.ATermAppl;
import openllet.core.boxes.abox.ABox;
import openllet.core.boxes.abox.Literal;
import openllet.core.rules.builtins.ComparisonTesters;
import openllet.core.rules.builtins.Function;
import openllet.core.rules.builtins.StringToStringFunction;
import openllet.core.utils.ATermUtils;

public class StringFunctionAdapter
implements Function {
    public final String _datatypeURI;
    public final StringToStringFunction _function;

    public StringFunctionAdapter(StringToStringFunction function) {
        this(function, null);
    }

    public StringFunctionAdapter(StringToStringFunction function, String datatypeURI) {
        this._datatypeURI = datatypeURI;
        this._function = function;
    }

    @Override
    public Literal apply(ABox abox, Literal expected, Literal ... litArgs) {
        String[] args = new String[litArgs.length];
        for (int i = 0; i < litArgs.length; ++i) {
            args[i] = ATermUtils.getLiteralValue(litArgs[i].getTerm());
        }
        String result = this._function.apply(args);
        if (result == null) {
            return null;
        }
        ATermAppl resultTerm = this._datatypeURI == null ? ATermUtils.makePlainLiteral(result) : ATermUtils.makeTypedLiteral(result, this._datatypeURI);
        Literal resultLit = abox.addLiteral(resultTerm);
        return ComparisonTesters.expectedIfEquals(expected, resultLit);
    }
}

