/*
 * Decompiled with CFR 0.152.
 */
package openllet.core.rules.builtins;

import java.net.URI;
import java.net.URISyntaxException;
import openllet.core.exceptions.InternalReasonerException;
import openllet.core.rules.builtins.Function;
import openllet.core.rules.builtins.StringFunctionAdapter;
import openllet.core.rules.builtins.StringToStringFunction;

public class URIOperators {
    public static final Function resolveURI = new StringFunctionAdapter(new ResolveURI());
    public static final Function anyURI = new StringFunctionAdapter(new AnyURI());

    private static class AnyURI
    implements StringToStringFunction {
        private AnyURI() {
        }

        @Override
        public String apply(String ... args) {
            if (args.length != 6) {
                throw new InternalReasonerException("AnyURI wrong number of arguments");
            }
            String schema = args[0];
            String host = args[1];
            String port = args[2];
            String path = args[3];
            String query = args[4];
            String fragment = args[5];
            if (!schema.endsWith(":")) {
                schema = schema + ":";
            }
            if (!host.startsWith("//")) {
                host = "//" + host;
            }
            if (port.length() > 0 && !port.startsWith(":")) {
                port = ":" + port;
            }
            if (path.length() > 0 && !path.startsWith("/")) {
                path = "/" + path;
            }
            if (query.length() > 0 && !query.startsWith("?")) {
                query = "?" + query;
            }
            if (fragment.length() > 0 && !fragment.startsWith("#")) {
                fragment = "#" + fragment;
            }
            try {
                return new URI(schema + host + port + path + query + fragment).toASCIIString();
            }
            catch (URISyntaxException e) {
                throw new InternalReasonerException("Returned string is not a URI", e);
            }
        }
    }

    private static class ResolveURI
    implements StringToStringFunction {
        private ResolveURI() {
        }

        @Override
        public String apply(String ... args) {
            URI baseURI;
            URI relativeURI;
            if (args.length != 2) {
                throw new InternalReasonerException("ResolveURI takes two and only two arguments");
            }
            String relative = args[0];
            String base = args[1];
            if (relative.length() == 0) {
                return relative;
            }
            try {
                relativeURI = new URI(relative);
                if (relativeURI.isAbsolute()) {
                    return relative;
                }
            }
            catch (URISyntaxException e) {
                throw new InternalReasonerException("Relative URI reference is not a valid URI", e);
            }
            try {
                baseURI = new URI(base);
            }
            catch (URISyntaxException e) {
                throw new InternalReasonerException("Base URI reference is not a valid URI", e);
            }
            try {
                URI ret = new URI(baseURI.toASCIIString() + relativeURI.toASCIIString());
                return ret.toASCIIString();
            }
            catch (URISyntaxException e) {
                throw new InternalReasonerException("Evaluation of base and relative URI is not a URI", e);
            }
        }
    }
}

