/*
 * Decompiled with CFR 0.152.
 */
package openllet.core.rules.rete;

import java.util.Iterator;
import openllet.core.DependencySet;
import openllet.core.boxes.abox.ABox;
import openllet.core.boxes.abox.Individual;
import openllet.core.boxes.abox.Node;
import openllet.core.rules.model.DifferentIndividualsAtom;
import openllet.core.rules.model.RuleAtom;
import openllet.core.rules.rete.AlphaNode;
import openllet.core.rules.rete.WME;
import openllet.core.utils.iterator.MapIterator;
import openllet.core.utils.iterator.NestedIterator;

public class AlphaDiffFromNode
extends AlphaNode {
    public AlphaDiffFromNode(ABox abox) {
        super(abox);
    }

    public boolean activate(Individual s, Individual o, DependencySet ds) {
        this.activate(WME.createDiffFrom(s, o, ds));
        return true;
    }

    @Override
    public Iterator<WME> getMatches(int argIndex, Node arg) {
        if (argIndex != 0 && argIndex != 1) {
            throw new IndexOutOfBoundsException();
        }
        if (!(arg instanceof Individual)) {
            throw new IllegalArgumentException();
        }
        return AlphaDiffFromNode.toWMEs(arg);
    }

    private static Iterator<WME> toWMEs(final Node arg) {
        return new MapIterator<Node, WME>(arg.getDifferents().iterator()){

            @Override
            public WME map(Node node) {
                return WME.createDiffFrom((Individual)arg, (Individual)node, arg.getDifferenceDependency(node));
            }
        };
    }

    @Override
    public Iterator<WME> getMatches() {
        return new NestedIterator<Individual, WME>((Iterator)this._abox.getIndIterator()){

            @Override
            public Iterator<WME> getInnerIterator(Individual ind) {
                return AlphaDiffFromNode.toWMEs(ind);
            }
        };
    }

    @Override
    public boolean matches(RuleAtom atom) {
        return atom instanceof DifferentIndividualsAtom;
    }

    public String toString() {
        return "DiffFrom(0, 1)";
    }
}

