/*
 * Decompiled with CFR 0.152.
 */
package openllet.core.rules.rete;

import java.util.Iterator;
import openllet.aterm.ATermAppl;
import openllet.core.boxes.abox.ABox;
import openllet.core.boxes.abox.Edge;
import openllet.core.boxes.abox.EdgeList;
import openllet.core.boxes.abox.Individual;
import openllet.core.boxes.abox.Node;
import openllet.core.boxes.rbox.Role;
import openllet.core.rules.model.AtomConstant;
import openllet.core.rules.model.AtomIConstant;
import openllet.core.rules.model.BinaryAtom;
import openllet.core.rules.model.DatavaluedPropertyAtom;
import openllet.core.rules.model.IndividualPropertyAtom;
import openllet.core.rules.model.RuleAtom;
import openllet.core.rules.rete.AlphaFixedEdgeNode;
import openllet.core.rules.rete.WME;
import openllet.core.utils.ATermUtils;

public class AlphaNoVarEdgeNode
extends AlphaFixedEdgeNode {
    private final ATermAppl _objectName;
    private Node _objectNode;

    public AlphaNoVarEdgeNode(ABox abox, Role role, ATermAppl subjectName, ATermAppl objectName) {
        super(abox, role, subjectName);
        this._objectName = objectName;
    }

    protected Node initObjectNode() {
        if (this._objectNode == null) {
            this._objectNode = this.initNode(this._objectName);
        }
        assert (this._objectNode != null);
        return this._objectNode;
    }

    @Override
    public boolean activate(Edge edge) {
        Individual subject = (Individual)this.initNode();
        Node object = this.initObjectNode();
        WME.EdgeDirection dir = this.edgeMatches(edge);
        if (dir != null && (dir == WME.EdgeDirection.FORWARD ? edge.getFrom() : edge.getTo()).isSame(subject) && (dir == WME.EdgeDirection.BACKWARD ? edge.getFrom() : edge.getTo()).isSame(object)) {
            this.activate(WME.createEdge(edge, dir));
            return true;
        }
        return false;
    }

    @Override
    public Iterator<WME> getMatches(int argIndex, Node arg) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Iterator<WME> getMatches() {
        Individual subject = (Individual)this.initNode();
        Node object = this.initObjectNode();
        EdgeList edges = subject.getEdgesTo(object, this._role);
        return this.toWMEs(edges, WME.EdgeDirection.FORWARD);
    }

    @Override
    public boolean matches(RuleAtom atom) {
        return (atom instanceof IndividualPropertyAtom || atom instanceof DatavaluedPropertyAtom) && atom.getPredicate().equals(this._role.getName()) && ((BinaryAtom)atom).getArgument1() instanceof AtomIConstant && ((AtomIConstant)((BinaryAtom)atom).getArgument1()).getValue().equals(this._name) && ((BinaryAtom)atom).getArgument2() instanceof AtomConstant && ((AtomConstant)((BinaryAtom)atom).getArgument2()).getValue().equals(this._objectName);
    }

    @Override
    public String toString() {
        return ATermUtils.toString(this._role.getName()) + "(" + ATermUtils.toString(this._name) + ", " + ATermUtils.toString(this._objectName) + ")";
    }
}

