/*
 * Decompiled with CFR 0.152.
 */
package openllet.core.rules.rete;

import java.util.Iterator;
import openllet.core.boxes.abox.ABox;
import openllet.core.boxes.abox.Edge;
import openllet.core.boxes.abox.EdgeList;
import openllet.core.boxes.abox.Individual;
import openllet.core.boxes.abox.Node;
import openllet.core.boxes.rbox.Role;
import openllet.core.rules.model.AtomVariable;
import openllet.core.rules.model.BinaryAtom;
import openllet.core.rules.model.DatavaluedPropertyAtom;
import openllet.core.rules.model.IndividualPropertyAtom;
import openllet.core.rules.model.RuleAtom;
import openllet.core.rules.rete.AlphaEdgeNode;
import openllet.core.rules.rete.WME;
import openllet.core.utils.ATermUtils;
import openllet.core.utils.iterator.NestedIterator;

public class AlphaReflexiveEdgeNode
extends AlphaEdgeNode {
    public AlphaReflexiveEdgeNode(ABox abox, Role role) {
        super(abox, role);
    }

    @Override
    public boolean activate(Edge edge) {
        assert (this.edgeMatches(edge) != null);
        if (edge.getFromName().equals(edge.getToName())) {
            this.activate(WME.createEdge(edge));
            return true;
        }
        return false;
    }

    @Override
    public Iterator<WME> getMatches(int argIndex, Node arg) {
        EdgeList edges = ((Individual)arg).getRNeighborEdges(this._role, arg);
        return this.toWMEs(edges, WME.EdgeDirection.FORWARD);
    }

    @Override
    public Iterator<WME> getMatches() {
        return new NestedIterator<Individual, WME>((Iterator)this._abox.getIndIterator()){

            @Override
            public Iterator<WME> getInnerIterator(Individual ind) {
                return AlphaReflexiveEdgeNode.this.toWMEs(ind.getEdgesTo(ind), WME.EdgeDirection.FORWARD);
            }
        };
    }

    @Override
    public boolean matches(RuleAtom atom) {
        return (atom instanceof IndividualPropertyAtom || atom instanceof DatavaluedPropertyAtom) && atom.getPredicate().equals(this._role.getName()) && ((BinaryAtom)atom).getArgument1() instanceof AtomVariable && ((BinaryAtom)atom).getArgument2().equals(((BinaryAtom)atom).getArgument1());
    }

    @Override
    public String toString() {
        return ATermUtils.toString(this._role.getName()) + "(0, 0)";
    }
}

