/*
 * Decompiled with CFR 0.152.
 */
package openllet.core.rules.rete;

import java.util.Iterator;
import openllet.aterm.ATermAppl;
import openllet.core.DependencySet;
import openllet.core.boxes.abox.ABox;
import openllet.core.boxes.abox.Individual;
import openllet.core.boxes.abox.Node;
import openllet.core.rules.model.AtomIConstant;
import openllet.core.rules.model.AtomVariable;
import openllet.core.rules.model.ClassAtom;
import openllet.core.rules.model.RuleAtom;
import openllet.core.rules.rete.AlphaNode;
import openllet.core.rules.rete.WME;
import openllet.core.utils.ATermUtils;
import openllet.core.utils.iterator.IteratorUtils;
import openllet.core.utils.iterator.NestedIterator;

public class AlphaTypeNode
extends AlphaNode {
    private final ATermAppl _predicate;
    private final ATermAppl _name;
    private Individual _node;

    public AlphaTypeNode(ABox abox, ATermAppl predicate) {
        this(abox, predicate, null);
    }

    public AlphaTypeNode(ABox abox, ATermAppl predicate, ATermAppl name) {
        super(abox);
        this._predicate = predicate;
        this._name = name;
    }

    protected Individual initNode() {
        if (this._node == null) {
            this._node = (Individual)this.initNode(this._name);
        }
        assert (this._node != null);
        return this._node;
    }

    public boolean activate(Individual ind, ATermAppl type, DependencySet ds) {
        Individual node;
        assert (this._predicate.equals(type));
        if (this._name != null && !ind.isSame(node = this.initNode())) {
            return false;
        }
        this.activate(WME.createType(ind, type, ds));
        return true;
    }

    @Override
    public Iterator<WME> getMatches(int argIndex, Node arg) {
        if (this._name != null || argIndex != 0) {
            throw new IndexOutOfBoundsException();
        }
        if (!(arg instanceof Individual)) {
            throw new IllegalArgumentException();
        }
        DependencySet depends = arg.getDepends(this._predicate);
        return depends == null ? IteratorUtils.emptyIterator() : IteratorUtils.singletonIterator(WME.createType((Individual)arg, this._predicate, depends));
    }

    @Override
    public Iterator<WME> getMatches() {
        Iterator<Individual> inds = this._name == null ? this._abox.getIndIterator() : IteratorUtils.singletonIterator(this.initNode());
        return new NestedIterator<Individual, WME>((Iterator)inds){

            @Override
            public Iterator<WME> getInnerIterator(Individual ind) {
                DependencySet depends = ind.getDepends(AlphaTypeNode.this._predicate);
                return depends == null ? IteratorUtils.emptyIterator() : IteratorUtils.singletonIterator(WME.createType(ind, AlphaTypeNode.this._predicate, depends));
            }
        };
    }

    @Override
    public boolean matches(RuleAtom atom) {
        return atom instanceof ClassAtom && atom.getPredicate().equals(this._predicate) && this.argMatches((ClassAtom)atom);
    }

    private boolean argMatches(ClassAtom atom) {
        Object arg = atom.getArgument();
        return this._name == null ? arg instanceof AtomVariable : arg instanceof AtomIConstant && ((AtomIConstant)arg).getValue().equals(this._name);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this._predicate.hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof AlphaTypeNode)) {
            return false;
        }
        AlphaTypeNode other = (AlphaTypeNode)obj;
        return this._predicate.equals(other._predicate) && (this._name == null ? other._name == null : this._name.equals(other._name));
    }

    public String toString() {
        return ATermUtils.toString(this._predicate) + "(" + (this._name == null ? "0" : this._name) + ")";
    }
}

