/*
 * Decompiled with CFR 0.152.
 */
package openllet.core.rules.rete;

import java.util.Iterator;
import java.util.List;
import openllet.core.rules.rete.AlphaNode;
import openllet.core.rules.rete.BetaMemoryIndex;
import openllet.core.rules.rete.BetaNode;
import openllet.core.rules.rete.FilterCondition;
import openllet.core.rules.rete.JoinCondition;
import openllet.core.rules.rete.Token;
import openllet.core.rules.rete.WME;

public class BetaMemoryNode
extends BetaNode {
    private final BetaMemoryIndex _memory;
    private final AlphaNode _alpha;
    private final List<FilterCondition> _conditions;

    public BetaMemoryNode(AlphaNode alpha, List<FilterCondition> conditions) {
        if (conditions == null) {
            throw new NullPointerException();
        }
        this._alpha = alpha;
        this._conditions = conditions;
        this._memory = BetaMemoryNode.createIndex(conditions);
    }

    private static BetaMemoryIndex createIndex(List<FilterCondition> conditions) {
        if (!conditions.isEmpty() && conditions.get(0) instanceof JoinCondition) {
            return BetaMemoryIndex.withJoin((JoinCondition)conditions.get(0));
        }
        return BetaMemoryIndex.withoutJoin();
    }

    public AlphaNode getAlphaNode() {
        return this._alpha;
    }

    public List<FilterCondition> getConditions() {
        return this._conditions;
    }

    @Override
    public void activate(WME wme) {
        _logger.fine(() -> "Activate beta " + wme);
        Iterator<Token> wmeTokens = this._memory.getTokens(wme);
        while (wmeTokens.hasNext()) {
            Token token = wmeTokens.next();
            if (!this.testConditions(wme, token, 0)) continue;
            this.activateChildren(wme, token);
        }
    }

    @Override
    public void activate(Token token) {
        _logger.fine(() -> "Activate beta " + token);
        this._memory.add(token);
        Iterator<WME> matches = this._memory.getWMEs(token, this._alpha);
        while (matches.hasNext()) {
            WME wme = matches.next();
            if (!this.testConditions(wme, token, this._memory.isJoined() ? 1 : 0)) continue;
            this.activateChildren(wme, token);
        }
    }

    private boolean testConditions(WME wme, Token token, int start) {
        int n = this._conditions.size();
        for (int i = start; i < n; ++i) {
            FilterCondition condition = this._conditions.get(i);
            if (condition.test(wme, token)) continue;
            return false;
        }
        return true;
    }

    @Override
    public void reset() {
        super.reset();
        this._memory.clear();
    }

    @Override
    public void restore(int branch) {
        super.restore(branch);
        this._memory.restore(branch);
    }

    @Override
    public void print(String indentLvl) {
        System.out.print(indentLvl);
        System.out.println(this._alpha);
        String indent = indentLvl + "  ";
        System.out.print(indent);
        System.out.print(this);
        System.out.print(" ");
        System.out.println(this._memory);
        for (BetaNode node : this.getBetas()) {
            node.print(indent);
        }
    }

    public String toString() {
        return this.isTop() ? "Top" : "Beta" + this._conditions;
    }
}

