/*
 * Decompiled with CFR 0.152.
 */
package openllet.core.rules.rete;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import openllet.aterm.ATerm;
import openllet.aterm.ATermAppl;
import openllet.core.DependencySet;
import openllet.core.OpenlletOptions;
import openllet.core.boxes.abox.ABox;
import openllet.core.boxes.abox.Individual;
import openllet.core.boxes.rbox.Role;
import openllet.core.datatypes.exceptions.InvalidLiteralException;
import openllet.core.datatypes.exceptions.UnrecognizedDatatypeException;
import openllet.core.exceptions.InternalReasonerException;
import openllet.core.rules.BindingHelper;
import openllet.core.rules.ContinuousRulesStrategy;
import openllet.core.rules.VariableUtils;
import openllet.core.rules.builtins.BuiltIn;
import openllet.core.rules.builtins.BuiltInRegistry;
import openllet.core.rules.model.AtomDConstant;
import openllet.core.rules.model.AtomDObject;
import openllet.core.rules.model.AtomDVariable;
import openllet.core.rules.model.AtomIConstant;
import openllet.core.rules.model.AtomIVariable;
import openllet.core.rules.model.AtomObject;
import openllet.core.rules.model.AtomObjectVisitor;
import openllet.core.rules.model.AtomVariable;
import openllet.core.rules.model.BuiltInAtom;
import openllet.core.rules.model.ClassAtom;
import openllet.core.rules.model.DataRangeAtom;
import openllet.core.rules.model.DatavaluedPropertyAtom;
import openllet.core.rules.model.DifferentIndividualsAtom;
import openllet.core.rules.model.IndividualPropertyAtom;
import openllet.core.rules.model.Rule;
import openllet.core.rules.model.RuleAtom;
import openllet.core.rules.model.RuleAtomVisitor;
import openllet.core.rules.model.SameIndividualAtom;
import openllet.core.rules.rete.AlphaNetwork;
import openllet.core.rules.rete.AlphaNode;
import openllet.core.rules.rete.BetaBuiltinNode;
import openllet.core.rules.rete.BetaMemoryNode;
import openllet.core.rules.rete.BetaNode;
import openllet.core.rules.rete.BetaTopNode;
import openllet.core.rules.rete.BuiltInCondition;
import openllet.core.rules.rete.FilterCondition;
import openllet.core.rules.rete.JoinCondition;
import openllet.core.rules.rete.NodeProvider;
import openllet.core.rules.rete.ProductionNode;
import openllet.core.rules.rete.ReteNode;
import openllet.core.utils.SetUtils;

public class Compiler {
    protected ContinuousRulesStrategy _strategy;
    private final ABox _abox;
    private final AlphaNetwork _alphaNet;
    private final SafetyChecker _safetyChecker = new SafetyChecker();

    public Compiler(ContinuousRulesStrategy strategy) {
        this._strategy = strategy;
        this._abox = strategy.getABox();
        this._alphaNet = new AlphaNetwork(this._abox);
    }

    public AlphaNetwork getAlphaNet() {
        return this._alphaNet;
    }

    private RuleAtom pickNextAtom(List<RuleAtom> atoms, Set<AtomVariable> bound) {
        int index = 0;
        if (bound.isEmpty()) {
            for (int i = 0; i < atoms.size(); ++i) {
                RuleAtom atom = atoms.get(i);
                if (!this._safetyChecker.isSafe(atom)) continue;
                return atoms.remove(i);
            }
        } else {
            for (int i = 0; i < atoms.size(); ++i) {
                RuleAtom atom = atoms.get(i);
                if (!SetUtils.intersects(bound, atom.getAllArguments())) continue;
                index = i;
                if (!this._safetyChecker.isSafe(atom)) {
                    continue;
                }
                break;
            }
        }
        return atoms.remove(index);
    }

    /*
     * WARNING - void declaration
     */
    public void compile(Rule rule, Set<ATermAppl> explain) {
        ArrayList<RuleAtom> atoms = new ArrayList<RuleAtom>();
        ArrayList<BuiltInCall> builtins = new ArrayList<BuiltInCall>();
        for (RuleAtom ruleAtom : rule.getBody()) {
            if (ruleAtom instanceof BuiltInAtom) {
                builtins.add(new BuiltInCall(this._abox, (BuiltInAtom)ruleAtom));
                continue;
            }
            if (ruleAtom instanceof DataRangeAtom) continue;
            atoms.add(ruleAtom);
        }
        HashSet<AtomVariable> bound = new HashSet<AtomVariable>();
        ArrayList<RuleAtom> arrayList = new ArrayList<RuleAtom>();
        int lastSafe = -1;
        ReteNode lastSafeBeta = null;
        boolean canReuseBeta = false;
        RuleAtom atom = null;
        ReteNode node = null;
        while (!atoms.isEmpty()) {
            void var15_32;
            void var15_30;
            atom = this.pickNextAtom(atoms, bound);
            if (!this._safetyChecker.isSafe(atom)) {
                lastSafe = arrayList.size();
                lastSafeBeta = node;
            }
            AlphaNode alpha = this._alphaNet.addNode(atom);
            List<? extends AtomObject> args = atom.getAllArguments();
            ArrayList<FilterCondition> arrayList2 = new ArrayList<FilterCondition>();
            if (!arrayList.isEmpty()) {
                void var15_24;
                boolean bl = false;
                int n = args.size();
                while (var15_24 < n) {
                    NodeProvider.TokenNodeProvider provider;
                    AtomObject arg = args.get((int)var15_24);
                    if (arg instanceof AtomVariable && (provider = Compiler.createNodeProvider((AtomVariable)arg, arrayList)) != null) {
                        arrayList2.add(new JoinCondition(new NodeProvider.WMENodeProvider((int)var15_24), provider));
                    }
                    ++var15_24;
                }
            }
            arrayList.add(atom);
            bound.addAll(VariableUtils.getVars(atom));
            for (BuiltInCall call : builtins) {
                Collection<? extends AtomVariable> bindableVars;
                if (!bound.containsAll(call.getPrerequisitesVars(bound)) || !(bindableVars = call.getBindableVars(bound)).isEmpty() && !bound.containsAll(bindableVars)) continue;
                arrayList2.add(call.createCondition(arrayList));
            }
            Object var15_26 = null;
            if (canReuseBeta) {
                if (node == null) {
                    for (BetaNode existingBeta : alpha.getBetas()) {
                        if (!existingBeta.isTop()) continue;
                        BetaNode betaNode = existingBeta;
                        break;
                    }
                } else {
                    for (BetaNode existingBeta : SetUtils.intersection(alpha.getBetas(), node.getBetas())) {
                        if (!(existingBeta instanceof BetaMemoryNode) || !arrayList2.equals(((BetaMemoryNode)existingBeta).getConditions())) continue;
                        BetaNode betaNode = existingBeta;
                        break;
                    }
                }
            }
            if (null == var15_30) {
                BetaNode betaNode = node == null ? new BetaTopNode(alpha) : new BetaMemoryNode(alpha, arrayList2);
                canReuseBeta = false;
            }
            alpha.addChild((BetaNode)var15_32);
            if (node != null) {
                node.addChild((BetaNode)var15_32);
            }
            node = var15_32;
            int bindingCount = -1;
            while (!builtins.isEmpty() && bindingCount != bound.size()) {
                bindingCount = bound.size();
                Iterator i = builtins.iterator();
                while (i.hasNext()) {
                    BuiltInCall call = (BuiltInCall)i.next();
                    if (!bound.containsAll(call.getPrerequisitesVars(bound))) continue;
                    BetaBuiltinNode betaBuiltinNode = call.createBeta(arrayList);
                    node.addChild(betaBuiltinNode);
                    node = betaBuiltinNode;
                    arrayList.add(call._atom);
                    bound.addAll(call.getBindableVars(bound));
                    canReuseBeta = false;
                    i.remove();
                }
            }
        }
        if (!builtins.isEmpty()) {
            throw new UnsupportedOperationException("Builtin using unsafe variables: " + builtins);
        }
        if (lastSafe == 0) {
            this._strategy.addUnsafeRule(rule, explain);
        } else if (lastSafe > 0) {
            HashMap<AtomVariable, NodeProvider> args = new HashMap<AtomVariable, NodeProvider>();
            for (int i = 0; i < lastSafe; ++i) {
                for (AtomObject atomObject : ((RuleAtom)arrayList.get(i)).getAllArguments()) {
                    if (!(atomObject instanceof AtomVariable) || args.containsKey(atomObject)) continue;
                    args.put((AtomVariable)atomObject, Compiler.createNodeProvider((AtomVariable)atomObject, arrayList));
                }
            }
            if (lastSafeBeta != null) {
                lastSafeBeta.addChild(new ProductionNode.ProduceBinding(this._strategy, explain, rule, args));
            }
        }
        if (node != null) {
            if (rule.getHead().isEmpty()) {
                node.addChild(new ProductionNode.Inconsistency(this._strategy, explain));
            } else {
                ProductionNodeCreator creator = new ProductionNodeCreator(arrayList, explain);
                for (RuleAtom ruleAtom : rule.getHead()) {
                    node.addChild(creator.create(ruleAtom));
                }
            }
        }
    }

    private static NodeProvider.TokenNodeProvider createNodeProvider(AtomVariable arg, List<RuleAtom> processed) {
        return (NodeProvider.TokenNodeProvider)Compiler.createNodeProvider(arg, processed, false);
    }

    private static NodeProvider createNodeProvider(AtomVariable arg, List<RuleAtom> processed, boolean lastWME) {
        int n = processed.size();
        for (int index = 0; index < n; ++index) {
            RuleAtom sharedAtom = processed.get(index);
            int indexArg = sharedAtom.getAllArguments().indexOf(arg);
            if (indexArg == -1) continue;
            if (lastWME && index == n - 1) {
                return new NodeProvider.WMENodeProvider(indexArg);
            }
            return new NodeProvider.TokenNodeProvider(index, indexArg);
        }
        return null;
    }

    private static class BuiltInCall {
        private final ABox _builtInCallAbox;
        private final BuiltInAtom _atom;
        private final BuiltIn _builtin;
        private final BindingHelper _helper;

        public BuiltInCall(ABox abox, BuiltInAtom atom) {
            this._builtInCallAbox = abox;
            this._atom = atom;
            this._builtin = BuiltInRegistry.instance.getBuiltIn((String)atom.getPredicate());
            this._helper = this._builtin.createHelper(atom);
        }

        public BetaBuiltinNode createBeta(List<RuleAtom> processed) {
            return new BetaBuiltinNode(this._builtInCallAbox, (String)this._atom.getPredicate(), this._builtin, this.createProviders(processed, false));
        }

        public FilterCondition createCondition(List<RuleAtom> processed) {
            return new BuiltInCondition(this._builtInCallAbox, (String)this._atom.getPredicate(), this._builtin, this.createProviders(processed, true));
        }

        private NodeProvider[] createProviders(List<RuleAtom> processed, boolean lastWME) {
            List<AtomDObject> args = this._atom.getAllArguments();
            NodeProvider[] providers = new NodeProvider[args.size()];
            AtomObjectTranslator translator = new AtomObjectTranslator(this._builtInCallAbox, processed, lastWME);
            for (int i = 0; i < providers.length; ++i) {
                providers[i] = translator.translateObject(args.get(i), true);
            }
            return providers;
        }

        public Collection<? extends AtomVariable> getPrerequisitesVars(Collection<AtomVariable> bound) {
            return this._helper.getPrerequisiteVars(bound);
        }

        public Collection<? extends AtomVariable> getBindableVars(Collection<AtomVariable> bound) {
            return this._helper.getBindableVars(bound);
        }

        public String toString() {
            return this._atom.toString();
        }
    }

    private static class AtomObjectTranslator
    implements AtomObjectVisitor {
        private DependencySet _dependency = DependencySet.INDEPENDENT;
        private NodeProvider _result = null;
        private final ABox _translatorAbox;
        private final List<RuleAtom> _processed;
        private final boolean _lastWME;

        public AtomObjectTranslator(ABox abox, List<RuleAtom> processed, boolean lastWME) {
            this._translatorAbox = abox;
            this._processed = processed;
            this._lastWME = lastWME;
        }

        public DependencySet getDependency() {
            return this._dependency;
        }

        public NodeProvider translateObject(AtomObject obj) {
            return this.translateObject(obj, false);
        }

        public NodeProvider translateObject(AtomObject obj, boolean allowNull) {
            this._dependency = DependencySet.INDEPENDENT;
            obj.accept(this);
            if (this._result == null && !allowNull) {
                throw new UnsupportedOperationException();
            }
            return this._result;
        }

        @Override
        public void visit(AtomDConstant constant) {
            ATermAppl canonical;
            ATermAppl literal = constant.getValue();
            try {
                canonical = this._translatorAbox.getKB().getDatatypeReasoner().getCanonicalRepresentation(literal);
            }
            catch (InvalidLiteralException e) {
                String msg = String.format("Invalid literal (%s) in SWRL _data constant: %s", literal, e.getMessage());
                if (OpenlletOptions.INVALID_LITERAL_AS_INCONSISTENCY) {
                    canonical = literal;
                }
                throw new InternalReasonerException(msg, e);
            }
            catch (UnrecognizedDatatypeException e) {
                String msg = String.format("Unrecognized datatype in literal appearing (%s) in SWRL _data constant: %s", literal, e.getMessage());
                throw new InternalReasonerException(msg, e);
            }
            this._result = new NodeProvider.ConstantNodeProvider(this._translatorAbox.addLiteral(canonical));
        }

        @Override
        public void visit(AtomDVariable variable) {
            this._result = Compiler.createNodeProvider(variable, this._processed, this._lastWME);
        }

        @Override
        public void visit(AtomIConstant constant) {
            this._translatorAbox.copyOnWrite();
            Individual individual = this._translatorAbox.getIndividual(constant.getValue());
            this._result = new NodeProvider.ConstantNodeProvider(individual);
        }

        @Override
        public void visit(AtomIVariable variable) {
            this._result = Compiler.createNodeProvider(variable, this._processed, this._lastWME);
        }
    }

    private class ProductionNodeCreator
    implements RuleAtomVisitor {
        private final AtomObjectTranslator _translator;
        private final Set<ATermAppl> _explain;
        private ProductionNode _node;

        public ProductionNodeCreator(List<RuleAtom> processed, Set<ATermAppl> explain) {
            this._translator = new AtomObjectTranslator(Compiler.this._abox, processed, false);
            this._explain = explain;
        }

        private ProductionNode create(RuleAtom atom) {
            this._node = null;
            atom.accept(this);
            if (this._node == null) {
                throw new UnsupportedOperationException("Not supported " + atom);
            }
            return this._node;
        }

        @Override
        public void visit(SameIndividualAtom atom) {
            NodeProvider s = this._translator.translateObject((AtomObject)atom.getArgument1());
            NodeProvider o = this._translator.translateObject((AtomObject)atom.getArgument2());
            this._node = new ProductionNode.SameAs(Compiler.this._strategy, this._explain, s, o);
        }

        @Override
        public void visit(IndividualPropertyAtom atom) {
            NodeProvider s = this._translator.translateObject((AtomObject)atom.getArgument1());
            NodeProvider o = this._translator.translateObject((AtomObject)atom.getArgument2());
            Role r = Compiler.this._abox.getRole((ATerm)atom.getPredicate());
            this._node = new ProductionNode.Edge(Compiler.this._strategy, this._explain, s, r, o);
        }

        @Override
        public void visit(DifferentIndividualsAtom atom) {
            NodeProvider s = this._translator.translateObject((AtomObject)atom.getArgument1());
            NodeProvider o = this._translator.translateObject((AtomObject)atom.getArgument2());
            this._node = new ProductionNode.DiffFrom(Compiler.this._strategy, this._explain, s, o);
        }

        @Override
        public void visit(DatavaluedPropertyAtom atom) {
            NodeProvider s = this._translator.translateObject((AtomObject)atom.getArgument1());
            NodeProvider o = this._translator.translateObject((AtomObject)atom.getArgument2());
            Role r = Compiler.this._abox.getRole((ATerm)atom.getPredicate());
            this._node = new ProductionNode.Edge(Compiler.this._strategy, this._explain, s, r, o);
        }

        @Override
        public void visit(DataRangeAtom atom) {
        }

        @Override
        public void visit(ClassAtom atom) {
            NodeProvider s = this._translator.translateObject((AtomObject)atom.getArgument());
            ATermAppl type = (ATermAppl)atom.getPredicate();
            this._node = new ProductionNode.Type(Compiler.this._strategy, this._explain, s, type);
        }

        @Override
        public void visit(BuiltInAtom atom) {
        }
    }

    private class SafetyChecker
    implements RuleAtomVisitor {
        private boolean result = false;

        private SafetyChecker() {
        }

        public boolean isSafe(RuleAtom atom) {
            atom.accept(this);
            return this.result;
        }

        @Override
        public void visit(BuiltInAtom atom) {
            this.result = true;
        }

        @Override
        public void visit(ClassAtom atom) {
            ATermAppl c = (ATermAppl)atom.getPredicate();
            this.result = Compiler.this._abox.getKB().getTBox().isPrimitive(c);
        }

        @Override
        public void visit(DataRangeAtom atom) {
            this.result = true;
        }

        @Override
        public void visit(DatavaluedPropertyAtom atom) {
            this.result = true;
        }

        @Override
        public void visit(DifferentIndividualsAtom atom) {
            this.result = false;
        }

        @Override
        public void visit(IndividualPropertyAtom atom) {
            this.result = Compiler.this._abox.getRole((ATerm)atom.getPredicate()).isSimple();
        }

        @Override
        public void visit(SameIndividualAtom atom) {
            this.result = true;
        }
    }
}

