/*
 * Decompiled with CFR 0.152.
 */
package openllet.core.tableau.cache;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import openllet.aterm.ATerm;
import openllet.aterm.ATermAppl;
import openllet.aterm.ATermInt;
import openllet.aterm.ATermList;
import openllet.core.DependencySet;
import openllet.core.KnowledgeBase;
import openllet.core.boxes.abox.Edge;
import openllet.core.boxes.abox.EdgeList;
import openllet.core.boxes.abox.Individual;
import openllet.core.boxes.rbox.Role;
import openllet.core.boxes.tbox.impl.Unfolding;
import openllet.core.exceptions.InternalReasonerException;
import openllet.core.tableau.cache.CachedNode;
import openllet.core.tableau.cache.CachedNodeFactory;
import openllet.core.tableau.cache.ConceptCache;
import openllet.core.utils.ATermUtils;
import openllet.core.utils.Bool;
import openllet.core.utils.MultiValueMap;
import openllet.core.utils.SetUtils;
import openllet.core.utils.TermFactory;
import openllet.core.utils.fsm.Transition;
import openllet.core.utils.fsm.TransitionGraph;
import openllet.shared.tools.Log;

public abstract class AbstractConceptCache
implements ConceptCache {
    public static final Logger _logger = Log.getLogger(AbstractConceptCache.class);
    private int _maxSize;

    public AbstractConceptCache(int maxSize) {
        this._maxSize = maxSize;
    }

    protected boolean isFull() {
        return this.size() == this._maxSize;
    }

    @Override
    public Bool getSat(ATermAppl c) {
        CachedNode cached = (CachedNode)this.get(c);
        return cached == null ? Bool.UNKNOWN : Bool.create(!cached.isBottom());
    }

    @Override
    public boolean putSat(ATermAppl c, boolean isSatisfiable) {
        CachedNode cached = (CachedNode)this.get(c);
        if (cached != null) {
            if (isSatisfiable != !cached.isBottom()) {
                throw new InternalReasonerException("Caching inconsistent results for " + c);
            }
            return false;
        }
        if (isSatisfiable) {
            this.put(c, CachedNodeFactory.createSatisfiableNode());
        } else {
            ATermAppl notC = ATermUtils.negate(c);
            this.put(c, CachedNodeFactory.createBottomNode());
            this.put(notC, CachedNodeFactory.createTopNode());
        }
        return true;
    }

    @Override
    public int getMaxSize() {
        return this._maxSize;
    }

    @Override
    public void setMaxSize(int maxSize) {
        this._maxSize = maxSize;
    }

    private static Bool checkTrivialClash(CachedNode node1, CachedNode node2) {
        if (node1.isBottom() || node2.isBottom()) {
            return Bool.TRUE;
        }
        if (node1.isTop() || node2.isTop()) {
            return Bool.FALSE;
        }
        if (!node1.isComplete() || !node2.isComplete()) {
            return Bool.UNKNOWN;
        }
        return null;
    }

    @Override
    public Bool isMergable(KnowledgeBase kb, CachedNode root1, CachedNode root2) {
        Bool clash;
        boolean bothNamedIndividuals;
        Bool result = AbstractConceptCache.checkTrivialClash(root1, root2);
        if (result != null) {
            return result.not();
        }
        CachedNode[] roots = new CachedNode[]{root1, root2};
        boolean isIndependent = root1.isIndependent() && root2.isIndependent();
        int root = roots[0].getDepends().size() < roots[1].getDepends().size() ? 0 : 1;
        int otherRoot = 1 - root;
        for (Map.Entry<ATermAppl, DependencySet> entry : roots[root].getDepends().entrySet()) {
            boolean allIndependent;
            ATermAppl c = entry.getKey();
            ATermAppl notC = ATermUtils.negate(c);
            DependencySet ds2 = roots[otherRoot].getDepends().get(notC);
            if (ds2 == null) continue;
            DependencySet ds1 = entry.getValue();
            boolean bl = allIndependent = isIndependent && ds1.isIndependent() && ds2.isIndependent();
            if (allIndependent) {
                return Bool.FALSE;
            }
            result = Bool.UNKNOWN;
        }
        if (result != null) {
            return result;
        }
        for (root = 0; root < 2; ++root) {
            otherRoot = 1 - root;
            for (ATermAppl c : roots[root].getDepends().keySet()) {
                if (ATermUtils.isPrimitive(c)) {
                    result = AbstractConceptCache.checkBinaryClash(kb, c, roots[root], roots[otherRoot]);
                } else if (ATermUtils.isAllValues(c)) {
                    result = AbstractConceptCache.checkAllValuesClash(kb, c, roots[root], roots[otherRoot]);
                } else if (ATermUtils.isNot(c)) {
                    ATermAppl arg = (ATermAppl)c.getArgument(0);
                    if (ATermUtils.isMin(arg)) {
                        result = AbstractConceptCache.checkMaxClash(kb, c, roots[root], roots[otherRoot]);
                    } else if (ATermUtils.isSelf(arg)) {
                        result = AbstractConceptCache.checkSelfClash(kb, arg, roots[root], roots[otherRoot]);
                    }
                }
                if (result == null) continue;
                return result;
            }
        }
        boolean bl = bothNamedIndividuals = root1 instanceof Individual && root2 instanceof Individual;
        if (kb.getExpressivity().hasFunctionality() || kb.getExpressivity().hasFunctionalityD()) {
            root = roots[0].getOutEdges().size() + roots[0].getInEdges().size() < roots[1].getOutEdges().size() + roots[1].getInEdges().size() ? 0 : 1;
            otherRoot = 1 - root;
            result = bothNamedIndividuals ? AbstractConceptCache.checkFunctionalityClashWithDifferents((Individual)roots[root], (Individual)roots[otherRoot]) : AbstractConceptCache.checkFunctionalityClash(roots[root], roots[otherRoot]);
            if (result != null) {
                return result;
            }
        }
        if (bothNamedIndividuals) {
            Individual ind1 = (Individual)root1;
            Individual ind2 = (Individual)root2;
            DependencySet ds = ind1.getDifferenceDependency(ind2);
            if (ds != null) {
                return ds.isIndependent() ? Bool.FALSE : Bool.UNKNOWN;
            }
            for (Edge edge : ind1.getOutEdges()) {
                if (!edge.getRole().isIrreflexive() || !edge.getTo().equals(ind2)) continue;
                return edge.getDepends().isIndependent() ? Bool.FALSE : Bool.UNKNOWN;
            }
            for (Edge edge : ind1.getInEdges()) {
                if (!edge.getRole().isIrreflexive() || !edge.getFrom().equals(ind2)) continue;
                return edge.getDepends().isIndependent() ? Bool.FALSE : Bool.UNKNOWN;
            }
        }
        if (kb.getExpressivity().hasDisjointRoles() && (clash = AbstractConceptCache.checkDisjointPropertyClash(root1, root2)) != null) {
            return Bool.UNKNOWN;
        }
        return Bool.TRUE;
    }

    private static Bool checkBinaryClash(KnowledgeBase kb, ATermAppl c, CachedNode root, CachedNode otherRoot) {
        Iterator<Unfolding> unfoldingList = kb.getTBox().unfold(c);
        while (unfoldingList.hasNext()) {
            Unfolding unfolding = unfoldingList.next();
            ATermAppl unfoldingCondition = unfolding.getCondition();
            if (unfoldingCondition.equals(TermFactory.TOP) || !otherRoot.getDepends().containsKey(unfoldingCondition)) continue;
            return Bool.UNKNOWN;
        }
        return null;
    }

    private static Bool checkAllValuesClash(KnowledgeBase kb, ATermAppl av, CachedNode root, CachedNode otherRoot) {
        Role role;
        ATerm r = av.getArgument(0);
        if (r.getType() == 4) {
            r = (ATerm)((ATermList)r).getFirst();
        }
        if (null == (role = kb.getRole(r))) {
            return Bool.UNKNOWN;
        }
        if (!role.hasComplexSubRole()) {
            if (otherRoot.hasRNeighbor(role)) {
                if (_logger.isLoggable(Level.FINE)) {
                    _logger.fine(root + " has " + av + " " + otherRoot + " has " + role + " _neighbor");
                }
                return Bool.UNKNOWN;
            }
        } else {
            TransitionGraph<Role> tg = role.getFSM();
            for (Transition<Role> t : tg.getInitialState().getTransitions()) {
                if (!otherRoot.hasRNeighbor(t.getName())) continue;
                if (_logger.isLoggable(Level.FINE)) {
                    _logger.fine(root + " has " + av + " " + otherRoot + " has " + t.getName() + " _neighbor");
                }
                return Bool.UNKNOWN;
            }
        }
        return null;
    }

    private static Bool checkMaxClash(KnowledgeBase kb, ATermAppl mc, CachedNode root, CachedNode otherRoot) {
        int n2;
        ATermAppl maxCard = (ATermAppl)mc.getArgument(0);
        Role maxR = kb.getRole(maxCard.getArgument(0));
        int max = ((ATermInt)maxCard.getArgument(1)).getInt() - 1;
        int n1 = AbstractConceptCache.getRNeighbors(root, maxR).size();
        if (n1 + (n2 = AbstractConceptCache.getRNeighbors(otherRoot, maxR).size()) > max) {
            if (_logger.isLoggable(Level.FINE)) {
                _logger.fine(root + " has " + mc + " " + otherRoot + " has R-_neighbor");
            }
            return Bool.UNKNOWN;
        }
        return null;
    }

    private static Bool checkSelfClash(KnowledgeBase kb, ATermAppl self, CachedNode root, CachedNode otherRoot) {
        Role r = kb.getRole(self.getArgument(0));
        for (Edge e : otherRoot.getOutEdges()) {
            if (!e.getRole().isSubRoleOf(r) || !e.getToName().equals(otherRoot.getName())) continue;
            if (_logger.isLoggable(Level.FINE)) {
                _logger.fine(root + " has not(" + self + ") " + otherRoot + " has self edge");
            }
            boolean allIndependent = root.isIndependent() && otherRoot.isIndependent() && e.getDepends().isIndependent();
            return allIndependent ? Bool.FALSE : Bool.UNKNOWN;
        }
        return null;
    }

    private static Bool checkFunctionalityClash(CachedNode root, CachedNode otherRoot) {
        Set<Role> functionalSupers;
        Role role;
        HashSet<Role> checked = new HashSet<Role>();
        for (Edge edge : root.getOutEdges()) {
            role = edge.getRole();
            if (!role.isFunctional()) continue;
            functionalSupers = role.getFunctionalSupers();
            for (Role supRole : functionalSupers) {
                if (checked.contains(supRole)) continue;
                checked.add(supRole);
                if (!otherRoot.hasRNeighbor(supRole)) continue;
                if (_logger.isLoggable(Level.FINE)) {
                    _logger.fine(root + " and " + otherRoot + " has " + supRole);
                }
                return Bool.UNKNOWN;
            }
        }
        for (Edge edge : root.getInEdges()) {
            role = edge.getRole().getInverse();
            if (role == null || !role.isFunctional()) continue;
            functionalSupers = role.getFunctionalSupers();
            for (Role supRole : functionalSupers) {
                if (checked.contains(supRole)) continue;
                checked.add(supRole);
                if (!otherRoot.hasRNeighbor(supRole)) continue;
                if (_logger.isLoggable(Level.FINE)) {
                    _logger.fine(root + " and " + otherRoot + " has " + supRole);
                }
                return Bool.UNKNOWN;
            }
        }
        return null;
    }

    private static Bool checkFunctionalityClashWithDifferents(Individual root, Individual otherRoot) {
        DependencySet ds;
        EdgeList otherEdges;
        Set<Role> functionalSupers;
        Role role;
        Bool result = null;
        for (Edge edge : root.getOutEdges()) {
            role = edge.getRole();
            if (!role.isFunctional()) continue;
            functionalSupers = role.getFunctionalSupers();
            for (Role supRole : functionalSupers) {
                otherEdges = otherRoot.getRNeighborEdges(supRole);
                for (Edge otherEdge : otherEdges) {
                    ds = edge.getTo().getDifferenceDependency(otherEdge.getNeighbor(otherRoot));
                    if (_logger.isLoggable(Level.FINE)) {
                        _logger.fine(root + " and " + otherRoot + " has " + supRole + " " + edge + " " + otherEdge);
                    }
                    if (ds != null && ds.isIndependent()) {
                        return Bool.FALSE;
                    }
                    result = Bool.UNKNOWN;
                }
            }
        }
        for (Edge edge : root.getInEdges()) {
            role = edge.getRole().getInverse();
            if (role == null || !role.isFunctional()) continue;
            functionalSupers = role.getFunctionalSupers();
            for (Role supRole : functionalSupers) {
                otherEdges = otherRoot.getRNeighborEdges(supRole);
                for (Edge otherEdge : otherEdges) {
                    ds = edge.getTo().getDifferenceDependency(otherEdge.getNeighbor(otherRoot));
                    if (_logger.isLoggable(Level.FINE)) {
                        _logger.fine(root + " and " + otherRoot + " has " + supRole + " " + edge + " " + otherEdge);
                    }
                    if (ds != null && ds.isIndependent()) {
                        return Bool.FALSE;
                    }
                    result = Bool.UNKNOWN;
                }
            }
        }
        return result;
    }

    private static MultiValueMap<ATermAppl, Role> collectNeighbors(CachedNode ind) {
        ATermAppl neighbor;
        Role role;
        MultiValueMap<ATermAppl, Role> neighbors = new MultiValueMap<ATermAppl, Role>();
        for (Edge edge : ind.getInEdges()) {
            role = edge.getRole();
            neighbor = edge.getFromName();
            if (ATermUtils.isBnode(neighbor)) continue;
            neighbors.putSingle(neighbor, role);
        }
        for (Edge edge : ind.getOutEdges()) {
            role = edge.getRole();
            neighbor = edge.getToName();
            if (!role.isObjectRole() || ATermUtils.isBnode(neighbor)) continue;
            neighbors.putSingle(neighbor, role.getInverse());
        }
        return neighbors;
    }

    private static boolean checkDisjointProperties(Set<Role> roles1, Set<Role> roles2) {
        HashSet<Role> allDisjoints = new HashSet<Role>();
        for (Role role : roles1) {
            allDisjoints.addAll(role.getDisjointRoles());
        }
        return SetUtils.intersects(allDisjoints, roles2);
    }

    private static Bool checkDisjointPropertyClash(CachedNode root1, CachedNode root2) {
        MultiValueMap<ATermAppl, Role> neighbors1 = AbstractConceptCache.collectNeighbors(root1);
        if (neighbors1.isEmpty()) {
            return null;
        }
        MultiValueMap<ATermAppl, Role> neighbors2 = AbstractConceptCache.collectNeighbors(root2);
        if (neighbors2.isEmpty()) {
            return null;
        }
        for (Map.Entry e : neighbors1.entrySet()) {
            ATermAppl commonNeighbor = (ATermAppl)e.getKey();
            Set roles1 = (Set)e.getValue();
            Set roles2 = (Set)neighbors2.get(commonNeighbor);
            if (roles2 == null || !AbstractConceptCache.checkDisjointProperties(roles1, roles2)) continue;
            return Bool.UNKNOWN;
        }
        return null;
    }

    @Override
    public Bool checkNominalEdges(KnowledgeBase kb, CachedNode pNode, CachedNode cNode) {
        Bool result = Bool.UNKNOWN;
        if (pNode.isComplete() && cNode.isComplete() && cNode.isIndependent() && (result = AbstractConceptCache.checkNominalEdges(kb, pNode, cNode, false)).isUnknown()) {
            result = AbstractConceptCache.checkNominalEdges(kb, pNode, cNode, true);
        }
        return result;
    }

    private static Set<ATermAppl> getABoxSames(KnowledgeBase kb, ATermAppl val) {
        Individual ind = kb.getABox().getIndividual(val).getSame();
        HashSet<ATermAppl> samesAndMaybes = new HashSet<ATermAppl>();
        kb.getABox().getSames(ind, samesAndMaybes, samesAndMaybes);
        return samesAndMaybes;
    }

    private static Bool checkNominalEdges(KnowledgeBase kb, CachedNode pNode, CachedNode cNode, boolean checkInverses) {
        EdgeList edges = checkInverses ? cNode.getInEdges() : cNode.getOutEdges();
        for (Edge edge : edges) {
            ATermAppl val;
            Role role = checkInverses ? edge.getRole().getInverse() : edge.getRole();
            DependencySet ds = edge.getDepends();
            if (!ds.isIndependent()) continue;
            boolean found = false;
            ATermAppl aTermAppl = val = checkInverses ? edge.getFromName() : edge.getToName();
            if (!role.isObjectRole()) {
                found = pNode.hasRNeighbor(role);
            } else if (!AbstractConceptCache.isRootNominal(kb, val)) {
                if (!role.hasComplexSubRole()) {
                    found = pNode.hasRNeighbor(role);
                } else {
                    TransitionGraph<Role> tg = role.getFSM();
                    Iterator<Transition<Role>> it = tg.getInitialState().getTransitions().iterator();
                    while (!found && it.hasNext()) {
                        Transition<Role> tr = it.next();
                        found = pNode.hasRNeighbor(tr.getName());
                    }
                }
            } else if (role.isSimple() || !(pNode instanceof Individual)) {
                found = AbstractConceptCache.intersectsRNeighbors(AbstractConceptCache.getABoxSames(kb, val), pNode, role);
            } else {
                HashSet<ATermAppl> neighbors = new HashSet<ATermAppl>();
                kb.getABox().getObjectPropertyValues(pNode.getName(), role, neighbors, neighbors, false);
                found = SetUtils.intersects(AbstractConceptCache.getABoxSames(kb, val), neighbors);
            }
            if (found) continue;
            return Bool.FALSE;
        }
        return Bool.UNKNOWN;
    }

    private static boolean isRootNominal(KnowledgeBase kb, ATermAppl val) {
        Individual ind = kb.getABox().getIndividual(val);
        return ind != null && ind.isRootNominal();
    }

    private static Set<ATermAppl> getRNeighbors(CachedNode node, Role role) {
        HashSet<ATermAppl> neighbors = new HashSet<ATermAppl>();
        for (Edge edge : node.getOutEdges()) {
            Role r = edge.getRole();
            if (!r.isSubRoleOf(role)) continue;
            neighbors.add(edge.getToName());
        }
        if (role.isObjectRole()) {
            Role invRole = role.getInverse();
            for (Edge edge : node.getInEdges()) {
                Role r = edge.getRole();
                if (!r.isSubRoleOf(invRole)) continue;
                neighbors.add(edge.getFromName());
            }
        }
        return neighbors;
    }

    private static boolean intersectsRNeighbors(Set<ATermAppl> samesAndMaybes, CachedNode node, Role role) {
        if (samesAndMaybes.isEmpty()) {
            return false;
        }
        for (Edge edge : node.getOutEdges()) {
            if (!samesAndMaybes.contains(edge.getToName()) || !edge.getRole().isSubRoleOf(role)) continue;
            return true;
        }
        if (role.isObjectRole()) {
            Role invRole = role.getInverse();
            for (Edge edge : node.getInEdges()) {
                if (!samesAndMaybes.contains(edge.getFromName()) || !edge.getRole().isSubRoleOf(invRole)) continue;
                return true;
            }
        }
        return false;
    }
}

