/*
 * Decompiled with CFR 0.152.
 */
package openllet.core.utils;

import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import openllet.aterm.ATerm;
import openllet.core.utils.NumberUtils;

public class Comparators {
    public static final Comparator<Comparable<Object>> comparator = (o1, o2) -> o1.compareTo(o2);
    public static final Comparator<ATerm> termComparator = (o1, o2) -> {
        int h2;
        int h1 = o1.hashCode();
        if (h1 < (h2 = o2.hashCode())) {
            return -1;
        }
        if (h1 > h2) {
            return 1;
        }
        if (o1 == o2) {
            return 0;
        }
        return o1.toString().compareTo(o2.toString());
    };
    public static final Comparator<Number> numberComparator = (n1, n2) -> NumberUtils.compare(n1, n2);
    public static final Comparator<Object> stringComparator = (o1, o2) -> o1.toString().compareTo(o2.toString());
    public static final Comparator<Calendar> calendarComparator = (c1, c2) -> {
        long t2;
        long t1 = c1.getTimeInMillis();
        if (t1 < (t2 = c2.getTimeInMillis())) {
            return -1;
        }
        if (t1 == t2) {
            return 0;
        }
        return 1;
    };

    public static <T> Comparator<T> reverse(Comparator<T> cmp) {
        return Collections.reverseOrder(cmp);
    }
}

