/*
 * Decompiled with CFR 0.152.
 */
package openllet.core.utils;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class DisjointSet<T> {
    private final Map<T, Node<T>> _elements = new ConcurrentHashMap<T, Node<T>>();

    public void add(T o) {
        if (this._elements.containsKey(o)) {
            return;
        }
        this._elements.put(o, new Node<T>(o));
    }

    public boolean contains(T o) {
        return this._elements.containsKey(o);
    }

    public Collection<T> elements() {
        return Collections.unmodifiableSet(this._elements.keySet());
    }

    public T find(T o) {
        return (T)((Node)this.findRoot(o))._object;
    }

    private Node<T> findRoot(T o) {
        Node node = this._elements.get(o);
        while (node._parent._parent != node._parent) {
            node._parent = node._parent._parent;
            node = node._parent;
        }
        return node._parent;
    }

    public Collection<Set<T>> getEquivalanceSets() {
        HashMap<T, HashSet<T>> equivalanceSets = new HashMap<T, HashSet<T>>();
        for (T x : this._elements.keySet()) {
            T representative = this.find(x);
            HashSet<T> equivalanceSet = (HashSet<T>)equivalanceSets.get(representative);
            if (equivalanceSet == null) {
                equivalanceSet = new HashSet<T>();
                equivalanceSets.put(representative, equivalanceSet);
            }
            equivalanceSet.add(x);
        }
        return equivalanceSets.values();
    }

    public boolean isSame(T x, T y) {
        return this.find(x).equals(this.find(y));
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("{");
        Iterator<Node<T>> i = this._elements.values().iterator();
        while (i.hasNext()) {
            Node<T> node = i.next();
            buffer.append(((Node)node)._object);
            buffer.append(" -> ");
            buffer.append(((Node)node)._parent._object);
            if (!i.hasNext()) continue;
            buffer.append(", ");
        }
        buffer.append("}");
        return buffer.toString();
    }

    public Node<T> union(T x, T y) {
        Node<T> rootX = this.findRoot(x);
        Node<T> rootY = this.findRoot(y);
        if (((Node)rootX)._rank > ((Node)rootY)._rank) {
            Node<T> node = rootX;
            rootX = rootY;
            rootY = node;
        } else if (((Node)rootX)._rank == ((Node)rootY)._rank) {
            ++((Node)rootY)._rank;
        }
        ((Node)rootX)._parent = (Node)rootY;
        return rootY;
    }

    private class Node<U> {
        private final U _object;
        private Node<U> _parent = this;
        private int _rank = 0;

        public Node(U o) {
            this._object = o;
        }
    }
}

