/*
 * Decompiled with CFR 0.152.
 */
package openllet.core.utils;

public enum DurationFormat {
    FULL("%d hour(s) %d minute(s) %d second(s) %d milliseconds(s)", true),
    LONG("%02d:%02d:%02d.%03d", true),
    MEDIUM("%02d:%02d:%02d", true),
    SHORT("%2$02d:%3$02d", false);

    private String _formatString;
    private boolean _hoursVisible;

    private DurationFormat(String formatString, boolean hoursVisible) {
        this._formatString = formatString;
        this._hoursVisible = hoursVisible;
    }

    public String format(long durationInMilliseconds) {
        long hours;
        long duration = durationInMilliseconds;
        if (this._hoursVisible) {
            hours = duration / 3600000L;
            duration -= hours * 3600000L;
        } else {
            hours = 0L;
        }
        long minutes = duration / 60000L;
        long seconds = (duration -= minutes * 60000L) / 1000L;
        long milliseconds = duration - seconds * 1000L;
        return String.format(this._formatString, hours, minutes, seconds, milliseconds);
    }
}

