/*
 * Decompiled with CFR 0.152.
 */
package openllet.core.utils;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.List;
import openllet.atom.OpenError;

public class NumberUtils {
    public static final int BYTE = 0;
    public static final int SHORT = 1;
    public static final int INT = 2;
    public static final int LONG = 3;
    public static final int INTEGER = 4;
    public static final int DECIMAL = 5;
    public static final int FLOAT = 6;
    public static final int DOUBLE = 7;
    private static final int TYPES = 8;
    public static final Byte BYTE_ZERO = 0;
    public static final Short SHORT_ZERO = 0;
    public static final Integer INT_ZERO = 0;
    public static final Long LONG_ZERO = 0L;
    public static final BigInteger INTEGER_ZERO = BigInteger.valueOf(0L);
    public static final BigDecimal DECIMAL_ZERO = BigDecimal.valueOf(0L);
    public static final Float FLOAT_ZERO = Float.valueOf(0.0f);
    public static final Double DOUBLE_ZERO = 0.0;
    private static final List<Class<?>> classes = Arrays.asList(Byte.class, Short.class, Integer.class, Long.class, BigInteger.class, BigDecimal.class, Float.class, Double.class);
    private static final List<String> names = Arrays.asList("Byte", "Short", "Integer", "Long", "BigInteger", "BigDecimal", "Float", "Double");
    private static final List<Number> zeros = Arrays.asList(BYTE_ZERO, SHORT_ZERO, INT_ZERO, LONG_ZERO, INTEGER_ZERO, DECIMAL_ZERO, FLOAT_ZERO, DOUBLE_ZERO);

    public static Number parseByte(String str) throws NumberFormatException {
        return NumberUtils.parse(str, 0);
    }

    public static Number parseShort(String str) throws NumberFormatException {
        return NumberUtils.parse(str, 1);
    }

    public static Number parseInt(String str) throws NumberFormatException {
        return NumberUtils.parse(str, 2);
    }

    public static Number parseLong(String str) throws NumberFormatException {
        return NumberUtils.parse(str, 3);
    }

    public static Number parseInteger(String str) throws NumberFormatException {
        return NumberUtils.parse(str, 4);
    }

    public static Number parseDecimal(String str) throws NumberFormatException {
        return NumberUtils.parse(str, 5);
    }

    public static Float parseFloat(String str) throws NumberFormatException {
        return (Float)NumberUtils.parse(str, 6);
    }

    public static Double parseDouble(String str) throws NumberFormatException {
        return (Double)NumberUtils.parse(str, 7);
    }

    public static Number parse(String strParam, int type) throws NumberFormatException {
        int foundType;
        String str = strParam;
        if (0 > type || type >= 8) {
            throw new UnsupportedOperationException("Unknown numeric type " + type);
        }
        if (type == 6) {
            return Float.valueOf(str);
        }
        if (type == 7) {
            return Double.valueOf(str);
        }
        int idx = 0;
        int len = str.length();
        if (len == 0) {
            throw new NumberFormatException("Empty string");
        }
        boolean negate = false;
        int start = 0;
        switch (str.charAt(idx)) {
            case '+': {
                start = 1;
                ++idx;
                break;
            }
            case '-': {
                negate = true;
                ++idx;
                break;
            }
            case '0': 
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': 
            case '6': 
            case '7': 
            case '8': 
            case '9': {
                break;
            }
            default: {
                throw new NumberFormatException("Invalid char '" + str.charAt(idx) + "' in " + str);
            }
        }
        if (idx == len) {
            throw new NumberFormatException("Invalid number that has only sign " + (negate ? (char)'-' : '+'));
        }
        while (idx < len && str.charAt(idx) == '0') {
            ++idx;
        }
        if (idx == len) {
            return BYTE_ZERO;
        }
        Object number = null;
        long prev = 0L;
        long curr = 0L;
        while (idx < len) {
            char ch;
            if ('0' <= (ch = str.charAt(idx++)) && ch <= '9') {
                curr = negate ? 10L * curr + (long)(48 - ch) : 10L * curr + (long)(ch - 48);
                if (curr < prev != negate) {
                    int fractionPoint = str.indexOf(46);
                    if (fractionPoint == -1) {
                        number = new BigInteger(str.substring(start));
                        break;
                    }
                    int lastNonZeroDigit = len;
                    while (lastNonZeroDigit >= fractionPoint && str.charAt(--lastNonZeroDigit) == '0') {
                    }
                    if (lastNonZeroDigit <= fractionPoint) {
                        number = new BigInteger(str.substring(start, fractionPoint));
                        break;
                    }
                    if (lastNonZeroDigit != len) {
                        number = new BigDecimal(str.substring(start, lastNonZeroDigit));
                        break;
                    }
                    number = new BigDecimal(str.substring(start));
                    break;
                }
                prev = curr;
                continue;
            }
            if (ch == '.') {
                int lastNonZeroDigit = len;
                int fractionPoint = idx - 1;
                while (lastNonZeroDigit >= fractionPoint && str.charAt(--lastNonZeroDigit) == '0') {
                }
                if (lastNonZeroDigit <= fractionPoint) {
                    number = new BigInteger(str.substring(start, fractionPoint));
                    break;
                }
                if (lastNonZeroDigit != len - 1) {
                    str = str.substring(0, lastNonZeroDigit + 1);
                    number = new BigDecimal(str.substring(start));
                    break;
                }
                number = new BigDecimal(str.substring(start));
                break;
            }
            throw new NumberFormatException("Invalid char '" + ch + "' in " + str);
        }
        if (number == null) {
            number = -128L <= curr && curr <= 127L ? (Number)((byte)curr) : (Number)(-32768L <= curr && curr <= 32767L ? (Number)((short)curr) : (Number)(Integer.MIN_VALUE <= curr && curr <= Integer.MAX_VALUE ? (Number)((int)curr) : (Number)curr));
        }
        if (type < (foundType = classes.indexOf(number.getClass()))) {
            throw new NumberFormatException(str + " is not a valid " + names.get(type));
        }
        return number;
    }

    public static Number add(Number n1, int n2) {
        int type1 = classes.indexOf(n1.getClass());
        switch (type1) {
            case 0: {
                return ((Byte)n1).intValue() + n2;
            }
            case 1: {
                return ((Short)n1).intValue() + n2;
            }
            case 2: {
                return (Integer)n1 + n2;
            }
            case 3: {
                return (Long)n1 + (long)n2;
            }
            case 4: {
                return ((BigInteger)n1).add(BigInteger.valueOf(n2));
            }
            case 5: {
                return ((BigDecimal)n1).add(BigDecimal.valueOf(n2));
            }
            case 6: {
                return Float.valueOf(((Float)n1).floatValue() + (float)n2 * Float.MIN_VALUE);
            }
            case 7: {
                return (Double)n1 + (double)n2 * Double.MIN_VALUE;
            }
        }
        throw new IllegalArgumentException("Unknown number class " + n1.getClass());
    }

    public static int getType(Number number) {
        return classes.indexOf(number.getClass());
    }

    public static String getTypeName(Number number) {
        if (number == null) {
            return "null";
        }
        return names.get(classes.indexOf(number.getClass())).toString();
    }

    private static BigDecimal convertToDecimal(Number n) {
        if (n instanceof BigDecimal) {
            return (BigDecimal)n;
        }
        return new BigDecimal(n.toString());
    }

    public static int sign(Number n) {
        int type = classes.indexOf(n.getClass());
        Number zero = zeros.get(type);
        return ((Comparable)((Object)n)).compareTo(zero);
    }

    public static int compare(Number n1, Number n2) {
        int type2;
        int type1 = classes.indexOf(n1.getClass());
        if (type1 != (type2 = classes.indexOf(n2.getClass()))) {
            if (type1 > 5 || type2 > 5) {
                throw new IllegalArgumentException("Trying to compare incompatible values " + n1 + " " + n2);
            }
            if (type1 == 5 || type2 == 5) {
                return NumberUtils.convertToDecimal(n1).compareTo(NumberUtils.convertToDecimal(n2));
            }
            if (type1 < type2) {
                return -NumberUtils.sign(n2);
            }
            return NumberUtils.sign(n1);
        }
        switch (type1) {
            case 0: {
                return ((Byte)n1).compareTo((Byte)n2);
            }
            case 1: {
                return ((Short)n1).compareTo((Short)n2);
            }
            case 2: {
                return ((Integer)n1).compareTo((Integer)n2);
            }
            case 3: {
                return ((Long)n1).compareTo((Long)n2);
            }
            case 4: {
                return ((BigInteger)n1).compareTo((BigInteger)n2);
            }
            case 5: {
                return ((BigDecimal)n1).compareTo((BigDecimal)n2);
            }
            case 6: {
                return ((Float)n1).compareTo((Float)n2);
            }
            case 7: {
                return ((Double)n1).compareTo((Double)n2);
            }
        }
        throw new IllegalArgumentException("Unknown number class " + n1.getClass());
    }

    public static int getTotalDigits(Number n) {
        int type = NumberUtils.getType(n);
        String str = n.toString();
        int totalDigitsInValue = str.length();
        if (type >= 5 && str.indexOf(46) != -1) {
            --totalDigitsInValue;
        }
        return totalDigitsInValue;
    }

    public static int getFractionDigits(Number n) {
        int type = NumberUtils.getType(n);
        int fracDigitsInValue = 0;
        if (type >= 5) {
            String str = n.toString();
            fracDigitsInValue = str.length() - str.indexOf(".");
        }
        return fracDigitsInValue;
    }

    public static void test(String val, int type, Number test) {
        Number number = null;
        try {
            number = NumberUtils.parse(val, type);
            if (number.equals(test) && number.getClass().equals(test.getClass())) {
                System.out.println(val + " -> " + number + " (" + NumberUtils.getTypeName(number) + ") = " + test + " (" + NumberUtils.getTypeName(test) + ")");
            } else {
                System.err.println(val + " -> " + number + " (" + NumberUtils.getTypeName(number) + ") != " + test + " (" + NumberUtils.getTypeName(test) + ")");
            }
        }
        catch (RuntimeException e) {
            System.err.println(val + " -> " + number + " (" + NumberUtils.getTypeName(number) + ") != " + test + " (" + NumberUtils.getTypeName(test) + ")");
            e.printStackTrace();
        }
    }

    public static void test(String val1, int type1, String val2, int type2, int result) {
        try {
            Number number1 = NumberUtils.parse(val1, type1);
            Number number2 = NumberUtils.parse(val2, type2);
            int cmp = NumberUtils.compare(number1, number2);
            if (cmp != result) {
                throw new OpenError(val1 + " " + val2 + " " + cmp + " " + result);
            }
            String op = cmp < 0 ? "<" : (cmp == 0 ? "=" : ">");
            System.out.println(number1 + " (" + NumberUtils.getTypeName(number1) + ") " + op + " " + number2 + " (" + NumberUtils.getTypeName(number2) + ")");
        }
        catch (RuntimeException e) {
            e.printStackTrace();
        }
    }

    public static void main(String[] args) {
        BigInteger i = new BigInteger("9223372036854775807");
        i = i.add(BigInteger.ONE);
        BigInteger TEN_INT = new BigInteger("10");
        i = i.add(TEN_INT);
        i = i.add(i);
        NumberUtils.test("+" + i.toString(), 5, i);
        BigDecimal d = new BigDecimal(i);
        d = d.divide(new BigDecimal("2346365"), 7, 2);
        NumberUtils.test(d.toString(), 5, d);
        NumberUtils.test("10", 4, "10.1", 5, -1);
        NumberUtils.test("120", 4, "130", 4, -1);
        NumberUtils.test("10.1", 5, "130", 5, -1);
    }
}

