/*
 * Decompiled with CFR 0.152.
 */
package openllet.core.utils;

import java.util.ArrayList;
import java.util.Set;
import openllet.aterm.AFun;
import openllet.aterm.ATerm;
import openllet.aterm.ATermAppl;
import openllet.aterm.ATermList;
import openllet.core.KnowledgeBase;
import openllet.core.KnowledgeBaseImpl;
import openllet.core.exceptions.InternalReasonerException;
import openllet.core.output.ATermBaseVisitor;
import openllet.core.rules.model.AtomDConstant;
import openllet.core.rules.model.AtomDObject;
import openllet.core.rules.model.AtomDVariable;
import openllet.core.rules.model.AtomIConstant;
import openllet.core.rules.model.AtomIObject;
import openllet.core.rules.model.AtomIVariable;
import openllet.core.rules.model.BuiltInAtom;
import openllet.core.rules.model.ClassAtom;
import openllet.core.rules.model.DatavaluedPropertyAtom;
import openllet.core.rules.model.DifferentIndividualsAtom;
import openllet.core.rules.model.IndividualPropertyAtom;
import openllet.core.rules.model.Rule;
import openllet.core.rules.model.RuleAtom;
import openllet.core.rules.model.SameIndividualAtom;
import openllet.core.utils.ATermUtils;

public class OntBuilder {
    private volatile KnowledgeBase _kb;
    private final KnowledgeBase _originalKB;
    private final DefinitionVisitor _defVisitor = new DefinitionVisitor();

    public OntBuilder(KnowledgeBase originalKB) {
        this._originalKB = originalKB;
    }

    public void add(ATermAppl axiom) {
        AFun afun = axiom.getAFun();
        if (afun.equals(ATermUtils.EQCLASSFUN)) {
            ATermAppl c1 = (ATermAppl)axiom.getArgument(0);
            ATermAppl c2 = (ATermAppl)axiom.getArgument(1);
            this.defineClass(c1);
            this.defineClass(c2);
            this._kb.addEquivalentClass(c1, c2);
        } else if (afun.equals(ATermUtils.SUBFUN)) {
            ATermAppl c1 = (ATermAppl)axiom.getArgument(0);
            ATermAppl c2 = (ATermAppl)axiom.getArgument(1);
            this.defineClass(c1);
            this.defineClass(c2);
            this._kb.addSubClass(c1, c2);
        } else if (afun.equals(ATermUtils.DISJOINTSFUN)) {
            ATermList concepts;
            ATermList l = concepts = (ATermList)axiom.getArgument(0);
            while (!l.isEmpty()) {
                this.defineClass((ATermAppl)l.getFirst());
                l = l.getNext();
            }
            this._kb.addDisjointClasses(concepts);
        } else if (afun.equals(ATermUtils.DISJOINTFUN)) {
            ATermAppl c1 = (ATermAppl)axiom.getArgument(0);
            ATermAppl c2 = (ATermAppl)axiom.getArgument(1);
            this.defineClass(c1);
            this.defineClass(c2);
            this._kb.addDisjointClass(c1, c2);
        } else if (afun.equals(ATermUtils.DISJOINTPROPSFUN)) {
            ATermList props;
            ATermList l = props = (ATermList)axiom.getArgument(0);
            while (!l.isEmpty()) {
                this.defineProperty((ATerm)l.getFirst());
                l = l.getNext();
            }
            this._kb.addDisjointProperties(props);
        } else if (afun.equals(ATermUtils.DISJOINTPROPFUN)) {
            ATermAppl p1 = (ATermAppl)axiom.getArgument(0);
            ATermAppl p2 = (ATermAppl)axiom.getArgument(1);
            this.defineProperty(p1);
            this.defineProperty(p2);
            this._kb.addDisjointProperty(p1, p2);
        } else if (afun.equals(ATermUtils.SUBPROPFUN)) {
            ATerm p1 = axiom.getArgument(0);
            ATermAppl p2 = (ATermAppl)axiom.getArgument(1);
            this.defineProperty(p1);
            this.defineProperty(p2);
            this._kb.addSubProperty(p1, p2);
        } else if (afun.equals(ATermUtils.EQPROPFUN)) {
            ATermAppl p1 = (ATermAppl)axiom.getArgument(0);
            ATermAppl p2 = (ATermAppl)axiom.getArgument(1);
            this.defineProperty(p1);
            this.defineProperty(p2);
            this._kb.addEquivalentProperty(p1, p2);
        } else if (afun.equals(ATermUtils.DOMAINFUN)) {
            ATermAppl p = (ATermAppl)axiom.getArgument(0);
            ATermAppl c = (ATermAppl)axiom.getArgument(1);
            this.defineProperty(p);
            this.defineClass(c);
            this._kb.addDomain(p, c);
        } else if (afun.equals(ATermUtils.RANGEFUN)) {
            ATermAppl p = (ATermAppl)axiom.getArgument(0);
            ATermAppl c = (ATermAppl)axiom.getArgument(1);
            this.defineProperty(p);
            this.defineClass(c);
            this._kb.addRange(p, c);
        } else if (afun.equals(ATermUtils.INVPROPFUN)) {
            ATermAppl p1 = (ATermAppl)axiom.getArgument(0);
            ATermAppl p2 = (ATermAppl)axiom.getArgument(1);
            this._kb.addObjectProperty(p1);
            this._kb.addObjectProperty(p2);
            this._kb.addInverseProperty(p1, p2);
        } else if (afun.equals(ATermUtils.TRANSITIVEFUN)) {
            ATermAppl p = (ATermAppl)axiom.getArgument(0);
            this._kb.addObjectProperty(p);
            this._kb.addTransitiveProperty(p);
        } else if (afun.equals(ATermUtils.FUNCTIONALFUN)) {
            ATermAppl p = (ATermAppl)axiom.getArgument(0);
            this.defineProperty(p);
            this._kb.addFunctionalProperty(p);
        } else if (afun.equals(ATermUtils.INVFUNCTIONALFUN)) {
            ATermAppl p = (ATermAppl)axiom.getArgument(0);
            this._kb.addObjectProperty(p);
            this._kb.addInverseFunctionalProperty(p);
        } else if (afun.equals(ATermUtils.SYMMETRICFUN)) {
            ATermAppl p = (ATermAppl)axiom.getArgument(0);
            this._kb.addObjectProperty(p);
            this._kb.addSymmetricProperty(p);
        } else if (afun.equals(ATermUtils.ASYMMETRICFUN)) {
            ATermAppl p = (ATermAppl)axiom.getArgument(0);
            this._kb.addObjectProperty(p);
            this._kb.addAsymmetricProperty(p);
        } else if (afun.equals(ATermUtils.REFLEXIVEFUN)) {
            ATermAppl p = (ATermAppl)axiom.getArgument(0);
            this._kb.addObjectProperty(p);
            this._kb.addReflexiveProperty(p);
        } else if (afun.equals(ATermUtils.IRREFLEXIVEFUN)) {
            ATermAppl p = (ATermAppl)axiom.getArgument(0);
            this._kb.addObjectProperty(p);
            this._kb.addIrreflexiveProperty(p);
        } else if (afun.equals(ATermUtils.TYPEFUN)) {
            ATermAppl ind = (ATermAppl)axiom.getArgument(0);
            ATermAppl cls = (ATermAppl)axiom.getArgument(1);
            this._kb.addIndividual(ind);
            this.defineClass(cls);
            this._kb.addType(ind, cls);
        } else if (afun.equals(ATermUtils.PROPFUN)) {
            ATermAppl p = (ATermAppl)axiom.getArgument(0);
            ATermAppl s = (ATermAppl)axiom.getArgument(1);
            ATermAppl o = (ATermAppl)axiom.getArgument(2);
            this._kb.addIndividual(s);
            if (ATermUtils.isLiteral(o)) {
                this._kb.addDatatypeProperty(p);
            } else {
                this._kb.addObjectProperty(p);
                this._kb.addIndividual(o);
            }
            this._kb.addPropertyValue(p, s, o);
        } else if (afun.equals(ATermUtils.NOTFUN) && ((ATermAppl)axiom.getArgument(0)).getAFun().equals(ATermUtils.PROPFUN)) {
            ATermAppl axiomArg0 = (ATermAppl)axiom.getArgument(0);
            ATermAppl p = (ATermAppl)axiomArg0.getArgument(0);
            ATermAppl s = (ATermAppl)axiomArg0.getArgument(1);
            ATermAppl o = (ATermAppl)axiomArg0.getArgument(2);
            this._kb.addIndividual(s);
            if (ATermUtils.isLiteral(o)) {
                this._kb.addDatatypeProperty(p);
            } else {
                this._kb.addObjectProperty(p);
                this._kb.addIndividual(o);
            }
            this._kb.addNegatedPropertyValue(p, s, o);
        } else if (afun.equals(ATermUtils.SAMEASFUN)) {
            ATermAppl ind1 = (ATermAppl)axiom.getArgument(0);
            ATermAppl ind2 = (ATermAppl)axiom.getArgument(1);
            this._kb.addIndividual(ind1);
            this._kb.addIndividual(ind2);
            this._kb.addSame(ind1, ind2);
        } else if (afun.equals(ATermUtils.DIFFERENTFUN)) {
            ATermAppl ind1 = (ATermAppl)axiom.getArgument(0);
            ATermAppl ind2 = (ATermAppl)axiom.getArgument(1);
            this._kb.addIndividual(ind1);
            this._kb.addIndividual(ind2);
            this._kb.addDifferent(ind1, ind2);
        } else if (afun.equals(ATermUtils.ALLDIFFERENTFUN)) {
            ATermList inds;
            ATermList l = inds = (ATermList)axiom.getArgument(0);
            while (!l.isEmpty()) {
                this._kb.addIndividual((ATermAppl)l.getFirst());
                l = l.getNext();
            }
            this._kb.addAllDifferent(inds);
        } else if (afun.equals(ATermUtils.RULEFUN)) {
            ArrayList<RuleAtom> antecedent = new ArrayList<RuleAtom>();
            ArrayList<RuleAtom> consequent = new ArrayList<RuleAtom>();
            ATermList head = (ATermList)axiom.getArgument(1);
            ATermList body = (ATermList)axiom.getArgument(2);
            while (!body.isEmpty()) {
                antecedent.add(this.convertRuleAtom((ATermAppl)body.getFirst()));
                body = body.getNext();
            }
            while (!head.isEmpty()) {
                consequent.add(this.convertRuleAtom((ATermAppl)head.getFirst()));
                head = head.getNext();
            }
            if (!antecedent.contains(null) && !consequent.contains(null)) {
                ATermAppl name = (ATermAppl)axiom.getArgument(0);
                Rule rule = new Rule(name, consequent, antecedent);
                this._kb.addRule(rule);
            }
        } else {
            throw new InternalReasonerException("Unknown axiom " + axiom);
        }
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private RuleAtom convertRuleAtom(ATermAppl term) {
        void var2_10;
        Object var2_2 = null;
        if (term.getAFun().equals(ATermUtils.TYPEFUN)) {
            ATermAppl i = (ATermAppl)term.getArgument(0);
            AtomIObject io = this.convertAtomIObject(i);
            ATermAppl c = (ATermAppl)term.getArgument(1);
            this.defineClass(c);
            ClassAtom classAtom = new ClassAtom(c, io);
            return var2_10;
        } else if (term.getAFun().equals(ATermUtils.PROPFUN)) {
            ATermAppl p = (ATermAppl)term.getArgument(0);
            ATermAppl i1 = (ATermAppl)term.getArgument(1);
            ATermAppl i2 = (ATermAppl)term.getArgument(2);
            AtomIObject io1 = this.convertAtomIObject(i1);
            this.defineProperty(p);
            if (this._originalKB.isObjectProperty(p)) {
                this._kb.addObjectProperty(p);
                AtomIObject io2 = this.convertAtomIObject(i2);
                IndividualPropertyAtom individualPropertyAtom = new IndividualPropertyAtom(p, io1, io2);
                return var2_10;
            } else {
                if (!this._originalKB.isDatatypeProperty(p)) throw new InternalReasonerException("Unknown property " + p);
                this._kb.addDatatypeProperty(p);
                AtomDObject do2 = OntBuilder.convertAtomDObject(i2);
                DatavaluedPropertyAtom datavaluedPropertyAtom = new DatavaluedPropertyAtom(p, io1, do2);
            }
            return var2_10;
        } else if (term.getAFun().equals(ATermUtils.SAMEASFUN)) {
            ATermAppl i1 = (ATermAppl)term.getArgument(0);
            ATermAppl i2 = (ATermAppl)term.getArgument(1);
            AtomIObject io1 = this.convertAtomIObject(i1);
            AtomIObject io2 = this.convertAtomIObject(i2);
            SameIndividualAtom sameIndividualAtom = new SameIndividualAtom(io1, io2);
            return var2_10;
        } else if (term.getAFun().equals(ATermUtils.DIFFERENTFUN)) {
            ATermAppl i1 = (ATermAppl)term.getArgument(0);
            ATermAppl i2 = (ATermAppl)term.getArgument(1);
            AtomIObject io1 = this.convertAtomIObject(i1);
            AtomIObject io2 = this.convertAtomIObject(i2);
            DifferentIndividualsAtom differentIndividualsAtom = new DifferentIndividualsAtom(io1, io2);
            return var2_10;
        } else {
            if (!term.getAFun().equals(ATermUtils.BUILTINFUN)) throw new InternalReasonerException("Unknown rule atom " + term);
            ATermList args = (ATermList)term.getArgument(0);
            ATermAppl builtin = (ATermAppl)args.getFirst();
            ArrayList<AtomDObject> list = new ArrayList<AtomDObject>();
            args = args.getNext();
            while (!args.isEmpty()) {
                ATermAppl arg = (ATermAppl)args.getFirst();
                list.add(OntBuilder.convertAtomDObject(arg));
                args = args.getNext();
            }
            BuiltInAtom builtInAtom = new BuiltInAtom(builtin.toString(), list);
        }
        return var2_10;
    }

    private AtomIObject convertAtomIObject(ATermAppl t) {
        if (ATermUtils.isVar(t)) {
            return new AtomIVariable(((ATermAppl)t.getArgument(0)).getName());
        }
        if (this._originalKB.isIndividual(t)) {
            return new AtomIConstant(t);
        }
        if (ATermUtils.isAnon(t)) {
            return new AtomIConstant(t);
        }
        throw new InternalReasonerException("Unrecognized term: " + t);
    }

    private static AtomDObject convertAtomDObject(ATermAppl t) {
        if (ATermUtils.isVar(t)) {
            return new AtomDVariable(((ATermAppl)t.getArgument(0)).getName());
        }
        if (ATermUtils.isLiteral(t)) {
            return new AtomDConstant(t);
        }
        throw new InternalReasonerException("Unrecognized term: " + t);
    }

    public KnowledgeBase build(Set<ATermAppl> axioms) {
        this.reset();
        for (ATermAppl axiom : axioms) {
            this.add(axiom);
        }
        return this._kb;
    }

    private void defineClass(ATermAppl cls) {
        this._defVisitor.visit(cls);
    }

    private void defineProperty(ATerm p) {
        if (p instanceof ATermList) {
            ATermList l = (ATermList)p;
            while (!l.isEmpty()) {
                ATermAppl r = (ATermAppl)l.getFirst();
                this.defineProperty(r);
                l = l.getNext();
            }
        } else if (ATermUtils.isInv((ATermAppl)p)) {
            this._kb.addObjectProperty(((ATermAppl)p).getArgument(0));
        } else if (this._originalKB.isDatatypeProperty(p)) {
            this._kb.addDatatypeProperty(p);
        } else {
            this._kb.addObjectProperty(p);
        }
    }

    public void reset() {
        this._kb = new KnowledgeBaseImpl();
    }

    private class DefinitionVisitor
    extends ATermBaseVisitor {
        private DefinitionVisitor() {
        }

        @Override
        public void visitAll(ATermAppl term) {
            this.visitQR(term);
        }

        @Override
        public void visitAnd(ATermAppl term) {
            this.visitList((ATermList)term.getArgument(0));
        }

        @Override
        public void visitCard(ATermAppl term) {
            this.visitQCR(term);
        }

        @Override
        public void visitHasValue(ATermAppl term) {
            this.visitQR(term);
        }

        @Override
        public void visitLiteral(ATermAppl term) {
        }

        @Override
        public void visitMax(ATermAppl term) {
            this.visitQCR(term);
        }

        @Override
        public void visitMin(ATermAppl term) {
            this.visitQCR(term);
        }

        @Override
        public void visitNot(ATermAppl term) {
            this.visit((ATermAppl)term.getArgument(0));
        }

        @Override
        public void visitOneOf(ATermAppl term) {
            this.visitList((ATermList)term.getArgument(0));
        }

        @Override
        public void visitOr(ATermAppl term) {
            this.visitList((ATermList)term.getArgument(0));
        }

        private void visitQCR(ATermAppl term) {
            ATermAppl p = (ATermAppl)term.getArgument(0);
            ATermAppl q = (ATermAppl)term.getArgument(2);
            this.visitRestr(p, q);
        }

        private void visitQR(ATermAppl term) {
            ATermAppl p = (ATermAppl)term.getArgument(0);
            ATermAppl q = (ATermAppl)term.getArgument(1);
            this.visitRestr(p, q);
        }

        private void visitRestr(ATermAppl p, ATermAppl q) {
            if (OntBuilder.this._originalKB.isObjectProperty(p)) {
                OntBuilder.this._kb.addObjectProperty(p);
                this.visit(q);
            } else {
                OntBuilder.this._kb.addDatatypeProperty(p);
            }
        }

        @Override
        public void visitSelf(ATermAppl term) {
            OntBuilder.this._kb.addObjectProperty(term.getArgument(0));
        }

        @Override
        public void visitSome(ATermAppl term) {
            this.visitQR(term);
        }

        @Override
        public void visitTerm(ATermAppl term) {
            OntBuilder.this._kb.addClass(term);
        }

        @Override
        public void visitValue(ATermAppl term) {
            ATermAppl nominal = (ATermAppl)term.getArgument(0);
            if (!ATermUtils.isLiteral(nominal)) {
                OntBuilder.this._kb.addIndividual(nominal);
            }
        }

        @Override
        public void visitInverse(ATermAppl term) {
            ATermAppl p = (ATermAppl)term.getArgument(0);
            if (ATermUtils.isPrimitive(p)) {
                OntBuilder.this._kb.addObjectProperty(p);
            } else {
                this.visitInverse(p);
            }
        }

        @Override
        public void visitRestrictedDatatype(ATermAppl dt) {
        }
    }
}

