/*
 * Decompiled with CFR 0.152.
 */
package openllet.core.utils.iterator;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import openllet.core.utils.iterator.FlattenningIterator;
import openllet.core.utils.iterator.MultiIterator;

public class IteratorUtils {
    private static final Iterator<Object> EMPTY_ITERATOR = new Iterator<Object>(){

        @Override
        public boolean hasNext() {
            return false;
        }

        @Override
        public Object next() {
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    };

    public static <T> Iterator<T> concat(Iterator<? extends T> i1, Iterator<? extends T> i2) {
        return new MultiIterator<T>(i1, i2);
    }

    public static final <T> Iterator<T> emptyIterator() {
        return EMPTY_ITERATOR;
    }

    public static final <T> Iterator<T> singletonIterator(T element) {
        return new SingletonIterator(element);
    }

    public static <T> Set<T> toSet(Iterator<T> i) {
        HashSet<T> set = new HashSet<T>();
        while (i.hasNext()) {
            set.add(i.next());
        }
        return set;
    }

    public static <T> List<T> toList(Iterator<T> i) {
        ArrayList<T> set = new ArrayList<T>();
        while (i.hasNext()) {
            set.add(i.next());
        }
        return set;
    }

    public static <T> Iterator<T> flatten(Iterator<? extends Iterable<T>> iterator) {
        return new FlattenningIterator(iterator);
    }

    @SafeVarargs
    public static <T> Iterator<T> iterator(T ... elements) {
        return new ArrayIterator<T>(elements, elements.length);
    }

    @SafeVarargs
    public static <T> Iterator<T> iterator(int size, T ... elements) {
        return new ArrayIterator<T>(elements, size);
    }

    private static class ArrayIterator<E>
    implements Iterator<E> {
        private final E[] _array;
        private final int _size;
        private int _curr = 0;

        public ArrayIterator(E[] array, int size) {
            this._array = array;
            this._size = size;
        }

        @Override
        public boolean hasNext() {
            return this._curr != this._size;
        }

        @Override
        public E next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            return this._array[this._curr++];
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private static class SingletonIterator<T>
    implements Iterator<T> {
        private final T _element;
        private boolean _consumed;

        private SingletonIterator(T element) {
            this._element = element;
            this._consumed = false;
        }

        @Override
        public boolean hasNext() {
            return !this._consumed;
        }

        @Override
        public T next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this._consumed = true;
            return this._element;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

