/*
 * Decompiled with CFR 0.152.
 */
package openllet.core.utils.progress;

import java.io.PrintStream;
import openllet.core.utils.DurationFormat;
import openllet.core.utils.progress.AbstractProgressMonitor;

public class ConsoleProgressMonitor
extends AbstractProgressMonitor {
    private final PrintStream _out;
    private volatile int _echo = 0;

    @Override
    public int getLastEcho() {
        return this._echo;
    }

    public ConsoleProgressMonitor() {
        this(System.err, 0);
    }

    public ConsoleProgressMonitor(PrintStream out) {
        this(out, 0);
    }

    public ConsoleProgressMonitor(int length) {
        this(System.err, length);
    }

    public ConsoleProgressMonitor(PrintStream out, int length) {
        this._out = out;
        this.setProgressLength(length);
        this.setProgressTitle("");
    }

    @Override
    protected void resetProgress() {
        super.resetProgress();
    }

    @Override
    public void taskStarted() {
        super.taskStarted();
        this._out.println(this._progressTitle + " " + this._progressLength + " elements");
    }

    @Override
    protected void updateProgress() {
        int pc = (int)(100.0 * (double)this._progress / (double)this._progressLength);
        if (pc == this._progressPercent) {
            return;
        }
        this._progressPercent = pc;
        if (pc < this._echo) {
            return;
        }
        this._echo += this.getEchoInterval();
        this._out.print('\r');
        this._out.print(this._progressTitle);
        this._out.print(": ");
        this._out.print(this._progressMessage);
        this._out.print(" ");
        this._out.print(this._progressPercent);
        this._out.print("% complete in ");
        this._out.print(DurationFormat.SHORT.format(this._timer.getElapsed()));
    }

    @Deprecated
    public String calcElapsedTime() {
        return DurationFormat.SHORT.format(this._timer.getElapsed());
    }

    @Override
    public void taskFinished() {
        super.taskFinished();
        this.setProgress(this._progressLength);
        this._out.println();
        this._out.print(this._progressTitle);
        this._out.print(" finished in ");
        this._out.println(DurationFormat.SHORT.format(this._timer.getLast()));
    }
}

