/*
 * Decompiled with CFR 0.152.
 */
package openllet.core.utils.progress;

import javax.swing.ProgressMonitor;
import javax.swing.SwingUtilities;
import openllet.core.utils.progress.AbstractProgressMonitor;

public class SwingProgressMonitor
extends AbstractProgressMonitor {
    private volatile int _echo = 0;
    private ProgressMonitor _monitor = null;

    @Override
    public int getLastEcho() {
        return this._echo;
    }

    public SwingProgressMonitor() {
    }

    public SwingProgressMonitor(int length) {
        super(length);
    }

    @Override
    public boolean isCanceled() {
        return this._monitor.isCanceled();
    }

    @Override
    protected void resetProgress() {
        super.resetProgress();
        this._monitor = new ProgressMonitor(null, this._progressTitle, this._progressMessage, 0, this._progressLength);
        this._monitor.setProgress(this._progress);
    }

    @Override
    public void setProgressMessage(String progressMessage) {
        super.setProgressMessage(progressMessage);
        this._monitor.setNote(progressMessage);
    }

    @Override
    public void taskFinished() {
        super.taskFinished();
        this._monitor.close();
    }

    @Override
    protected void updateProgress() {
        SwingUtilities.invokeLater(() -> {
            this._echo = this._progress;
            this._monitor.setProgress(this._progress);
        });
    }
}

