/*
 * Decompiled with CFR 0.152.
 */
package openllet.owlapi;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.logging.Logger;
import openllet.aterm.ATerm;
import openllet.aterm.ATermAppl;
import openllet.aterm.ATermList;
import openllet.atom.OpenError;
import openllet.core.KnowledgeBase;
import openllet.core.exceptions.InternalReasonerException;
import openllet.core.utils.ATermUtils;
import openllet.core.utils.SetUtils;
import openllet.owlapi.ConceptConverter;
import openllet.owlapi.OpenlletReasoner;
import openllet.owlapi.SWRL;
import openllet.owlapi.facet.FacetFactoryOWL;
import openllet.shared.tools.Log;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLDataPropertyExpression;
import org.semanticweb.owlapi.model.OWLDataRange;
import org.semanticweb.owlapi.model.OWLDatatype;
import org.semanticweb.owlapi.model.OWLIndividual;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.model.OWLLogicalAxiom;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.model.OWLPropertyRange;
import org.semanticweb.owlapi.model.SWRLAtom;
import org.semanticweb.owlapi.model.SWRLBuiltInAtom;
import org.semanticweb.owlapi.model.SWRLClassAtom;
import org.semanticweb.owlapi.model.SWRLDArgument;
import org.semanticweb.owlapi.model.SWRLDataPropertyAtom;
import org.semanticweb.owlapi.model.SWRLDataRangeAtom;
import org.semanticweb.owlapi.model.SWRLDifferentIndividualsAtom;
import org.semanticweb.owlapi.model.SWRLIArgument;
import org.semanticweb.owlapi.model.SWRLObjectPropertyAtom;
import org.semanticweb.owlapi.model.SWRLSameIndividualAtom;

public class AxiomConverter
implements FacetFactoryOWL {
    public static final Logger _logger = Log.getLogger(AxiomConverter.class);
    private final ConceptConverter _conceptConverter;
    private final KnowledgeBase _kb;
    private final OWLDataFactory _factory;

    @Override
    public OWLDataFactory getFactory() {
        return this._factory;
    }

    public AxiomConverter(OpenlletReasoner reasoner) {
        this(reasoner.getKB(), reasoner.getManager().getOWLDataFactory());
    }

    public AxiomConverter(KnowledgeBase kb, OWLDataFactory factory) {
        if (kb == null) {
            throw new OpenError("KnowledgeBase is null");
        }
        if (factory == null) {
            throw new OpenError("OWLDataFactory is null");
        }
        this._kb = kb;
        this._factory = factory;
        this._conceptConverter = new ConceptConverter(kb, factory);
    }

    public OWLAxiom convert(ATermAppl termParam) {
        ATermAppl term = termParam;
        OWLLogicalAxiom axiom = null;
        if (term.getAFun().equals(ATermUtils.EQCLASSFUN)) {
            OWLClassExpression c1 = (OWLClassExpression)this._conceptConverter.convert((ATermAppl)term.getArgument(0));
            OWLClassExpression c2 = (OWLClassExpression)this._conceptConverter.convert((ATermAppl)term.getArgument(1));
            HashSet<OWLClassExpression> descriptions = new HashSet<OWLClassExpression>();
            descriptions.add(c1);
            descriptions.add(c2);
            if (c1 != null && c2 != null) {
                axiom = this._factory.getOWLEquivalentClassesAxiom(descriptions);
            }
        } else if (term.getAFun().equals(ATermUtils.SUBFUN)) {
            OWLClassExpression c1 = (OWLClassExpression)this._conceptConverter.convert((ATermAppl)term.getArgument(0));
            OWLClassExpression c2 = (OWLClassExpression)this._conceptConverter.convert((ATermAppl)term.getArgument(1));
            if (c1 != null && c2 != null) {
                axiom = this._factory.getOWLSubClassOfAxiom(c1, c2);
            }
        } else if (term.getAFun().equals(ATermUtils.DISJOINTSFUN)) {
            ATermAppl concept;
            OWLClassExpression c;
            HashSet<OWLClassExpression> descriptions = new HashSet<OWLClassExpression>();
            ATermList concepts = (ATermList)term.getArgument(0);
            while (!concepts.isEmpty() && (c = (OWLClassExpression)this._conceptConverter.convert(concept = (ATermAppl)concepts.getFirst())) != null) {
                descriptions.add(c);
                concepts = concepts.getNext();
            }
            if (concepts.isEmpty()) {
                axiom = this._factory.getOWLDisjointClassesAxiom(descriptions);
            }
        } else if (term.getAFun().equals(ATermUtils.DISJOINTFUN)) {
            OWLClassExpression c1 = (OWLClassExpression)this._conceptConverter.convert((ATermAppl)term.getArgument(0));
            OWLClassExpression c2 = (OWLClassExpression)this._conceptConverter.convert((ATermAppl)term.getArgument(1));
            HashSet<OWLClassExpression> descriptions = new HashSet<OWLClassExpression>();
            descriptions.add(c1);
            descriptions.add(c2);
            if (c1 != null && c2 != null) {
                axiom = this._factory.getOWLDisjointClassesAxiom(descriptions);
            }
        } else if (term.getAFun().equals(ATermUtils.DISJOINTPROPSFUN)) {
            OWLObject p;
            HashSet<OWLObjectProperty> objProperties = new HashSet<OWLObjectProperty>();
            HashSet<OWLDataProperty> dataProperties = new HashSet<OWLDataProperty>();
            ATermList props = (ATermList)term.getArgument(0);
            while (!props.isEmpty() && (p = this._conceptConverter.convert((ATermAppl)term.getArgument(0))) != null) {
                if (p instanceof OWLObjectProperty) {
                    if (!dataProperties.isEmpty()) break;
                    objProperties.add((OWLObjectProperty)p);
                } else {
                    if (!objProperties.isEmpty()) break;
                    dataProperties.add((OWLDataProperty)p);
                }
                props = props.getNext();
            }
            if (props.isEmpty()) {
                axiom = !objProperties.isEmpty() ? this._factory.getOWLDisjointObjectPropertiesAxiom(objProperties) : this._factory.getOWLDisjointDataPropertiesAxiom(dataProperties);
            }
        } else if (term.getAFun().equals(ATermUtils.DISJOINTPROPFUN)) {
            OWLObject p1 = this._conceptConverter.convert((ATermAppl)term.getArgument(0));
            OWLObject p2 = this._conceptConverter.convert((ATermAppl)term.getArgument(1));
            if (p1 != null && p2 != null) {
                if (p1 instanceof OWLObjectProperty && p2 instanceof OWLObjectProperty) {
                    axiom = this._factory.getOWLDisjointObjectPropertiesAxiom(SetUtils.create((OWLObjectProperty)p1, (OWLObjectProperty)p2));
                } else if (p1 instanceof OWLDataProperty && p2 instanceof OWLDataProperty) {
                    axiom = this._factory.getOWLDisjointDataPropertiesAxiom(SetUtils.create((OWLDataProperty)p1, (OWLDataProperty)p2));
                }
            }
        } else if (term.getAFun().equals(ATermUtils.SUBPROPFUN)) {
            if (term.getArgument(0) instanceof ATermList) {
                ArrayList<OWLObjectPropertyExpression> subs = new ArrayList<OWLObjectPropertyExpression>();
                ATermList list = (ATermList)term.getArgument(0);
                while (!list.isEmpty()) {
                    OWLObjectPropertyExpression p = (OWLObjectPropertyExpression)this._conceptConverter.convert((ATermAppl)list.getFirst());
                    if (p == null) {
                        subs = null;
                        break;
                    }
                    subs.add(p);
                    list = list.getNext();
                }
                OWLObjectProperty sup = (OWLObjectProperty)this._conceptConverter.convert((ATermAppl)term.getArgument(1));
                if (subs != null && sup != null) {
                    axiom = this._factory.getOWLSubPropertyChainOfAxiom(subs, sup);
                }
            } else {
                OWLObject p1 = this._conceptConverter.convert((ATermAppl)term.getArgument(0));
                OWLObject p2 = this._conceptConverter.convert((ATermAppl)term.getArgument(1));
                if (p1 != null && p2 != null) {
                    if (p1 instanceof OWLObjectPropertyExpression && p2 instanceof OWLObjectPropertyExpression) {
                        axiom = this._factory.getOWLSubObjectPropertyOfAxiom((OWLObjectPropertyExpression)p1, (OWLObjectPropertyExpression)p2);
                    } else if (p1 instanceof OWLDataProperty && p2 instanceof OWLDataProperty) {
                        axiom = this._factory.getOWLSubDataPropertyOfAxiom((OWLDataProperty)p1, (OWLDataProperty)p2);
                    }
                }
            }
        } else if (term.getAFun().equals(ATermUtils.EQPROPFUN)) {
            OWLObject p1 = this._conceptConverter.convert((ATermAppl)term.getArgument(0));
            OWLObject p2 = this._conceptConverter.convert((ATermAppl)term.getArgument(1));
            if (p1 != null && p2 != null) {
                if (p1 instanceof OWLObjectProperty && p2 instanceof OWLObjectProperty) {
                    axiom = this._factory.getOWLEquivalentObjectPropertiesAxiom(SetUtils.create((OWLObjectProperty)p1, (OWLObjectProperty)p2));
                } else if (p1 instanceof OWLDataProperty && p2 instanceof OWLDataProperty) {
                    axiom = this._factory.getOWLEquivalentDataPropertiesAxiom(SetUtils.create((OWLDataProperty)p1, (OWLDataProperty)p2));
                }
            }
        } else if (term.getAFun().equals(ATermUtils.DOMAINFUN)) {
            OWLObject p = this._conceptConverter.convert((ATermAppl)term.getArgument(0));
            OWLClassExpression c = (OWLClassExpression)this._conceptConverter.convert((ATermAppl)term.getArgument(1));
            if (c != null && p != null) {
                axiom = p instanceof OWLObjectProperty ? this._factory.getOWLObjectPropertyDomainAxiom((OWLObjectPropertyExpression)p, c) : this._factory.getOWLDataPropertyDomainAxiom((OWLDataPropertyExpression)p, c);
            }
        } else if (term.getAFun().equals(ATermUtils.RANGEFUN)) {
            OWLPropertyRange e = (OWLPropertyRange)this._conceptConverter.convert((ATermAppl)term.getArgument(1));
            if (e != null) {
                if (e instanceof OWLClassExpression) {
                    OWLObjectProperty p = (OWLObjectProperty)this._conceptConverter.convert((ATermAppl)term.getArgument(0));
                    if (p != null) {
                        axiom = this._factory.getOWLObjectPropertyRangeAxiom(p, (OWLClassExpression)e);
                    }
                } else {
                    OWLDataProperty p = (OWLDataProperty)this._conceptConverter.convert((ATermAppl)term.getArgument(0));
                    if (p != null) {
                        axiom = this._factory.getOWLDataPropertyRangeAxiom((OWLDataPropertyExpression)p, (OWLDataRange)e);
                    }
                }
            }
        } else if (term.getAFun().equals(ATermUtils.INVPROPFUN)) {
            OWLObjectProperty p1 = (OWLObjectProperty)this._conceptConverter.convert((ATermAppl)term.getArgument(0));
            OWLObjectProperty p2 = (OWLObjectProperty)this._conceptConverter.convert((ATermAppl)term.getArgument(1));
            if (p1 != null && p2 != null) {
                axiom = this._factory.getOWLInverseObjectPropertiesAxiom(p1, p2);
            }
        } else if (term.getAFun().equals(ATermUtils.TRANSITIVEFUN)) {
            OWLObjectProperty p = (OWLObjectProperty)this._conceptConverter.convert((ATermAppl)term.getArgument(0));
            if (p != null) {
                axiom = this._factory.getOWLTransitiveObjectPropertyAxiom(p);
            }
        } else if (term.getAFun().equals(ATermUtils.FUNCTIONALFUN)) {
            OWLObject p = this._conceptConverter.convert((ATermAppl)term.getArgument(0));
            if (p != null) {
                if (p instanceof OWLObjectProperty) {
                    axiom = this._factory.getOWLFunctionalObjectPropertyAxiom((OWLObjectPropertyExpression)p);
                } else if (p instanceof OWLDataProperty) {
                    axiom = this._factory.getOWLFunctionalDataPropertyAxiom((OWLDataPropertyExpression)p);
                }
            }
        } else if (term.getAFun().equals(ATermUtils.INVFUNCTIONALFUN)) {
            OWLObjectProperty p = (OWLObjectProperty)this._conceptConverter.convert((ATermAppl)term.getArgument(0));
            if (p != null) {
                axiom = this._factory.getOWLInverseFunctionalObjectPropertyAxiom(p);
            }
        } else if (term.getAFun().equals(ATermUtils.SYMMETRICFUN)) {
            OWLObject p = this._conceptConverter.convert((ATermAppl)term.getArgument(0));
            if (p != null && p instanceof OWLObjectPropertyExpression) {
                axiom = this._factory.getOWLSymmetricObjectPropertyAxiom((OWLObjectPropertyExpression)p);
            }
        } else if (term.getAFun().equals(ATermUtils.ASYMMETRICFUN)) {
            OWLObject p = this._conceptConverter.convert((ATermAppl)term.getArgument(0));
            if (p != null && p instanceof OWLObjectPropertyExpression) {
                axiom = this._factory.getOWLAsymmetricObjectPropertyAxiom((OWLObjectPropertyExpression)p);
            }
        } else if (term.getAFun().equals(ATermUtils.REFLEXIVEFUN)) {
            OWLObject p = this._conceptConverter.convert((ATermAppl)term.getArgument(0));
            if (p != null && p instanceof OWLObjectPropertyExpression) {
                axiom = this._factory.getOWLReflexiveObjectPropertyAxiom((OWLObjectPropertyExpression)p);
            }
        } else if (term.getAFun().equals(ATermUtils.IRREFLEXIVEFUN)) {
            OWLObject p = this._conceptConverter.convert((ATermAppl)term.getArgument(0));
            if (p != null && p instanceof OWLObjectPropertyExpression) {
                axiom = this._factory.getOWLIrreflexiveObjectPropertyAxiom((OWLObjectPropertyExpression)p);
            }
        } else if (term.getAFun().equals(ATermUtils.TYPEFUN)) {
            OWLIndividual i = this._conceptConverter.convertIndividual((ATermAppl)term.getArgument(0));
            OWLClassExpression c = (OWLClassExpression)this._conceptConverter.convert((ATermAppl)term.getArgument(1));
            if (i != null && c != null) {
                axiom = this._factory.getOWLClassAssertionAxiom(c, i);
            }
        } else if (term.getAFun().equals(ATermUtils.PROPFUN)) {
            OWLIndividual subj = this._conceptConverter.convertIndividual((ATermAppl)term.getArgument(1));
            if (subj != null) {
                if (ATermUtils.isLiteral((ATermAppl)term.getArgument(2))) {
                    OWLDataProperty pred = (OWLDataProperty)this._conceptConverter.convert((ATermAppl)term.getArgument(0));
                    OWLLiteral obj = (OWLLiteral)this._conceptConverter.convert((ATermAppl)term.getArgument(2));
                    if (pred != null && obj != null) {
                        axiom = this._factory.getOWLDataPropertyAssertionAxiom((OWLDataPropertyExpression)pred, subj, obj);
                    }
                } else {
                    OWLObjectProperty pred = (OWLObjectProperty)this._conceptConverter.convert((ATermAppl)term.getArgument(0));
                    OWLIndividual obj = this._conceptConverter.convertIndividual((ATermAppl)term.getArgument(2));
                    if (pred != null && obj != null) {
                        axiom = this._factory.getOWLObjectPropertyAssertionAxiom(pred, subj, obj);
                    }
                }
            }
        } else if (term.getAFun().equals(ATermUtils.NOTFUN) && ((ATermAppl)term.getArgument(0)).getAFun().equals(ATermUtils.PROPFUN)) {
            OWLIndividual subj = this._conceptConverter.convertIndividual((ATermAppl)(term = (ATermAppl)term.getArgument(0)).getArgument(1));
            if (subj != null) {
                if (ATermUtils.isLiteral((ATermAppl)term.getArgument(2))) {
                    OWLDataProperty pred = (OWLDataProperty)this._conceptConverter.convert((ATermAppl)term.getArgument(0));
                    OWLLiteral obj = (OWLLiteral)this._conceptConverter.convert((ATermAppl)term.getArgument(2));
                    if (pred != null && obj != null) {
                        axiom = this._factory.getOWLNegativeDataPropertyAssertionAxiom(pred, subj, obj);
                    }
                } else {
                    OWLObjectProperty pred = (OWLObjectProperty)this._conceptConverter.convert((ATermAppl)term.getArgument(0));
                    OWLIndividual obj = this._conceptConverter.convertIndividual((ATermAppl)term.getArgument(2));
                    if (pred != null && obj != null) {
                        axiom = this._factory.getOWLNegativeObjectPropertyAssertionAxiom(pred, subj, obj);
                    }
                }
            }
        } else if (term.getAFun().equals(ATermUtils.SAMEASFUN)) {
            OWLIndividual ind1 = this._conceptConverter.convertIndividual((ATermAppl)term.getArgument(0));
            OWLIndividual ind2 = this._conceptConverter.convertIndividual((ATermAppl)term.getArgument(1));
            HashSet<OWLIndividual> inds = new HashSet<OWLIndividual>();
            inds.add(ind1);
            inds.add(ind2);
            if (ind1 != null && ind2 != null) {
                axiom = this._factory.getOWLSameIndividualAxiom(inds);
            }
        } else if (term.getAFun().equals(ATermUtils.DIFFERENTFUN)) {
            OWLIndividual ind1 = this._conceptConverter.convertIndividual((ATermAppl)term.getArgument(0));
            OWLIndividual ind2 = this._conceptConverter.convertIndividual((ATermAppl)term.getArgument(1));
            HashSet<OWLIndividual> inds = new HashSet<OWLIndividual>();
            inds.add(ind1);
            inds.add(ind2);
            if (ind1 != null && ind2 != null) {
                axiom = this._factory.getOWLDifferentIndividualsAxiom(inds);
            }
        } else if (term.getAFun().equals(ATermUtils.ALLDIFFERENTFUN)) {
            ATermAppl ind;
            OWLIndividual i;
            HashSet<OWLIndividual> individuals = new HashSet<OWLIndividual>();
            ATermList list = (ATermList)term.getArgument(0);
            while (!list.isEmpty() && (i = this._conceptConverter.convertIndividual(ind = (ATermAppl)list.getFirst())) != null) {
                individuals.add(i);
                list = list.getNext();
            }
            if (list.isEmpty()) {
                axiom = this._factory.getOWLDifferentIndividualsAxiom(individuals);
            }
        } else if (term.getAFun().equals(ATermUtils.RULEFUN)) {
            LinkedHashSet<SWRLAtom> antecedent = new LinkedHashSet<SWRLAtom>();
            LinkedHashSet<SWRLAtom> consequent = new LinkedHashSet<SWRLAtom>();
            ATermList head = (ATermList)term.getArgument(1);
            ATermList body = (ATermList)term.getArgument(2);
            for (ATerm bodyTerm : body) {
                antecedent.add(this.parseToSWRLAtom((ATermAppl)bodyTerm));
            }
            for (ATerm headTerm : head) {
                consequent.add(this.parseToSWRLAtom((ATermAppl)headTerm));
            }
            if (!antecedent.contains(null) && !consequent.contains(null)) {
                ATermAppl name = (ATermAppl)term.getArgument(0);
                axiom = name == ATermUtils.EMPTY ? this._factory.getSWRLRule(antecedent, consequent) : (ATermUtils.isBnode(name) ? this._factory.getSWRLRule(antecedent, consequent) : SWRL.rule(name.getAFun().getName(), antecedent, consequent));
            }
        } else if (term.getAFun().equals(ATermUtils.DATATYPEDEFFUN)) {
            OWLDatatype d1 = (OWLDatatype)this._conceptConverter.convert((ATermAppl)term.getArgument(0));
            OWLDataRange d2 = (OWLDataRange)this._conceptConverter.convert((ATermAppl)term.getArgument(1));
            if (d1 != null && d2 != null) {
                axiom = this._factory.getOWLDatatypeDefinitionAxiom(d1, d2);
            }
        }
        if (axiom == null) {
            _logger.warning("Cannot convert to OWLAPI: " + term);
        }
        return axiom;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private SWRLAtom parseToSWRLAtom(ATermAppl term) {
        void var2_12;
        Object var2_2 = null;
        if (term.getAFun().equals(ATermUtils.TYPEFUN)) {
            ATermAppl i = (ATermAppl)term.getArgument(0);
            OWLObject type = this._conceptConverter.convert((ATermAppl)term.getArgument(1));
            if (type instanceof OWLClassExpression) {
                SWRLIArgument io = this.parseToAtomIObject(i);
                SWRLClassAtom sWRLClassAtom = this._factory.getSWRLClassAtom((OWLClassExpression)type, io);
            } else {
                if (!(type instanceof OWLDataRange)) throw new InternalReasonerException("Cannot convert to SWRL atom: " + ATermUtils.toString(term));
                SWRLDArgument io = this.parseToAtomDObject(i);
                SWRLDataRangeAtom sWRLDataRangeAtom = this._factory.getSWRLDataRangeAtom((OWLDataRange)type, io);
            }
        } else if (term.getAFun().equals(ATermUtils.PROPFUN)) {
            ATermAppl p = (ATermAppl)term.getArgument(0);
            ATermAppl i1 = (ATermAppl)term.getArgument(1);
            ATermAppl i2 = (ATermAppl)term.getArgument(2);
            SWRLIArgument io1 = this.parseToAtomIObject(i1);
            if (this._kb.isObjectProperty(p)) {
                SWRLIArgument io2 = this.parseToAtomIObject(i2);
                OWLObjectProperty op = this._factory.getOWLObjectProperty(IRI.create(p.getName()));
                SWRLObjectPropertyAtom sWRLObjectPropertyAtom = this._factory.getSWRLObjectPropertyAtom(op, io1, io2);
            } else if (this._kb.isDatatypeProperty(p)) {
                SWRLDArgument do2 = this.parseToAtomDObject(i2);
                OWLDataProperty dp = this._factory.getOWLDataProperty(IRI.create(p.getName()));
                SWRLDataPropertyAtom sWRLDataPropertyAtom = this._factory.getSWRLDataPropertyAtom(dp, io1, do2);
            }
        } else if (term.getAFun().equals(ATermUtils.SAMEASFUN)) {
            ATermAppl i1 = (ATermAppl)term.getArgument(0);
            ATermAppl i2 = (ATermAppl)term.getArgument(1);
            SWRLIArgument io1 = this.parseToAtomIObject(i1);
            SWRLIArgument io2 = this.parseToAtomIObject(i2);
            SWRLSameIndividualAtom sWRLSameIndividualAtom = this._factory.getSWRLSameIndividualAtom(io1, io2);
        } else if (term.getAFun().equals(ATermUtils.DIFFERENTFUN)) {
            ATermAppl i1 = (ATermAppl)term.getArgument(0);
            ATermAppl i2 = (ATermAppl)term.getArgument(1);
            SWRLIArgument io1 = this.parseToAtomIObject(i1);
            SWRLIArgument io2 = this.parseToAtomIObject(i2);
            SWRLDifferentIndividualsAtom sWRLDifferentIndividualsAtom = this._factory.getSWRLDifferentIndividualsAtom(io1, io2);
        } else if (term.getAFun().equals(ATermUtils.BUILTINFUN)) {
            ATermList args = (ATermList)term.getArgument(0);
            ATermAppl builtin = (ATermAppl)args.getFirst();
            ArrayList<SWRLDArgument> list = new ArrayList<SWRLDArgument>();
            args = args.getNext();
            while (!args.isEmpty()) {
                ATermAppl arg = (ATermAppl)args.getFirst();
                list.add(this.parseToAtomDObject(arg));
                args = args.getNext();
            }
            SWRLBuiltInAtom sWRLBuiltInAtom = this._factory.getSWRLBuiltInAtom(IRI.create(builtin.getName()), list);
        }
        if (var2_12 != null) return var2_12;
        _logger.warning("Cannot convert to SWRLAtom: " + term);
        return var2_12;
    }

    private SWRLIArgument parseToAtomIObject(ATermAppl t) {
        if (ATermUtils.isVar(t)) {
            return this._factory.getSWRLVariable(IRI.create(((ATermAppl)t.getArgument(0)).getName()));
        }
        if (this._kb.isIndividual(t)) {
            return this._factory.getSWRLIndividualArgument(this._conceptConverter.convertIndividual(t));
        }
        throw new InternalReasonerException("Unrecognized term: " + t);
    }

    private SWRLDArgument parseToAtomDObject(ATermAppl t) {
        if (ATermUtils.isVar(t)) {
            return this._factory.getSWRLVariable(IRI.create(((ATermAppl)t.getArgument(0)).getName()));
        }
        if (ATermUtils.isLiteral(t)) {
            return this._factory.getSWRLLiteralArgument((OWLLiteral)this._conceptConverter.convert(t));
        }
        throw new InternalReasonerException("Unrecognized term: " + t);
    }
}

