/*
 * Decompiled with CFR 0.152.
 */
package openllet.owlapi;

import java.lang.reflect.Method;
import java.time.Instant;
import java.util.Random;
import java.util.concurrent.atomic.AtomicLong;
import org.semanticweb.owlapi.model.IRI;

public interface IRIUtils {
    public static final Random _random = new Random();
    public static final AtomicLong _atomic = new AtomicLong(0L);
    public static final long _timeShift = 1450656000000L;

    public static String shortTime() {
        return IRIUtils.shortTime(System.currentTimeMillis());
    }

    public static String shortTime(long epochMilli) {
        return Long.toHexString(epochMilli - 1450656000000L);
    }

    public static Instant instantFromShortTime(String hexTime) {
        return Instant.ofEpochMilli(Long.parseLong(hexTime, 16) + 1450656000000L);
    }

    public static Instant instantFromRandStr(String rand) {
        return IRIUtils.instantFromShortTime(rand.substring(rand.indexOf("_") + 1, rand.lastIndexOf("_")));
    }

    public static String randStr() {
        return _atomic.getAndIncrement() + "_" + IRIUtils.shortTime() + "_" + Integer.toHexString(_random.nextInt());
    }

    public static String randId(String begin) {
        return begin + "_" + IRIUtils.randStr() + "_";
    }

    @Deprecated
    public static boolean isIRI(String resource) {
        return resource != null && (resource.startsWith("http://") || resource.startsWith("https://"));
    }

    public static String iriModel2iri(String iri) {
        return !iri.startsWith("{") ? iri : iri.replaceAll("[\\{\\}]", "");
    }

    public static <T> String base(Class<T> clazz) {
        return "http://" + clazz.getPackage().getName() + "/" + clazz.getSimpleName();
    }

    public static <T> String core(Class<T> clazz) {
        return "http://" + clazz.getPackage().getName() + "#" + clazz.getSimpleName();
    }

    public static <T> String core(Class<T> clazz, Method method) {
        return "http://" + clazz.getPackage().getName() + "#" + method.getName();
    }

    public static <T> IRI name(Class<T> clazz, String entity) {
        return IRI.create(IRIUtils.base(clazz) + "#" + entity);
    }

    public static <T> IRI rand(Class<T> clazz) {
        return IRI.create(IRIUtils.base(clazz) + "#" + IRIUtils.randId(clazz.getSimpleName()));
    }

    public static <T> IRI rand(Class<T> clazz, String entity) {
        return IRI.create(IRIUtils.base(clazz) + "/" + entity + "#" + IRIUtils.randId(clazz.getSimpleName()));
    }

    public static <T> IRI method(Class<T> clazz, Method m) {
        return IRI.create(IRIUtils.core(clazz, m));
    }

    public static <T> IRI clazz(Class<T> clazz) {
        return IRI.create(IRIUtils.core(clazz));
    }

    public static <T> IRI ontology(Class<T> clazz, String purpose, String entity) {
        return IRI.create(IRIUtils.base(clazz) + "/" + purpose + "#" + entity);
    }
}

