/*
 * Decompiled with CFR 0.152.
 */
package openllet.owlapi;

import openllet.owlapi.OpenlletReasoner;
import openllet.owlapi.PelletReasoner;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.reasoner.BufferingMode;
import org.semanticweb.owlapi.reasoner.IllegalConfigurationException;
import org.semanticweb.owlapi.reasoner.OWLReasonerConfiguration;
import org.semanticweb.owlapi.reasoner.OWLReasonerFactory;

public class OpenlletReasonerFactory
implements OWLReasonerFactory {
    private static final OpenlletReasonerFactory INSTANCE = new OpenlletReasonerFactory();

    public static OpenlletReasonerFactory getInstance() {
        return INSTANCE;
    }

    @Override
    public String getReasonerName() {
        return "Openllet";
    }

    public String toString() {
        return this.getReasonerName();
    }

    @Override
    public OpenlletReasoner createReasoner(OWLOntology ontology) {
        return new PelletReasoner(ontology, BufferingMode.BUFFERING);
    }

    @Override
    public OpenlletReasoner createReasoner(OWLOntology ontology, OWLReasonerConfiguration config) throws IllegalConfigurationException {
        return new PelletReasoner(ontology, config, BufferingMode.BUFFERING);
    }

    @Override
    public OpenlletReasoner createNonBufferingReasoner(OWLOntology ontology) {
        return new PelletReasoner(ontology, BufferingMode.NON_BUFFERING);
    }

    @Override
    public OpenlletReasoner createNonBufferingReasoner(OWLOntology ontology, OWLReasonerConfiguration config) throws IllegalConfigurationException {
        return new PelletReasoner(ontology, config, BufferingMode.NON_BUFFERING);
    }
}

