/*
 * Decompiled with CFR 0.152.
 */
package openllet.owlapi;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Logger;
import openllet.aterm.ATerm;
import openllet.aterm.ATermAppl;
import openllet.aterm.ATermList;
import openllet.core.KnowledgeBase;
import openllet.core.OpenlletOptions;
import openllet.core.boxes.rbox.Role;
import openllet.core.datatypes.Facet;
import openllet.core.exceptions.UnsupportedFeatureException;
import openllet.core.rules.model.AtomDConstant;
import openllet.core.rules.model.AtomDObject;
import openllet.core.rules.model.AtomDVariable;
import openllet.core.rules.model.AtomIConstant;
import openllet.core.rules.model.AtomIObject;
import openllet.core.rules.model.AtomIVariable;
import openllet.core.rules.model.BuiltInAtom;
import openllet.core.rules.model.ClassAtom;
import openllet.core.rules.model.DataRangeAtom;
import openllet.core.rules.model.DatavaluedPropertyAtom;
import openllet.core.rules.model.DifferentIndividualsAtom;
import openllet.core.rules.model.IndividualPropertyAtom;
import openllet.core.rules.model.Rule;
import openllet.core.rules.model.RuleAtom;
import openllet.core.rules.model.SameIndividualAtom;
import openllet.core.utils.ATermUtils;
import openllet.core.utils.AnnotationClasses;
import openllet.core.utils.Comparators;
import openllet.core.utils.MultiValueMap;
import openllet.shared.tools.Log;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAnnotation;
import org.semanticweb.owlapi.model.OWLAnnotationAssertionAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationProperty;
import org.semanticweb.owlapi.model.OWLAnnotationPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationSubject;
import org.semanticweb.owlapi.model.OWLAnonymousIndividual;
import org.semanticweb.owlapi.model.OWLAsymmetricObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassAssertionAxiom;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDataAllValuesFrom;
import org.semanticweb.owlapi.model.OWLDataComplementOf;
import org.semanticweb.owlapi.model.OWLDataExactCardinality;
import org.semanticweb.owlapi.model.OWLDataHasValue;
import org.semanticweb.owlapi.model.OWLDataIntersectionOf;
import org.semanticweb.owlapi.model.OWLDataMaxCardinality;
import org.semanticweb.owlapi.model.OWLDataMinCardinality;
import org.semanticweb.owlapi.model.OWLDataOneOf;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLDataPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLDataPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLDataPropertyExpression;
import org.semanticweb.owlapi.model.OWLDataPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLDataRange;
import org.semanticweb.owlapi.model.OWLDataSomeValuesFrom;
import org.semanticweb.owlapi.model.OWLDataUnionOf;
import org.semanticweb.owlapi.model.OWLDatatype;
import org.semanticweb.owlapi.model.OWLDatatypeDefinitionAxiom;
import org.semanticweb.owlapi.model.OWLDatatypeRestriction;
import org.semanticweb.owlapi.model.OWLDeclarationAxiom;
import org.semanticweb.owlapi.model.OWLDifferentIndividualsAxiom;
import org.semanticweb.owlapi.model.OWLDisjointClassesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointDataPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointUnionAxiom;
import org.semanticweb.owlapi.model.OWLEquivalentClassesAxiom;
import org.semanticweb.owlapi.model.OWLEquivalentDataPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLEquivalentObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLFacetRestriction;
import org.semanticweb.owlapi.model.OWLFunctionalDataPropertyAxiom;
import org.semanticweb.owlapi.model.OWLFunctionalObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLHasKeyAxiom;
import org.semanticweb.owlapi.model.OWLIndividual;
import org.semanticweb.owlapi.model.OWLInverseFunctionalObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLInverseObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLIrreflexiveObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLNegativeDataPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLNegativeObjectPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLObjectAllValuesFrom;
import org.semanticweb.owlapi.model.OWLObjectComplementOf;
import org.semanticweb.owlapi.model.OWLObjectExactCardinality;
import org.semanticweb.owlapi.model.OWLObjectHasSelf;
import org.semanticweb.owlapi.model.OWLObjectHasValue;
import org.semanticweb.owlapi.model.OWLObjectIntersectionOf;
import org.semanticweb.owlapi.model.OWLObjectInverseOf;
import org.semanticweb.owlapi.model.OWLObjectMaxCardinality;
import org.semanticweb.owlapi.model.OWLObjectMinCardinality;
import org.semanticweb.owlapi.model.OWLObjectOneOf;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLObjectPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLObjectPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.model.OWLObjectPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLObjectSomeValuesFrom;
import org.semanticweb.owlapi.model.OWLObjectUnionOf;
import org.semanticweb.owlapi.model.OWLObjectVisitor;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLReflexiveObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLSameIndividualAxiom;
import org.semanticweb.owlapi.model.OWLSubAnnotationPropertyOfAxiom;
import org.semanticweb.owlapi.model.OWLSubClassOfAxiom;
import org.semanticweb.owlapi.model.OWLSubDataPropertyOfAxiom;
import org.semanticweb.owlapi.model.OWLSubObjectPropertyOfAxiom;
import org.semanticweb.owlapi.model.OWLSubPropertyChainOfAxiom;
import org.semanticweb.owlapi.model.OWLSymmetricObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLTransitiveObjectPropertyAxiom;
import org.semanticweb.owlapi.model.SWRLAtom;
import org.semanticweb.owlapi.model.SWRLBuiltInAtom;
import org.semanticweb.owlapi.model.SWRLClassAtom;
import org.semanticweb.owlapi.model.SWRLDArgument;
import org.semanticweb.owlapi.model.SWRLDataPropertyAtom;
import org.semanticweb.owlapi.model.SWRLDataRangeAtom;
import org.semanticweb.owlapi.model.SWRLDifferentIndividualsAtom;
import org.semanticweb.owlapi.model.SWRLIArgument;
import org.semanticweb.owlapi.model.SWRLIndividualArgument;
import org.semanticweb.owlapi.model.SWRLLiteralArgument;
import org.semanticweb.owlapi.model.SWRLObjectPropertyAtom;
import org.semanticweb.owlapi.model.SWRLRule;
import org.semanticweb.owlapi.model.SWRLSameIndividualAtom;
import org.semanticweb.owlapi.model.SWRLVariable;
import org.semanticweb.owlapi.util.OWLAPIStreamUtils;

public class PelletVisitor
implements OWLObjectVisitor {
    public static Logger _logger = Log.getLogger(PelletVisitor.class);
    private volatile KnowledgeBase _kb;
    private volatile ATermAppl _term;
    private volatile AtomDObject _swrlDObject;
    private volatile AtomIObject _swrlIObject;
    private volatile RuleAtom _swrlAtom;
    private volatile boolean _addAxioms;
    private volatile boolean _reloadRequired;
    private final Set<OWLAxiom> _unsupportedAxioms = Collections.newSetFromMap(new ConcurrentHashMap());
    private final MultiValueMap<OWLObjectProperty, OWLObjectPropertyAxiom> _compositePropertyAxioms = new MultiValueMap();
    private final Set<OWLObjectProperty> _simpleProperties = Collections.newSetFromMap(new ConcurrentHashMap());

    public PelletVisitor(KnowledgeBase kb) {
        this._kb = kb;
    }

    public void dispose() {
        this._kb = null;
        this.clear();
    }

    public void clear() {
        this._unsupportedAxioms.clear();
        this._compositePropertyAxioms.clear();
        this._simpleProperties.clear();
    }

    private void addUnsupportedAxiom(OWLAxiom axiom) {
        if (!OpenlletOptions.IGNORE_UNSUPPORTED_AXIOMS) {
            throw new UnsupportedFeatureException("Axiom: " + axiom);
        }
        if (this._unsupportedAxioms.add(axiom)) {
            _logger.warning("Ignoring unsupported axiom: " + axiom);
        }
    }

    public Set<OWLAxiom> getUnsupportedAxioms() {
        return Collections.unmodifiableSet(this._unsupportedAxioms);
    }

    private OWLObjectProperty getNamedProperty(OWLObjectPropertyExpression ope) {
        if (ope.isAnonymous()) {
            return this.getNamedProperty(((OWLObjectInverseOf)ope).getInverse());
        }
        return ope.asOWLObjectProperty();
    }

    private void addSimpleProperty(OWLObjectPropertyExpression ope) {
        if (!this._addAxioms) {
            return;
        }
        OWLObjectProperty prop = this.getNamedProperty(ope);
        this._simpleProperties.add(prop);
        prop.accept(this);
        Role role = this._kb.getRBox().getRole(this._term);
        role.setForceSimple(true);
    }

    public void verify() {
        for (Map.Entry entry : this._compositePropertyAxioms.entrySet()) {
            OWLObjectProperty nonSimpleProperty = (OWLObjectProperty)entry.getKey();
            if (!this._simpleProperties.contains(nonSimpleProperty)) continue;
            Set axioms = (Set)entry.getValue();
            for (OWLObjectPropertyAxiom axiom : axioms) {
                this.addUnsupportedAxiom(axiom);
            }
            ATermAppl name = ATermUtils.makeTermAppl(nonSimpleProperty.getIRI().toString());
            Role role = this._kb.getRBox().getRole(name);
            role.removeSubRoleChains();
        }
    }

    public void setAddAxiom(boolean addAxioms) {
        this._addAxioms = addAxioms;
    }

    public boolean isReloadRequired() {
        return this._reloadRequired;
    }

    public ATermAppl result() {
        return this._term;
    }

    public void reset() {
        this._term = null;
        this._reloadRequired = false;
    }

    @Override
    public void visit(OWLClass c) {
        this._term = c.isOWLThing() ? ATermUtils.TOP : (c.isOWLNothing() ? ATermUtils.BOTTOM : ATermUtils.makeTermAppl(c.getIRI().toString()));
        if (this._addAxioms) {
            this._kb.addClass(this._term);
        }
    }

    @Override
    public void visit(OWLAnnotationProperty prop) {
        this._term = ATermUtils.makeTermAppl(prop.getIRI().toString());
        if (this._addAxioms) {
            this._kb.addAnnotationProperty(this._term);
        }
    }

    @Override
    public void visit(OWLAnonymousIndividual ind) {
        this._term = ATermUtils.makeBnode(ind.toStringID());
        if (this._addAxioms) {
            this._kb.addIndividual(this._term);
        }
    }

    @Override
    public void visit(OWLNamedIndividual ind) {
        this._term = ATermUtils.makeTermAppl(ind.getIRI().toString());
        if (this._addAxioms) {
            this._kb.addIndividual(this._term);
        }
    }

    @Override
    public void visit(OWLObjectProperty prop) {
        if (prop.isOWLTopObjectProperty()) {
            this._term = ATermUtils.TOP_OBJECT_PROPERTY;
        } else if (prop.isOWLBottomObjectProperty()) {
            this._term = ATermUtils.BOTTOM_OBJECT_PROPERTY;
        } else {
            this._term = ATermUtils.makeTermAppl(prop.getIRI().toString());
            if (this._addAxioms) {
                this._kb.addObjectProperty(this._term);
            }
        }
    }

    @Override
    public void visit(OWLObjectInverseOf propInv) {
        propInv.getInverse().accept(this);
        ATermAppl p = this._term;
        this._term = ATermUtils.makeInv(p);
    }

    @Override
    public void visit(OWLDataProperty prop) {
        if (prop.isOWLTopDataProperty()) {
            this._term = ATermUtils.TOP_DATA_PROPERTY;
        } else if (prop.isOWLBottomDataProperty()) {
            this._term = ATermUtils.BOTTOM_DATA_PROPERTY;
        } else {
            this._term = ATermUtils.makeTermAppl(prop.getIRI().toString());
            if (this._addAxioms) {
                this._kb.addDatatypeProperty(this._term);
            }
        }
    }

    @Override
    public void visit(OWLLiteral constant) {
        if (constant.isRDFPlainLiteral()) {
            String lexicalValue = constant.getLiteral();
            String lang = constant.getLang();
            this._term = lang != null ? ATermUtils.makePlainLiteral(lexicalValue, lang) : ATermUtils.makePlainLiteral(lexicalValue);
        } else {
            String lexicalValue = constant.getLiteral();
            constant.getDatatype().accept(this);
            String lang = constant.getLang();
            ATermAppl datatype = this._term;
            this._term = lang.isEmpty() ? ATermUtils.makeTypedLiteral(lexicalValue, datatype.toString()) : ATermUtils.makeTypedPlainLangLiteral(lexicalValue, lang);
        }
    }

    @Override
    public void visit(OWLDatatype ocdt) {
        this._term = ATermUtils.makeTermAppl(ocdt.getIRI().toString());
        this._kb.addDatatype(this._term);
    }

    @Override
    public void visit(OWLObjectIntersectionOf and) {
        Set<OWLClassExpression> operands = OWLAPIStreamUtils.asSet(and.operands());
        ATerm[] terms = new ATerm[operands.size()];
        int size = 0;
        for (OWLClassExpression desc : operands) {
            desc.accept(this);
            terms[size++] = this._term;
        }
        ATermList setOfTerms = size > 0 ? ATermUtils.toSet(terms, size) : ATermUtils.EMPTY_LIST;
        this._term = ATermUtils.makeAnd(setOfTerms);
    }

    @Override
    public void visit(OWLObjectUnionOf or) {
        Set<OWLClassExpression> operands = OWLAPIStreamUtils.asSet(or.operands());
        ATerm[] terms = new ATerm[operands.size()];
        int size = 0;
        for (OWLClassExpression desc : operands) {
            desc.accept(this);
            terms[size++] = this._term;
        }
        ATermList setOfTerms = size > 0 ? ATermUtils.toSet(terms, size) : ATermUtils.EMPTY_LIST;
        this._term = ATermUtils.makeOr(setOfTerms);
    }

    @Override
    public void visit(OWLObjectComplementOf not) {
        OWLClassExpression desc = not.getOperand();
        desc.accept(this);
        this._term = ATermUtils.makeNot(this._term);
    }

    @Override
    public void visit(OWLObjectOneOf enumeration) {
        Set<OWLIndividual> operands = OWLAPIStreamUtils.asSet(enumeration.individuals());
        ATerm[] terms = new ATerm[operands.size()];
        int size = 0;
        for (OWLIndividual ind : operands) {
            ind.accept(this);
            terms[size++] = ATermUtils.makeValue(this._term);
        }
        ATermList setOfTerms = size > 0 ? ATermUtils.toSet(terms, size) : ATermUtils.EMPTY_LIST;
        this._term = ATermUtils.makeOr(setOfTerms);
    }

    @Override
    public void visit(OWLObjectSomeValuesFrom restriction) {
        restriction.getProperty().accept(this);
        ATermAppl p = this._term;
        ((OWLClassExpression)restriction.getFiller()).accept(this);
        ATermAppl c = this._term;
        this._term = ATermUtils.makeSomeValues(p, c);
    }

    @Override
    public void visit(OWLObjectAllValuesFrom restriction) {
        restriction.getProperty().accept(this);
        ATermAppl p = this._term;
        ((OWLClassExpression)restriction.getFiller()).accept(this);
        ATermAppl c = this._term;
        this._term = ATermUtils.makeAllValues(p, c);
    }

    @Override
    public void visit(OWLObjectHasValue restriction) {
        restriction.getProperty().accept(this);
        ATermAppl p = this._term;
        ((OWLIndividual)restriction.getFiller()).accept(this);
        ATermAppl ind = this._term;
        this._term = ATermUtils.makeHasValue(p, ind);
    }

    @Override
    public void visit(OWLObjectExactCardinality restriction) {
        this.addSimpleProperty((OWLObjectPropertyExpression)restriction.getProperty());
        restriction.getProperty().accept(this);
        ATermAppl p = this._term;
        int n = restriction.getCardinality();
        ((OWLClassExpression)restriction.getFiller()).accept(this);
        ATermAppl desc = this._term;
        this._term = ATermUtils.makeCard(p, n, desc);
    }

    @Override
    public void visit(OWLObjectMaxCardinality restriction) {
        this.addSimpleProperty((OWLObjectPropertyExpression)restriction.getProperty());
        restriction.getProperty().accept(this);
        ATermAppl p = this._term;
        int n = restriction.getCardinality();
        ((OWLClassExpression)restriction.getFiller()).accept(this);
        ATermAppl desc = this._term;
        this._term = ATermUtils.makeMax((ATerm)p, n, (ATerm)desc);
    }

    @Override
    public void visit(OWLObjectMinCardinality restriction) {
        this.addSimpleProperty((OWLObjectPropertyExpression)restriction.getProperty());
        restriction.getProperty().accept(this);
        ATermAppl p = this._term;
        int n = restriction.getCardinality();
        ((OWLClassExpression)restriction.getFiller()).accept(this);
        ATermAppl desc = this._term;
        this._term = ATermUtils.makeMin((ATerm)p, n, (ATerm)desc);
    }

    @Override
    public void visit(OWLDataExactCardinality restriction) {
        restriction.getProperty().accept(this);
        ATermAppl p = this._term;
        int n = restriction.getCardinality();
        ((OWLDataRange)restriction.getFiller()).accept(this);
        ATermAppl desc = this._term;
        this._term = ATermUtils.makeCard(p, n, desc);
    }

    @Override
    public void visit(OWLDataMaxCardinality restriction) {
        restriction.getProperty().accept(this);
        ATermAppl p = this._term;
        int n = restriction.getCardinality();
        ((OWLDataRange)restriction.getFiller()).accept(this);
        ATermAppl desc = this._term;
        this._term = ATermUtils.makeMax((ATerm)p, n, (ATerm)desc);
    }

    @Override
    public void visit(OWLDataMinCardinality restriction) {
        restriction.getProperty().accept(this);
        ATermAppl p = this._term;
        int n = restriction.getCardinality();
        ((OWLDataRange)restriction.getFiller()).accept(this);
        ATermAppl desc = this._term;
        this._term = ATermUtils.makeMin((ATerm)p, n, (ATerm)desc);
    }

    @Override
    public void visit(OWLEquivalentClassesAxiom axiom) {
        Set<OWLClassExpression> descriptions = OWLAPIStreamUtils.asSet(axiom.classExpressions());
        int size = descriptions.size();
        if (size > 1) {
            ATermAppl[] terms = new ATermAppl[size];
            int index = 0;
            for (OWLClassExpression desc : descriptions) {
                desc.accept(this);
                terms[index++] = this._term;
            }
            Arrays.sort(terms, 0, size, Comparators.termComparator);
            ATermAppl c1 = terms[0];
            for (int i = 1; i < terms.length; ++i) {
                ATermAppl c2 = terms[i];
                if (this._addAxioms) {
                    this._kb.addEquivalentClass(c1, c2);
                    continue;
                }
                ATermAppl sameAxiom = ATermUtils.makeEqClasses(c1, c2);
                boolean bl = this._reloadRequired = !this._kb.removeAxiom(sameAxiom);
                if (!this._reloadRequired) continue;
                return;
            }
        }
    }

    @Override
    public void visit(OWLDisjointClassesAxiom axiom) {
        Set<OWLClassExpression> descriptions = OWLAPIStreamUtils.asSet(axiom.classExpressions());
        int size = descriptions.size();
        if (size > 1) {
            ATerm[] terms = new ATermAppl[size];
            int index = 0;
            for (OWLClassExpression desc : descriptions) {
                desc.accept(this);
                terms[index++] = this._term;
            }
            ATermList list = ATermUtils.toSet(terms, size);
            if (this._addAxioms) {
                this._kb.addDisjointClasses(list);
            } else {
                this._reloadRequired = !this._kb.removeAxiom(ATermUtils.makeDisjoints(list));
            }
        }
    }

    @Override
    public void visit(OWLSubClassOfAxiom axiom) {
        axiom.getSubClass().accept(this);
        ATermAppl c1 = this._term;
        axiom.getSuperClass().accept(this);
        ATermAppl c2 = this._term;
        if (this._addAxioms) {
            this._kb.addSubClass(c1, c2);
        } else {
            ATermAppl subAxiom = ATermUtils.makeSub(c1, c2);
            this._reloadRequired = !this._kb.removeAxiom(subAxiom);
        }
    }

    @Override
    public void visit(OWLEquivalentObjectPropertiesAxiom axiom) {
        if (!this._addAxioms) {
            this._reloadRequired = true;
            return;
        }
        OWLObjectPropertyExpression[] props = (OWLObjectPropertyExpression[])axiom.properties().toArray(OWLObjectPropertyExpression[]::new);
        for (int i = 0; i < props.length; ++i) {
            for (int j = i + 1; j < props.length; ++j) {
                props[i].accept(this);
                ATermAppl p1 = this._term;
                props[j].accept(this);
                ATermAppl p2 = this._term;
                this._kb.addEquivalentProperty(p1, p2);
            }
        }
    }

    @Override
    public void visit(OWLEquivalentDataPropertiesAxiom axiom) {
        if (!this._addAxioms) {
            this._reloadRequired = true;
            return;
        }
        OWLDataPropertyExpression[] props = (OWLDataPropertyExpression[])axiom.properties().toArray(OWLDataPropertyExpression[]::new);
        for (int i = 0; i < props.length; ++i) {
            for (int j = i + 1; j < props.length; ++j) {
                props[i].accept(this);
                ATermAppl p1 = this._term;
                props[j].accept(this);
                ATermAppl p2 = this._term;
                this._kb.addEquivalentProperty(p1, p2);
            }
        }
    }

    @Override
    public void visit(OWLDifferentIndividualsAxiom axiom) {
        if (!this._addAxioms) {
            this._reloadRequired = true;
            return;
        }
        List<OWLIndividual> inds = axiom.getIndividualsAsList();
        if (inds.size() == 2) {
            Iterator<OWLIndividual> iter = inds.iterator();
            iter.next().accept(this);
            ATermAppl i1 = this._term;
            iter.next().accept(this);
            ATermAppl i2 = this._term;
            this._kb.addDifferent(i1, i2);
        } else {
            ATerm[] terms = new ATermAppl[inds.size()];
            int i = 0;
            for (OWLIndividual ind : inds) {
                ind.accept(this);
                terms[i++] = this._term;
            }
            this._kb.addAllDifferent(ATermUtils.makeList(terms));
        }
    }

    @Override
    public void visit(OWLSameIndividualAxiom axiom) {
        if (!this._addAxioms) {
            this._reloadRequired = true;
            return;
        }
        Iterator<OWLIndividual> eqs = axiom.getIndividualsAsList().iterator();
        if (eqs.hasNext()) {
            eqs.next().accept(this);
            ATermAppl i1 = this._term;
            while (eqs.hasNext()) {
                eqs.next().accept(this);
                ATermAppl i2 = this._term;
                this._kb.addSame(i1, i2);
            }
        }
    }

    @Override
    public void visit(OWLHasKeyAxiom axiom) {
        if (!this._addAxioms) {
            this._reloadRequired = true;
            return;
        }
        axiom.getClassExpression().accept(this);
        ATermAppl c = this._term;
        HashSet<ATermAppl> properties = new HashSet<ATermAppl>();
        axiom.propertyExpressions().forEach(pe -> {
            pe.accept(this);
            properties.add(this._term);
        });
        this._kb.addKey(c, properties);
    }

    @Override
    public void visit(OWLDataOneOf enumeration) {
        ATermList ops = ATermUtils.EMPTY_LIST;
        for (OWLLiteral value : OWLAPIStreamUtils.asList(enumeration.values())) {
            value.accept(this);
            ops = ops.insert(ATermUtils.makeValue(this.result()));
        }
        this._term = ATermUtils.makeOr(ops);
    }

    @Override
    public void visit(OWLDataAllValuesFrom restriction) {
        restriction.getProperty().accept(this);
        ATermAppl p = this._term;
        ((OWLDataRange)restriction.getFiller()).accept(this);
        ATermAppl c = this._term;
        this._term = ATermUtils.makeAllValues(p, c);
    }

    @Override
    public void visit(OWLDataSomeValuesFrom restriction) {
        restriction.getProperty().accept(this);
        ATermAppl p = this._term;
        ((OWLDataRange)restriction.getFiller()).accept(this);
        ATermAppl c = this._term;
        this._term = ATermUtils.makeSomeValues(p, c);
    }

    @Override
    public void visit(OWLDataHasValue restriction) {
        restriction.getProperty().accept(this);
        ATermAppl p = this._term;
        ((OWLLiteral)restriction.getFiller()).accept(this);
        ATermAppl dv = this._term;
        this._term = ATermUtils.makeHasValue(p, dv);
    }

    @Override
    public void visit(OWLOntology ont) {
        ont.signature().forEach(entity -> entity.accept(this));
        ont.axioms().forEach(axiom -> {
            _logger.fine(() -> "Load " + axiom);
            axiom.accept(this);
        });
    }

    @Override
    public void visit(OWLObjectHasSelf restriction) {
        this.addSimpleProperty(restriction.getProperty());
        restriction.getProperty().accept(this);
        ATermAppl p = this._term;
        this._term = ATermUtils.makeSelf(p);
    }

    @Override
    public void visit(OWLDisjointObjectPropertiesAxiom axiom) {
        if (!this._addAxioms) {
            this._reloadRequired = true;
            return;
        }
        OWLObjectPropertyExpression[] disjs = (OWLObjectPropertyExpression[])axiom.properties().toArray(OWLObjectPropertyExpression[]::new);
        for (int i = 0; i < disjs.length - 1; ++i) {
            OWLObjectPropertyExpression prop1 = disjs[i];
            this.addSimpleProperty(prop1);
            for (int j = i + 1; j < disjs.length; ++j) {
                OWLObjectPropertyExpression prop2 = disjs[j];
                this.addSimpleProperty(prop2);
                prop1.accept(this);
                ATermAppl p1 = this._term;
                prop2.accept(this);
                ATermAppl p2 = this._term;
                this._kb.addDisjointProperty(p1, p2);
            }
        }
    }

    @Override
    public void visit(OWLDisjointDataPropertiesAxiom axiom) {
        if (!this._addAxioms) {
            this._reloadRequired = true;
            return;
        }
        OWLDataPropertyExpression[] disjs = (OWLDataPropertyExpression[])axiom.properties().toArray(OWLDataPropertyExpression[]::new);
        for (int i = 0; i < disjs.length; ++i) {
            OWLDataProperty desc1 = (OWLDataProperty)disjs[i];
            desc1.accept(this);
            ATermAppl p1 = this._term;
            for (int j = i + 1; j < disjs.length; ++j) {
                OWLDataProperty desc2 = (OWLDataProperty)disjs[j];
                desc2.accept(this);
                ATermAppl p2 = this._term;
                this._kb.addDisjointProperty(p1, p2);
            }
        }
    }

    @Override
    public void visit(OWLSubPropertyChainOfAxiom axiom) {
        if (!this._addAxioms) {
            this._reloadRequired = true;
            return;
        }
        this._compositePropertyAxioms.add(this.getNamedProperty(axiom.getSuperProperty()), axiom);
        axiom.getSuperProperty().accept(this);
        ATermAppl prop = this.result();
        List<OWLObjectPropertyExpression> propChain = axiom.getPropertyChain();
        ATermList chain = ATermUtils.EMPTY_LIST;
        for (int i = propChain.size() - 1; i >= 0; --i) {
            propChain.get(i).accept(this);
            chain = chain.insert(this.result());
        }
        this._kb.addSubProperty(chain, prop);
    }

    @Override
    public void visit(OWLDisjointUnionAxiom axiom) {
        if (!this._addAxioms) {
            this._reloadRequired = true;
            return;
        }
        axiom.getOWLClass().accept(this);
        ATermAppl c = this._term;
        ATermList classes = ATermUtils.EMPTY_LIST;
        for (OWLClassExpression desc : OWLAPIStreamUtils.asList(axiom.classExpressions())) {
            desc.accept(this);
            classes = classes.insert(this.result());
        }
        this._kb.addDisjointClasses(classes);
        this._kb.addEquivalentClass(c, ATermUtils.makeOr(classes));
    }

    @Override
    public void visit(OWLDataComplementOf node) {
        node.getDataRange().accept(this);
        this._term = ATermUtils.makeNot(this._term);
    }

    @Override
    public void visit(OWLDataIntersectionOf and) {
        Set<OWLDataRange> operands = OWLAPIStreamUtils.asSet(and.operands());
        ATerm[] terms = new ATerm[operands.size()];
        int size = 0;
        for (OWLDataRange desc : operands) {
            desc.accept(this);
            terms[size++] = this._term;
        }
        ATermList setOfTerms = size > 0 ? ATermUtils.toSet(terms, size) : ATermUtils.EMPTY_LIST;
        this._term = ATermUtils.makeAnd(setOfTerms);
    }

    @Override
    public void visit(OWLDatatypeRestriction node) {
        node.getDatatype().accept(this);
        ATermAppl baseDatatype = this._term;
        ArrayList<ATermAppl> restrictions = new ArrayList<ATermAppl>();
        for (OWLFacetRestriction restr : OWLAPIStreamUtils.asList(node.facetRestrictions())) {
            restr.accept(this);
            if (this._term != null) {
                restrictions.add(this._term);
                continue;
            }
            _logger.warning("Unrecognized facet " + restr.getFacet());
            return;
        }
        if (restrictions.isEmpty()) {
            _logger.warning("A data range is defined without facet restrictions " + node);
        } else {
            this._term = ATermUtils.makeRestrictedDatatype(baseDatatype, restrictions.toArray(new ATermAppl[restrictions.size()]));
        }
    }

    @Override
    public void visit(OWLDataUnionOf or) {
        Set<OWLDataRange> operands = OWLAPIStreamUtils.asSet(or.operands());
        ATerm[] terms = new ATerm[operands.size()];
        int size = 0;
        for (OWLDataRange desc : operands) {
            desc.accept(this);
            terms[size++] = this._term;
        }
        ATermList setOfTerms = size > 0 ? ATermUtils.toSet(terms, size) : ATermUtils.EMPTY_LIST;
        this._term = ATermUtils.makeOr(setOfTerms);
    }

    @Override
    public void visit(OWLAsymmetricObjectPropertyAxiom axiom) {
        if (!this._addAxioms) {
            this._reloadRequired = true;
            return;
        }
        this.addSimpleProperty((OWLObjectPropertyExpression)axiom.getProperty());
        ((OWLObjectPropertyExpression)axiom.getProperty()).accept(this);
        ATermAppl p = this._term;
        this._kb.addAsymmetricProperty(p);
    }

    @Override
    public void visit(OWLReflexiveObjectPropertyAxiom axiom) {
        if (!this._addAxioms) {
            this._reloadRequired = true;
            return;
        }
        ((OWLObjectPropertyExpression)axiom.getProperty()).accept(this);
        ATermAppl p = this._term;
        this._kb.addReflexiveProperty(p);
    }

    @Override
    public void visit(OWLFunctionalObjectPropertyAxiom axiom) {
        if (!this._addAxioms) {
            this._reloadRequired = true;
            return;
        }
        this.addSimpleProperty((OWLObjectPropertyExpression)axiom.getProperty());
        ((OWLObjectPropertyExpression)axiom.getProperty()).accept(this);
        ATermAppl p = this._term;
        this._kb.addFunctionalProperty(p);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void visit(OWLNegativeObjectPropertyAssertionAxiom axiom) {
        ATermAppl o;
        ATermAppl p;
        ATermAppl s;
        if (!this._addAxioms) {
            this._reloadRequired = true;
            return;
        }
        PelletVisitor pelletVisitor = this;
        synchronized (pelletVisitor) {
            axiom.getSubject().accept(this);
            s = this._term;
            ((OWLObjectPropertyExpression)axiom.getProperty()).accept(this);
            p = this._term;
            ((OWLIndividual)axiom.getObject()).accept(this);
            o = this._term;
        }
        this._kb.addNegatedPropertyValue(p, s, o);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void visit(OWLDataPropertyDomainAxiom axiom) {
        ATermAppl c;
        ATermAppl p;
        PelletVisitor pelletVisitor = this;
        synchronized (pelletVisitor) {
            ((OWLDataPropertyExpression)axiom.getProperty()).accept(this);
            p = this._term;
            ((OWLClassExpression)axiom.getDomain()).accept(this);
            c = this._term;
        }
        if (this._addAxioms) {
            this._kb.addDomain(p, c);
        } else {
            this._reloadRequired = !this._kb.removeDomain(p, c);
        }
    }

    @Override
    public void visit(OWLObjectPropertyDomainAxiom axiom) {
        ((OWLObjectPropertyExpression)axiom.getProperty()).accept(this);
        ATermAppl p = this._term;
        ((OWLClassExpression)axiom.getDomain()).accept(this);
        ATermAppl c = this._term;
        if (this._addAxioms) {
            this._kb.addDomain(p, c);
        } else {
            this._reloadRequired = !this._kb.removeDomain(p, c);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void visit(OWLNegativeDataPropertyAssertionAxiom axiom) {
        ATermAppl o;
        ATermAppl p;
        ATermAppl s;
        if (!this._addAxioms) {
            this._reloadRequired = true;
            return;
        }
        PelletVisitor pelletVisitor = this;
        synchronized (pelletVisitor) {
            axiom.getSubject().accept(this);
            s = this._term;
            ((OWLDataPropertyExpression)axiom.getProperty()).accept(this);
            p = this._term;
            ((OWLLiteral)axiom.getObject()).accept(this);
            o = this._term;
        }
        this._kb.addNegatedPropertyValue(p, s, o);
    }

    @Override
    public void visit(OWLObjectPropertyRangeAxiom axiom) {
        ((OWLObjectPropertyExpression)axiom.getProperty()).accept(this);
        ATermAppl p = this._term;
        ((OWLClassExpression)axiom.getRange()).accept(this);
        ATermAppl c = this._term;
        if (this._addAxioms) {
            this._kb.addRange(p, c);
        } else {
            this._reloadRequired = !this._kb.removeRange(p, c);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void visit(OWLObjectPropertyAssertionAxiom axiom) {
        ATermAppl obj;
        ATermAppl pred;
        ATermAppl subj;
        PelletVisitor pelletVisitor = this;
        synchronized (pelletVisitor) {
            axiom.getSubject().accept(this);
            subj = this._term;
            ((OWLObjectPropertyExpression)axiom.getProperty()).accept(this);
            pred = this._term;
            ((OWLIndividual)axiom.getObject()).accept(this);
            obj = this._term;
        }
        if (this._addAxioms) {
            this._kb.addPropertyValue(pred, subj, obj);
        } else {
            this._kb.removePropertyValue(pred, subj, obj);
        }
    }

    @Override
    public void visit(OWLSubObjectPropertyOfAxiom axiom) {
        if (!this._addAxioms) {
            this._reloadRequired = true;
            return;
        }
        ((OWLObjectPropertyExpression)axiom.getSubProperty()).accept(this);
        ATermAppl sub = this._term;
        ((OWLObjectPropertyExpression)axiom.getSuperProperty()).accept(this);
        ATermAppl sup = this._term;
        this._kb.addSubProperty(sub, sup);
    }

    @Override
    public void visit(OWLDatatypeDefinitionAxiom axiom) {
        if (!this._addAxioms) {
            this._reloadRequired = true;
            return;
        }
        axiom.getDatatype().accept(this);
        ATermAppl datatype = this._term;
        axiom.getDataRange().accept(this);
        ATermAppl datarange = this._term;
        this._kb.addDatatypeDefinition(datatype, datarange);
    }

    @Override
    public void visit(OWLDeclarationAxiom axiom) {
        axiom.getEntity().accept(this);
    }

    @Override
    public void visit(OWLSymmetricObjectPropertyAxiom axiom) {
        if (!this._addAxioms) {
            this._reloadRequired = true;
            return;
        }
        ((OWLObjectPropertyExpression)axiom.getProperty()).accept(this);
        ATermAppl p = this._term;
        this._kb.addSymmetricProperty(p);
    }

    @Override
    public void visit(OWLDataPropertyRangeAxiom axiom) {
        ((OWLDataPropertyExpression)axiom.getProperty()).accept(this);
        ATermAppl p = this._term;
        ((OWLDataRange)axiom.getRange()).accept(this);
        ATermAppl c = this._term;
        if (this._addAxioms) {
            this._kb.addRange(p, c);
        } else {
            this._reloadRequired = !this._kb.removeRange(p, c);
        }
    }

    @Override
    public void visit(OWLFunctionalDataPropertyAxiom axiom) {
        if (!this._addAxioms) {
            this._reloadRequired = true;
            return;
        }
        ((OWLDataPropertyExpression)axiom.getProperty()).accept(this);
        ATermAppl p = this._term;
        this._kb.addFunctionalProperty(p);
    }

    @Override
    public void visit(OWLClassAssertionAxiom axiom) {
        axiom.getClassExpression().accept(this);
        ATermAppl c = this._term;
        if (AnnotationClasses.contains(c)) {
            return;
        }
        axiom.getIndividual().accept(this);
        ATermAppl ind = this._term;
        if (this._addAxioms) {
            this._kb.addType(ind, c);
        } else {
            this._kb.removeType(ind, c);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void visit(OWLDataPropertyAssertionAxiom axiom) {
        ATermAppl obj;
        ATermAppl pred;
        ATermAppl subj;
        PelletVisitor pelletVisitor = this;
        synchronized (pelletVisitor) {
            axiom.getSubject().accept(this);
            subj = this._term;
            ((OWLDataPropertyExpression)axiom.getProperty()).accept(this);
            pred = this._term;
            ((OWLLiteral)axiom.getObject()).accept(this);
            obj = this._term;
        }
        if (this._addAxioms) {
            this._kb.addPropertyValue(pred, subj, obj);
        } else {
            this._kb.removePropertyValue(pred, subj, obj);
        }
    }

    @Override
    public void visit(OWLTransitiveObjectPropertyAxiom axiom) {
        if (!this._addAxioms) {
            this._reloadRequired = true;
            return;
        }
        this._compositePropertyAxioms.add(this.getNamedProperty((OWLObjectPropertyExpression)axiom.getProperty()), axiom);
        ((OWLObjectPropertyExpression)axiom.getProperty()).accept(this);
        ATermAppl p = this._term;
        this._kb.addTransitiveProperty(p);
    }

    @Override
    public void visit(OWLIrreflexiveObjectPropertyAxiom axiom) {
        if (!this._addAxioms) {
            this._reloadRequired = true;
            return;
        }
        this.addSimpleProperty((OWLObjectPropertyExpression)axiom.getProperty());
        ((OWLObjectPropertyExpression)axiom.getProperty()).accept(this);
        ATermAppl p = this._term;
        this._kb.addIrreflexiveProperty(p);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void visit(OWLSubDataPropertyOfAxiom axiom) {
        ATermAppl p2;
        ATermAppl p1;
        if (!this._addAxioms) {
            this._reloadRequired = true;
            return;
        }
        PelletVisitor pelletVisitor = this;
        synchronized (pelletVisitor) {
            ((OWLDataPropertyExpression)axiom.getSubProperty()).accept(this);
            p1 = this._term;
            ((OWLDataPropertyExpression)axiom.getSuperProperty()).accept(this);
            p2 = this._term;
        }
        this._kb.addSubProperty(p1, p2);
    }

    @Override
    public void visit(OWLInverseFunctionalObjectPropertyAxiom axiom) {
        if (!this._addAxioms) {
            this._reloadRequired = true;
            return;
        }
        this.addSimpleProperty((OWLObjectPropertyExpression)axiom.getProperty());
        ((OWLObjectPropertyExpression)axiom.getProperty()).accept(this);
        ATermAppl p = this._term;
        this._kb.addInverseFunctionalProperty(p);
    }

    @Override
    public void visit(OWLInverseObjectPropertiesAxiom axiom) {
        if (!this._addAxioms) {
            this._reloadRequired = true;
            return;
        }
        axiom.getFirstProperty().accept(this);
        ATermAppl p1 = this._term;
        axiom.getSecondProperty().accept(this);
        ATermAppl p2 = this._term;
        this._kb.addInverseProperty(p1, p2);
    }

    @Override
    public void visit(OWLFacetRestriction node) {
        Facet facet = Facet.Registry.get(ATermUtils.makeTermAppl(node.getFacet().getIRI().toString()));
        if (facet != null) {
            OWLLiteral facetValue = node.getFacetValue();
            facetValue.accept(this);
            this._term = ATermUtils.makeFacetRestriction(facet.getName(), this._term);
        }
    }

    @Override
    public void visit(SWRLRule rule) {
        if (!OpenlletOptions.DL_SAFE_RULES) {
            return;
        }
        if (!this._addAxioms) {
            this._reloadRequired = true;
            return;
        }
        List<RuleAtom> head = this.parseAtomList(OWLAPIStreamUtils.asList(rule.head()));
        List<RuleAtom> body = this.parseAtomList(OWLAPIStreamUtils.asList(rule.body()));
        if (head == null || body == null) {
            this.addUnsupportedAxiom(rule);
            return;
        }
        Rule pelletRule = new Rule(head, body);
        this._kb.addRule(pelletRule);
    }

    @Override
    public void visit(OWLAnnotation a) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void visit(IRI annotationValue) {
        this._term = ATermUtils.makeTermAppl(annotationValue.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void visit(OWLAnnotationAssertionAxiom axiom) {
        if (!this._addAxioms) {
            this._reloadRequired = OpenlletOptions.USE_ANNOTATION_SUPPORT;
            return;
        }
        if (OpenlletOptions.USE_ANNOTATION_SUPPORT) {
            ATermAppl o;
            ATermAppl p;
            ATermAppl s;
            PelletVisitor pelletVisitor = this;
            synchronized (pelletVisitor) {
                ((OWLAnnotationSubject)axiom.getSubject()).accept(this);
                s = this._term;
                ((OWLAnnotationProperty)axiom.getProperty()).accept(this);
                p = this._term;
                axiom.getValue().accept(this);
                o = this._term;
            }
            this._kb.addAnnotation(s, p, o);
        }
    }

    @Override
    public void visit(OWLAnnotationPropertyDomainAxiom axiom) {
    }

    @Override
    public void visit(OWLAnnotationPropertyRangeAxiom axiom) {
    }

    @Override
    public void visit(OWLSubAnnotationPropertyOfAxiom axiom) {
        if (!this._addAxioms) {
            this._reloadRequired = true;
            return;
        }
        axiom.getSubProperty().accept(this);
        ATermAppl sub = this._term;
        axiom.getSuperProperty().accept(this);
        ATermAppl sup = this._term;
        this._kb.addSubProperty(sub, sup);
    }

    private List<RuleAtom> parseAtomList(Collection<SWRLAtom> atomList) {
        ArrayList<RuleAtom> atoms = new ArrayList<RuleAtom>();
        for (SWRLAtom atom : atomList) {
            atom.accept(this);
            if (this._swrlAtom == null) {
                return null;
            }
            atoms.add(this._swrlAtom);
        }
        return atoms;
    }

    @Override
    public void visit(SWRLClassAtom atom) {
        OWLClassExpression c = atom.getPredicate();
        SWRLIArgument v = (SWRLIArgument)atom.getArgument();
        v.accept(this);
        AtomIObject subj = this._swrlIObject;
        c.accept(this);
        this._swrlAtom = new ClassAtom(this._term, subj);
    }

    @Override
    public void visit(SWRLDataRangeAtom atom) {
        atom.getPredicate().accept(this);
        ((SWRLDArgument)atom.getArgument()).accept(this);
        this._swrlAtom = new DataRangeAtom(this._term, this._swrlDObject);
    }

    @Override
    public void visit(SWRLObjectPropertyAtom atom) {
        if (atom.getPredicate().isAnonymous()) {
            this._swrlAtom = null;
            return;
        }
        ((SWRLIArgument)atom.getFirstArgument()).accept(this);
        AtomIObject subj = this._swrlIObject;
        ((SWRLIArgument)atom.getSecondArgument()).accept(this);
        AtomIObject obj = this._swrlIObject;
        atom.getPredicate().accept(this);
        this._swrlAtom = new IndividualPropertyAtom(this._term, subj, obj);
    }

    @Override
    public void visit(SWRLDataPropertyAtom atom) {
        if (atom.getPredicate().isAnonymous()) {
            this._swrlAtom = null;
            return;
        }
        ((SWRLIArgument)atom.getFirstArgument()).accept(this);
        AtomIObject subj = this._swrlIObject;
        ((SWRLDArgument)atom.getSecondArgument()).accept(this);
        AtomDObject obj = this._swrlDObject;
        atom.getPredicate().accept(this);
        this._swrlAtom = new DatavaluedPropertyAtom(this._term, subj, obj);
    }

    @Override
    public void visit(SWRLSameIndividualAtom atom) {
        ((SWRLIArgument)atom.getFirstArgument()).accept(this);
        AtomIObject subj = this._swrlIObject;
        ((SWRLIArgument)atom.getSecondArgument()).accept(this);
        AtomIObject obj = this._swrlIObject;
        this._swrlAtom = new SameIndividualAtom(subj, obj);
    }

    @Override
    public void visit(SWRLDifferentIndividualsAtom atom) {
        ((SWRLIArgument)atom.getFirstArgument()).accept(this);
        AtomIObject subj = this._swrlIObject;
        ((SWRLIArgument)atom.getSecondArgument()).accept(this);
        AtomIObject obj = this._swrlIObject;
        this._swrlAtom = new DifferentIndividualsAtom(subj, obj);
    }

    @Override
    public void visit(SWRLBuiltInAtom atom) {
        ArrayList<AtomDObject> arguments = new ArrayList<AtomDObject>((int)atom.allArguments().count());
        for (SWRLDArgument swrlArg : atom.getArguments()) {
            swrlArg.accept(this);
            arguments.add(this._swrlDObject);
        }
        this._swrlAtom = new BuiltInAtom(atom.getPredicate().toString(), arguments);
    }

    @Override
    public void visit(SWRLVariable var) {
        this._swrlDObject = new AtomDVariable(var.getIRI().toString());
        this._swrlIObject = new AtomIVariable(var.getIRI().toString());
    }

    @Override
    public void visit(SWRLIndividualArgument iobj) {
        iobj.getIndividual().accept(this);
        this._swrlIObject = new AtomIConstant(this._term);
    }

    @Override
    public void visit(SWRLLiteralArgument cons) {
        cons.getLiteral().accept(this);
        this._swrlDObject = new AtomDConstant(this._term);
    }
}

