/*
 * Decompiled with CFR 0.152.
 */
package openllet.query.sparqldl.engine;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import openllet.aterm.ATermAppl;
import openllet.core.DependencySet;
import openllet.core.KnowledgeBase;
import openllet.core.OpenlletOptions;
import openllet.core.boxes.abox.ABox;
import openllet.core.boxes.rbox.Role;
import openllet.core.datatypes.DatatypeReasoner;
import openllet.core.datatypes.exceptions.DatatypeReasonerException;
import openllet.core.exceptions.InternalReasonerException;
import openllet.core.utils.ATermUtils;
import openllet.core.utils.Bool;
import openllet.core.utils.DisjointSet;
import openllet.core.utils.SetUtils;
import openllet.core.utils.TermFactory;
import openllet.query.sparqldl.engine.CombinedQueryEngine;
import openllet.query.sparqldl.engine.CoreStrategy;
import openllet.query.sparqldl.engine.QueryExec;
import openllet.query.sparqldl.model.MultiQueryResults;
import openllet.query.sparqldl.model.NotKnownQueryAtom;
import openllet.query.sparqldl.model.Query;
import openllet.query.sparqldl.model.QueryAtom;
import openllet.query.sparqldl.model.QueryAtomFactory;
import openllet.query.sparqldl.model.QueryImpl;
import openllet.query.sparqldl.model.QueryPredicate;
import openllet.query.sparqldl.model.QueryResult;
import openllet.query.sparqldl.model.QueryResultImpl;
import openllet.query.sparqldl.model.ResultBindingImpl;
import openllet.query.sparqldl.model.UnionQueryAtom;
import openllet.shared.tools.Log;

public class QueryEngine {
    public static Logger _logger = Log.getLogger(QueryEngine.class);
    public static CoreStrategy STRATEGY = CoreStrategy.ALLFAST;

    public static QueryExec getQueryExec() {
        return new CombinedQueryEngine();
    }

    public static boolean supports(Query query, KnowledgeBase kb) {
        return QueryEngine.getQueryExec().supports(query);
    }

    public static QueryResult exec(Query query, KnowledgeBase kb) {
        KnowledgeBase queryKB = query.getKB();
        query.setKB(kb);
        QueryResult result = QueryEngine.exec(query);
        query.setKB(queryKB);
        return result;
    }

    public static QueryResult exec(Query query) {
        if (query.getAtoms().isEmpty()) {
            QueryResultImpl results = new QueryResultImpl(query);
            results.add(new ResultBindingImpl());
            return results;
        }
        query.getKB().ensureConsistency();
        _logger.fine(() -> "Preprocessing:\n" + query);
        Query preprocessed = QueryEngine.preprocess(query);
        if (OpenlletOptions.SIMPLIFY_QUERY) {
            _logger.fine(() -> "Simplifying:\n" + preprocessed);
            QueryEngine.simplify(preprocessed);
        }
        _logger.fine(() -> "Splitting:\n" + preprocessed);
        List<Query> queries = QueryEngine.split(preprocessed);
        QueryResult r = null;
        if (queries.isEmpty()) {
            throw new InternalReasonerException("Splitting query returned no results!");
        }
        if (queries.size() == 1) {
            r = QueryEngine.execSingleQuery(queries.get(0));
        } else {
            ArrayList<QueryResult> results = new ArrayList<QueryResult>(queries.size());
            for (Query q : queries) {
                results.add(QueryEngine.execSingleQuery(q));
            }
            r = new MultiQueryResults(query.getResultVars(), results);
        }
        return r;
    }

    private static boolean isObjectProperty(ATermAppl t, KnowledgeBase kb) {
        if (!ATermUtils.isVar(t) && !kb.isObjectProperty(t)) {
            _logger.warning("Undefined object property used in query: " + t);
            return false;
        }
        return true;
    }

    private static boolean isDatatypeProperty(ATermAppl t, KnowledgeBase kb) {
        if (!ATermUtils.isVar(t) && !kb.isDatatypeProperty(t)) {
            _logger.warning("Undefined datatype property used in query: " + t);
            return false;
        }
        return true;
    }

    private static boolean isAnnotationProperty(ATermAppl t, KnowledgeBase kb) {
        if (!ATermUtils.isVar(t) && !kb.isAnnotationProperty(t)) {
            _logger.warning("Undefined annotation property used in query: " + t);
            return false;
        }
        return true;
    }

    private static boolean isProperty(ATermAppl t, KnowledgeBase kb) {
        if (!(ATermUtils.isVar(t) || kb.isObjectProperty(t) || kb.isDatatypeProperty(t) || kb.isAnnotationProperty(t))) {
            _logger.warning("Not an object/data/annotation property: " + t);
            return false;
        }
        return true;
    }

    private static boolean isIndividual(ATermAppl t, KnowledgeBase kb) {
        if (!ATermUtils.isVar(t) && !kb.isIndividual(t)) {
            _logger.warning("Undefined _individual used in query: " + t);
            return false;
        }
        return true;
    }

    private static boolean isClass(ATermAppl t, KnowledgeBase kb) {
        if (!ATermUtils.isVar(t) && !kb.isClass(t)) {
            _logger.warning("Undefined class used in query: " + t);
            return false;
        }
        return true;
    }

    private static boolean isDatatype(ATermAppl t, KnowledgeBase kb) {
        if (!ATermUtils.isVar(t) && !kb.isDatatype(t)) {
            _logger.warning("Undefined datatype used in query: " + t);
            return false;
        }
        return true;
    }

    private static boolean hasDefinedTerms(QueryAtom atom, KnowledgeBase kb) {
        List<ATermAppl> args = atom.getArguments();
        switch (atom.getPredicate()) {
            case Type: 
            case DirectType: {
                return QueryEngine.isIndividual(args.get(0), kb) && QueryEngine.isClass(args.get(1), kb);
            }
            case PropertyValue: 
            case NegativePropertyValue: {
                ATermAppl s = args.get(0);
                ATermAppl p = args.get(1);
                ATermAppl o = args.get(2);
                return QueryEngine.isIndividual(s, kb) && (ATermUtils.isVar(o) ? QueryEngine.isProperty(p, kb) : (ATermUtils.isLiteral(o) ? QueryEngine.isDatatypeProperty(p, kb) : QueryEngine.isObjectProperty(p, kb) && QueryEngine.isIndividual(o, kb)));
            }
            case SameAs: 
            case DifferentFrom: {
                return QueryEngine.isIndividual(args.get(0), kb) && QueryEngine.isIndividual(args.get(1), kb);
            }
            case DatatypeProperty: {
                return QueryEngine.isDatatypeProperty(args.get(0), kb);
            }
            case ObjectProperty: 
            case Transitive: 
            case InverseFunctional: 
            case Symmetric: 
            case Asymmetric: 
            case Reflexive: 
            case Irreflexive: {
                return QueryEngine.isObjectProperty(args.get(0), kb);
            }
            case Functional: {
                return QueryEngine.isProperty(args.get(0), kb);
            }
            case InverseOf: {
                return QueryEngine.isObjectProperty(args.get(0), kb) && QueryEngine.isObjectProperty(args.get(1), kb);
            }
            case Domain: {
                return QueryEngine.isProperty(args.get(0), kb) && QueryEngine.isClass(args.get(1), kb);
            }
            case Range: {
                return QueryEngine.isObjectProperty(args.get(0), kb) && QueryEngine.isClass(args.get(1), kb) || QueryEngine.isDatatypeProperty(args.get(0), kb) && QueryEngine.isDatatype(args.get(1), kb);
            }
            case SubPropertyOf: 
            case EquivalentProperty: 
            case StrictSubPropertyOf: 
            case DirectSubPropertyOf: 
            case propertyDisjointWith: {
                return QueryEngine.isProperty(args.get(0), kb) && QueryEngine.isProperty(args.get(1), kb);
            }
            case SubClassOf: 
            case EquivalentClass: 
            case DisjointWith: 
            case ComplementOf: 
            case StrictSubClassOf: 
            case DirectSubClassOf: {
                return QueryEngine.isClass(args.get(0), kb) && QueryEngine.isClass(args.get(1), kb);
            }
            case NotKnown: {
                return !QueryEngine.hasUndefinedTerm(((NotKnownQueryAtom)atom).getAtoms(), kb);
            }
            case Union: {
                for (List<QueryAtom> atoms : ((UnionQueryAtom)atom).getUnion()) {
                    if (!QueryEngine.hasUndefinedTerm(atoms, kb)) continue;
                    return false;
                }
                return true;
            }
            case Datatype: {
                return kb.isDatatype(args.get(1));
            }
            case Annotation: {
                return QueryEngine.isAnnotationProperty(args.get(1), kb);
            }
        }
        throw new AssertionError();
    }

    private static boolean hasUndefinedTerm(List<QueryAtom> atoms, KnowledgeBase kb) {
        for (QueryAtom atom : atoms) {
            if (QueryEngine.hasDefinedTerms(atom, kb)) continue;
            return true;
        }
        return false;
    }

    private static boolean hasUndefinedTerm(Query query) {
        return QueryEngine.hasUndefinedTerm(query.getAtoms(), query.getKB());
    }

    private static QueryResult execSingleQuery(Query query) {
        if (QueryEngine.hasUndefinedTerm(query)) {
            return new QueryResultImpl(query);
        }
        return QueryEngine.getQueryExec().exec(query);
    }

    public static List<Query> split(Query query) {
        try {
            HashSet<ATermAppl> resultVars = new HashSet<ATermAppl>(query.getResultVars());
            DisjointSet<ATermAppl> disjointSet = new DisjointSet<ATermAppl>();
            for (QueryAtom atom : query.getAtoms()) {
                ATermAppl toMerge = null;
                for (ATermAppl arg : atom.getArguments()) {
                    if (!ATermUtils.isVar(arg)) continue;
                    disjointSet.add(arg);
                    if (toMerge != null) {
                        disjointSet.union(toMerge, arg);
                    }
                    toMerge = arg;
                }
            }
            Collection equivalenceSets = disjointSet.getEquivalanceSets();
            if (equivalenceSets.size() == 1) {
                return Collections.singletonList(query);
            }
            HashMap<ATermAppl, Query> queries = new HashMap<ATermAppl, Query>();
            Query groundQuery = null;
            for (QueryAtom atom : query.getAtoms()) {
                ATermAppl representative = null;
                for (ATermAppl arg : atom.getArguments()) {
                    if (!ATermUtils.isVar(arg)) continue;
                    representative = disjointSet.find(arg);
                    break;
                }
                Query newQuery = null;
                if (representative == null) {
                    if (groundQuery == null) {
                        groundQuery = new QueryImpl(query);
                    }
                    newQuery = groundQuery;
                } else {
                    newQuery = (Query)queries.get(representative);
                    if (newQuery == null) {
                        newQuery = new QueryImpl(query);
                        queries.put(representative, newQuery);
                    }
                    for (ATermAppl arg : atom.getArguments()) {
                        if (resultVars.contains(arg)) {
                            newQuery.addResultVar(arg);
                        }
                        for (Query.VarType v : Query.VarType.values()) {
                            if (!query.getDistVarsForType(v).contains(arg)) continue;
                            newQuery.addDistVar(arg, v);
                        }
                    }
                }
                newQuery.add(atom);
            }
            ArrayList<Query> list = new ArrayList<Query>(queries.values());
            if (groundQuery != null) {
                list.add(0, groundQuery);
            }
            return list;
        }
        catch (RuntimeException e) {
            _logger.log(Level.WARNING, "Query split failed, continuing with query execution.", e);
            return Collections.singletonList(query);
        }
    }

    private static void simplify(Query query) {
        QueryEngine.domainRangeSimplification(query);
    }

    private static Query preprocess(Query query) {
        ATermAppl a2;
        ATermAppl a1;
        Query q = query;
        Set<ATermAppl> undistVars = q.getUndistVars();
        boolean boundSameAs = true;
        block4: while (boundSameAs) {
            boundSameAs = false;
            for (QueryAtom atom : q.findAtoms(QueryPredicate.SameAs, null, null)) {
                ResultBindingImpl b;
                a1 = atom.getArguments().get(0);
                a2 = atom.getArguments().get(1);
                boolean replaceA1 = false;
                boolean replaceA2 = false;
                if (!a1.equals(a2)) {
                    if (undistVars.contains(a1)) {
                        replaceA1 = true;
                    } else if (undistVars.contains(a2)) {
                        replaceA2 = true;
                    } else if (ATermUtils.isVar(a1) && !q.getResultVars().contains(a1)) {
                        replaceA1 = true;
                    } else if (ATermUtils.isVar(a2) && !q.getResultVars().contains(a2)) {
                        replaceA2 = true;
                    }
                }
                if (!replaceA1 && !replaceA2) continue;
                if (replaceA1) {
                    b = new ResultBindingImpl();
                    b.setValue(a1, a2);
                } else {
                    b = new ResultBindingImpl();
                    b.setValue(a2, a1);
                }
                q = q.apply(b);
                boundSameAs = true;
                continue block4;
            }
        }
        for (QueryAtom atom : q.findAtoms(QueryPredicate.SameAs, null, null)) {
            a1 = atom.getArguments().get(0);
            if (!a1.equals(a2 = atom.getArguments().get(1)) || q.getResultVars().contains(a1) || q.getAtoms().size() <= 1) continue;
            q.remove(atom);
        }
        for (QueryAtom a : new HashSet<QueryAtom>(q.getAtoms())) {
            switch (a.getPredicate()) {
                case Type: 
                case DirectType: {
                    ATermAppl clazz = a.getArguments().get(1);
                    if (!undistVars.contains(clazz) || !undistVars.contains(a.getArguments().get(0))) break;
                    q.add(QueryAtomFactory.SubClassOfAtom(clazz, clazz));
                    break;
                }
                case PropertyValue: {
                    ATermAppl property = a.getArguments().get(1);
                    if (!undistVars.contains(a.getArguments().get(0)) && (!undistVars.contains(a.getArguments().get(2)) || !q.getDistVars().contains(property))) break;
                    q.add(QueryAtomFactory.SubPropertyOfAtom(property, property));
                    break;
                }
            }
        }
        return q;
    }

    public static CoreStrategy getStrategy(QueryAtom core) {
        return STRATEGY;
    }

    private static void domainRangeSimplification(Query query) {
        HashMap allInferredTypes = new HashMap();
        KnowledgeBase kb = query.getKB();
        Set<ATermAppl> vars = query.getVars();
        for (ATermAppl var : vars) {
            HashSet<ATermAppl> inferredTypes = new HashSet<ATermAppl>();
            for (QueryAtom pattern : query.findAtoms(QueryPredicate.PropertyValue, var, null, null)) {
                if (ATermUtils.isVar(pattern.getArguments().get(1))) continue;
                inferredTypes.addAll(kb.getDomains(pattern.getArguments().get(1)));
            }
            for (QueryAtom pattern : query.findAtoms(QueryPredicate.PropertyValue, null, null, var)) {
                if (ATermUtils.isVar(pattern.getArguments().get(1))) continue;
                inferredTypes.addAll(kb.getRanges(pattern.getArguments().get(1)));
            }
            if (inferredTypes.isEmpty()) continue;
            allInferredTypes.put(var, inferredTypes);
        }
        for (QueryAtom atom : new ArrayList<QueryAtom>(query.getAtoms())) {
            Set inferred;
            if (atom.getPredicate() != QueryPredicate.Type) continue;
            ATermAppl inst = atom.getArguments().get(0);
            ATermAppl clazz = atom.getArguments().get(1);
            if (ATermUtils.isVar(clazz) || (inferred = (Set)allInferredTypes.get(inst)) == null || inferred.isEmpty()) continue;
            if (inferred.contains(clazz)) {
                query.remove(atom);
                continue;
            }
            if (!kb.isClassified()) continue;
            Set<ATermAppl> subs = kb.getTaxonomy().getFlattenedSubs(clazz, false);
            Set<ATermAppl> eqs = kb.getAllEquivalentClasses(clazz);
            if (!SetUtils.intersects(inferred, subs) && !SetUtils.intersects(inferred, eqs)) continue;
            query.remove(atom);
        }
    }

    public static boolean execBooleanABoxQuery(Query query) {
        ATermAppl testClass;
        boolean querySatisfied;
        KnowledgeBase kb = query.getKB();
        kb.ensureConsistency();
        Bool allTriplesSatisfied = Bool.TRUE;
        for (QueryAtom atom : query.getAtoms()) {
            Bool tripleSatisfied = Bool.UNKNOWN;
            if (atom.isGround()) {
                List<ATermAppl> arguments = atom.getArguments();
                switch (atom.getPredicate()) {
                    case Type: {
                        tripleSatisfied = kb.isKnownType(arguments.get(0), arguments.get(1));
                        break;
                    }
                    case PropertyValue: 
                    case Annotation: {
                        tripleSatisfied = kb.hasKnownPropertyValue(arguments.get(0), arguments.get(1), arguments.get(2));
                        break;
                    }
                    default: {
                        tripleSatisfied = Bool.UNKNOWN;
                    }
                }
            }
            if (tripleSatisfied.isUnknown()) {
                allTriplesSatisfied = Bool.UNKNOWN;
                continue;
            }
            if (!tripleSatisfied.isFalse()) continue;
            allTriplesSatisfied = Bool.FALSE;
            if (!_logger.isLoggable(Level.FINER)) break;
            _logger.finer("Failed atom: " + atom);
            break;
        }
        if (allTriplesSatisfied.isKnown()) {
            querySatisfied = allTriplesSatisfied.isTrue();
        } else if (!query.getConstants().isEmpty()) {
            ATermAppl testInd = query.getConstants().iterator().next();
            testClass = query.rollUpTo(testInd, Collections.emptySet(), false);
            if (_logger.isLoggable(Level.FINER)) {
                _logger.finer("Boolean query: " + testInd + " -> " + testClass);
            }
            querySatisfied = kb.isType(testInd, testClass);
        } else {
            ATermAppl testVar = query.getUndistVars().iterator().next();
            testClass = query.rollUpTo(testVar, Collections.emptySet(), false);
            ATermAppl newUC = ATermUtils.normalize(ATermUtils.makeNot(testClass));
            Role topObjectRole = kb.getRole(TermFactory.TOP_OBJECT_PROPERTY);
            boolean added = topObjectRole.addDomain(newUC, DependencySet.INDEPENDENT);
            ABox copy = kb.getABox().copy();
            copy.setInitialized(false);
            boolean bl = querySatisfied = !copy.isConsistent();
            if (added) {
                topObjectRole.removeDomain(newUC, DependencySet.INDEPENDENT);
            }
        }
        return querySatisfied;
    }

    public static boolean checkGround(QueryAtom atom, KnowledgeBase kb) {
        List<ATermAppl> arguments = atom.getArguments();
        switch (atom.getPredicate()) {
            case Type: {
                return kb.isType(arguments.get(0), arguments.get(1));
            }
            case DirectType: {
                return kb.getInstances(arguments.get(1), true).contains(arguments.get(0));
            }
            case Annotation: {
                return kb.getAnnotations(arguments.get(0), arguments.get(1)).contains(arguments.get(2));
            }
            case PropertyValue: {
                return kb.hasPropertyValue(arguments.get(0), arguments.get(1), arguments.get(2));
            }
            case SameAs: {
                return kb.isSameAs(arguments.get(0), arguments.get(1));
            }
            case DifferentFrom: {
                return kb.isDifferentFrom(arguments.get(0), arguments.get(1));
            }
            case EquivalentClass: {
                return kb.isEquivalentClass(arguments.get(0), arguments.get(1));
            }
            case SubClassOf: {
                return kb.isSubClassOf(arguments.get(0), arguments.get(1));
            }
            case DirectSubClassOf: {
                for (Set<ATermAppl> a : kb.getSubClasses(arguments.get(1), true)) {
                    if (!a.contains(arguments.get(0))) continue;
                    return true;
                }
                return false;
            }
            case StrictSubClassOf: {
                return kb.isSubClassOf(arguments.get(0), arguments.get(1)) && !kb.getEquivalentClasses(arguments.get(1)).contains(arguments.get(0));
            }
            case DisjointWith: {
                return kb.isDisjoint(arguments.get(0), arguments.get(1));
            }
            case ComplementOf: {
                return kb.isComplement(arguments.get(0), arguments.get(1));
            }
            case EquivalentProperty: {
                return kb.isEquivalentProperty(arguments.get(0), arguments.get(1));
            }
            case SubPropertyOf: {
                return kb.isSubPropertyOf(arguments.get(0), arguments.get(1));
            }
            case DirectSubPropertyOf: {
                for (Set<ATermAppl> a : kb.getSubProperties(arguments.get(1), true)) {
                    if (!a.contains(arguments.get(0))) continue;
                    return true;
                }
                return false;
            }
            case StrictSubPropertyOf: {
                return kb.isSubPropertyOf(arguments.get(0), arguments.get(1)) && !kb.getEquivalentProperties(arguments.get(1)).contains(arguments.get(0));
            }
            case Domain: {
                return kb.hasDomain(arguments.get(0), arguments.get(1));
            }
            case Range: {
                return kb.hasRange(arguments.get(0), arguments.get(1));
            }
            case InverseOf: {
                return kb.isInverse(arguments.get(0), arguments.get(1));
            }
            case ObjectProperty: {
                return kb.isObjectProperty(arguments.get(0));
            }
            case DatatypeProperty: {
                return kb.isDatatypeProperty(arguments.get(0));
            }
            case Functional: {
                return kb.isFunctionalProperty(arguments.get(0));
            }
            case InverseFunctional: {
                return kb.isInverseFunctionalProperty(arguments.get(0));
            }
            case Symmetric: {
                return kb.isSymmetricProperty(arguments.get(0));
            }
            case Asymmetric: {
                return kb.isAsymmetricProperty(arguments.get(0));
            }
            case Reflexive: {
                return kb.isReflexiveProperty(arguments.get(0));
            }
            case Irreflexive: {
                return kb.isIrreflexiveProperty(arguments.get(0));
            }
            case Transitive: {
                return kb.isTransitiveProperty(arguments.get(0));
            }
            case NotKnown: {
                for (QueryAtom notAtom : ((NotKnownQueryAtom)atom).getAtoms()) {
                    if (QueryEngine.checkGround(notAtom, kb)) continue;
                    return true;
                }
                return false;
            }
            case NegativePropertyValue: {
                return kb.isType(arguments.get(0), TermFactory.not(TermFactory.hasValue(arguments.get(1), arguments.get(2))));
            }
            case Union: {
                Iterator<List<QueryAtom>> iterator = ((UnionQueryAtom)atom).getUnion().iterator();
                if (iterator.hasNext()) {
                    List<QueryAtom> atoms = iterator.next();
                    for (QueryAtom unionAtom : atoms) {
                        if (!QueryEngine.checkGround(unionAtom, kb)) break;
                    }
                    return true;
                }
                return false;
            }
            case Datatype: {
                ATermAppl l = arguments.get(0);
                ATermAppl d = arguments.get(1);
                if (!ATermUtils.isLiteral(l)) {
                    return false;
                }
                DatatypeReasoner dtReasoner = kb.getDatatypeReasoner();
                try {
                    Object value = dtReasoner.getValue(l);
                    return dtReasoner.isSatisfiable(Collections.singleton(d), value);
                }
                catch (DatatypeReasonerException e) {
                    String msg = String.format("Unexpected datatype reasoner exception while checking if literal (%s) is in datarange (%s): %s ", l, d, e.getMessage());
                    _logger.severe(msg);
                    throw new InternalReasonerException(msg, e);
                }
            }
        }
        throw new IllegalArgumentException("Unknown atom type : " + (Object)((Object)atom.getPredicate()));
    }
}

