/*
 * Decompiled with CFR 0.152.
 */
package openllet.query.sparqldl.model;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import openllet.aterm.ATermAppl;
import openllet.query.sparqldl.model.QueryAtom;
import openllet.query.sparqldl.model.QueryPredicate;
import openllet.query.sparqldl.model.ResultBinding;

public class UnionQueryAtom
implements QueryAtom {
    private final List<List<QueryAtom>> _union;
    private boolean _isGround;
    private final List<ATermAppl> _args;

    public UnionQueryAtom(List<QueryAtom> atoms1, List<QueryAtom> atoms2) {
        this(Arrays.asList(atoms1, atoms2));
    }

    public UnionQueryAtom(List<List<QueryAtom>> union) {
        if (union.isEmpty()) {
            throw new IllegalArgumentException("Empty collection of atoms not allowed in NotKnown atom");
        }
        this._union = Collections.unmodifiableList(union);
        this._isGround = true;
        this._args = new ArrayList<ATermAppl>();
        for (List<QueryAtom> atoms : union) {
            for (QueryAtom atom : atoms) {
                this._args.addAll(atom.getArguments());
                if (!this._isGround || atom.isGround()) continue;
                this._isGround = false;
            }
        }
    }

    @Override
    public QueryAtom apply(ResultBinding binding) {
        ArrayList<List<QueryAtom>> newUnion = new ArrayList<List<QueryAtom>>();
        for (List<QueryAtom> atoms : this._union) {
            ArrayList<QueryAtom> newAtoms = new ArrayList<QueryAtom>();
            for (QueryAtom atom : atoms) {
                newAtoms.add(atom.apply(binding));
            }
            newUnion.add(newAtoms);
        }
        return new UnionQueryAtom(newUnion);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof UnionQueryAtom)) {
            return false;
        }
        return this._union.equals(((UnionQueryAtom)obj)._union);
    }

    @Override
    public List<ATermAppl> getArguments() {
        return this._args;
    }

    public List<List<QueryAtom>> getUnion() {
        return this._union;
    }

    @Override
    public QueryPredicate getPredicate() {
        return QueryPredicate.Union;
    }

    public int hashCode() {
        return 31 * this._union.hashCode();
    }

    @Override
    public boolean isGround() {
        return this._isGround;
    }

    public String toString() {
        return "Union" + this._union;
    }
}

