/*
 * Decompiled with CFR 0.152.
 */
package openllet.shared.hash;

public class HashFunctions {
    public static final int GOLDEN_RATIO = -1640531527;

    public static int oneAtATime(Object[] o) {
        int hash = 0;
        for (Object element : o) {
            hash += element.hashCode();
            hash += hash << 10;
            hash ^= hash >> 6;
        }
        hash += hash << 3;
        hash ^= hash >> 11;
        hash += hash << 15;
        return hash;
    }

    public static int simple(Object[] o) {
        int hash = o[o.length - 1].hashCode();
        for (int i = 0; i < o.length - 1; ++i) {
            hash = 16 * hash + o[i].hashCode();
        }
        return hash;
    }

    public static int cwi(Object[] o) {
        int hash = 0;
        for (Object element : o) {
            hash = hash << 1 ^ hash >> 1 ^ element.hashCode();
        }
        return hash;
    }

    public static int doobs(Object[] o) {
        int alpha = -1640531527;
        return HashFunctions.mix(alpha += o[0].hashCode(), -1640531527, o.length);
    }

    public static int mix(int aBit, int bBit, int cBit) {
        int a = aBit;
        int b = bBit;
        int c = cBit;
        a -= b;
        a -= c;
        b -= c;
        b -= (a ^= c >> 13);
        c -= a;
        c -= (b ^= a << 8);
        a -= b;
        a -= (c ^= b >> 13);
        b -= c;
        b -= (a ^= c >> 12);
        c -= a;
        c -= (b ^= a << 16);
        a -= b;
        a -= (c ^= b >> 5);
        b -= c;
        b -= (a ^= c >> 3);
        c -= a;
        c -= (b ^= a << 10);
        return c ^= b >> 15;
    }

    public static int hashTerm(String name, boolean isQuoted, int arity) {
        int a = -1640531527;
        int b = -1640531527;
        int len = name.length();
        if (len >= 12) {
            return HashFunctions.hashLongNames(name, isQuoted, arity);
        }
        int c = isQuoted ? 7 * arity + 1 : arity + 1;
        c += len;
        switch (len) {
            case 11: {
                c += name.charAt(10) << 24;
            }
            case 10: {
                c += name.charAt(9) << 16;
            }
            case 9: {
                c += name.charAt(8) << 8;
            }
            case 8: {
                b += name.charAt(7) << 24;
            }
            case 7: {
                b += name.charAt(6) << 16;
            }
            case 6: {
                b += name.charAt(5) << 8;
            }
            case 5: {
                b += name.charAt(4);
            }
            case 4: {
                a += name.charAt(3) << 24;
            }
            case 3: {
                a += name.charAt(2) << 16;
            }
            case 2: {
                a += name.charAt(1) << 8;
            }
            case 1: {
                a += name.charAt(0);
            }
        }
        return HashFunctions.mix(a, b, c);
    }

    public static int hashLongNames(String name, boolean isQuoted, int arity) {
        int len;
        int count = name.length();
        char[] source = new char[count];
        name.getChars(0, count, source, 0);
        int a = -1640531527;
        int b = -1640531527;
        int c = isQuoted ? 7 * (arity + 1) : arity + 1;
        int k = 0;
        for (len = count; len >= 12; len -= 12) {
            a += source[k + 0] + (source[k + 1] << 8) + (source[k + 2] << 16) + (source[k + 3] << 24);
            a -= (b += source[k + 4] + (source[k + 5] << 8) + (source[k + 6] << 16) + (source[k + 7] << 24));
            a -= (c += source[k + 8] + (source[k + 9] << 8) + (source[k + 10] << 16) + (source[k + 11] << 24));
            b -= c;
            b -= (a ^= c >> 13);
            c -= a;
            c -= (b ^= a << 8);
            a -= b;
            a -= (c ^= b >> 13);
            b -= c;
            b -= (a ^= c >> 12);
            c -= a;
            c -= (b ^= a << 16);
            a -= b;
            a -= (c ^= b >> 5);
            b -= c;
            b -= (a ^= c >> 3);
            c -= a;
            c -= (b ^= a << 10);
            c ^= b >> 15;
            k += 12;
        }
        c += count;
        switch (len) {
            case 11: {
                c += source[k + 10] << 24;
            }
            case 10: {
                c += source[k + 9] << 16;
            }
            case 9: {
                c += source[k + 8] << 8;
            }
            case 8: {
                b += source[k + 7] << 24;
            }
            case 7: {
                b += source[k + 6] << 16;
            }
            case 6: {
                b += source[k + 5] << 8;
            }
            case 5: {
                b += source[k + 4];
            }
            case 4: {
                a += source[k + 3] << 24;
            }
            case 3: {
                a += source[k + 2] << 16;
            }
            case 2: {
                a += source[k + 1] << 8;
            }
            case 1: {
                a += source[k + 0];
            }
        }
        return HashFunctions.mix(a, b, c);
    }
}

