/*
 * Decompiled with CFR 0.152.
 */
package org.jgrapht;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import org.jgrapht.Graph;
import org.jgrapht.alg.shortestpath.GraphMeasurer;
import org.jgrapht.alg.util.NeighborCache;

public abstract class GraphMetrics {
    public static <V, E> double getDiameter(Graph<V, E> graph) {
        return new GraphMeasurer<V, E>(graph).getDiameter();
    }

    public static <V, E> double getRadius(Graph<V, E> graph) {
        return new GraphMeasurer<V, E>(graph).getRadius();
    }

    public static <V, E> int getGirth(Graph<V, E> graph) {
        int NIL = -1;
        boolean isAllowingMultipleEdges = graph.getType().isAllowingMultipleEdges();
        ArrayList<V> vertices = new ArrayList<V>(graph.vertexSet());
        HashMap indexMap = new HashMap();
        for (int i = 0; i < vertices.size(); ++i) {
            indexMap.put(vertices.get(i), i);
        }
        int girth = Integer.MAX_VALUE;
        int[] depth = new int[vertices.size()];
        LinkedList<Object> queue = new LinkedList<Object>();
        if (graph.getType().isAllowingSelfLoops()) {
            for (Object v : vertices) {
                if (!graph.containsEdge(v, v)) continue;
                return 1;
            }
        }
        NeighborCache neighborIndex = new NeighborCache(graph);
        if (graph.getType().isUndirected()) {
            int[] parent = new int[vertices.size()];
            for (int i = 0; i < vertices.size() - 2 && girth > 3; ++i) {
                int depthU;
                Arrays.fill(depth, -1);
                Arrays.fill(parent, -1);
                queue.clear();
                depth[i] = 0;
                queue.add(vertices.get(i));
                do {
                    Object u = queue.poll();
                    int indexU = (Integer)indexMap.get(u);
                    depthU = depth[indexU];
                    for (V v : neighborIndex.neighborsOf(u)) {
                        int indexV = (Integer)indexMap.get(v);
                        if (parent[indexU] == indexV && (!isAllowingMultipleEdges || graph.getAllEdges(u, v).size() == 1)) continue;
                        int depthV = depth[indexV];
                        if (depthV == -1) {
                            queue.add(v);
                            depth[indexV] = depthU + 1;
                            parent[indexV] = indexU;
                            continue;
                        }
                        girth = Math.min(girth, depthU + depthV + 1);
                    }
                } while (!queue.isEmpty() && 2 * (depthU + 1) - 1 < girth);
            }
        } else {
            for (int i = 0; i < vertices.size() - 1 && girth > 2; ++i) {
                int depthU;
                Arrays.fill(depth, -1);
                queue.clear();
                depth[i] = 0;
                queue.add(vertices.get(i));
                do {
                    Object u = queue.poll();
                    int indexU = (Integer)indexMap.get(u);
                    depthU = depth[indexU];
                    for (V v : neighborIndex.successorsOf(u)) {
                        int indexV = (Integer)indexMap.get(v);
                        int depthV = depth[indexV];
                        if (depthV == -1) {
                            queue.add(v);
                            depth[indexV] = depthU + 1;
                            continue;
                        }
                        if (depthV != 0) continue;
                        girth = Math.min(girth, depthU + depthV + 1);
                    }
                } while (!queue.isEmpty() && depthU + 1 < girth);
            }
        }
        assert (graph.getType().isUndirected() && graph.getType().isSimple() && girth >= 3 || graph.getType().isAllowingSelfLoops() && girth >= 1 || girth >= 2 && (graph.getType().isDirected() || graph.getType().isAllowingMultipleEdges()));
        return girth;
    }
}

