/*
 * Decompiled with CFR 0.152.
 */
package org.jgrapht.generate;

import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import org.jgrapht.Graph;
import org.jgrapht.VertexFactory;
import org.jgrapht.generate.GraphGenerator;
import org.jgrapht.graph.AbstractBaseGraph;

public class GnmRandomGraphGenerator<V, E>
implements GraphGenerator<V, E, V> {
    private static final boolean DEFAULT_ALLOW_LOOPS = false;
    private static final boolean DEFAULT_ALLOW_MULTIPLE_EDGES = false;
    private final Random rng;
    private final int n;
    private final int m;
    private final boolean loops;
    private final boolean multipleEdges;

    public GnmRandomGraphGenerator(int n, int m) {
        this(n, m, new Random(), false, false);
    }

    public GnmRandomGraphGenerator(int n, int m, long seed) {
        this(n, m, new Random(seed), false, false);
    }

    public GnmRandomGraphGenerator(int n, int m, long seed, boolean loops, boolean multipleEdges) {
        this(n, m, new Random(seed), loops, multipleEdges);
    }

    public GnmRandomGraphGenerator(int n, int m, Random rng, boolean loops, boolean multipleEdges) {
        if (n < 0) {
            throw new IllegalArgumentException("number of vertices must be non-negative");
        }
        this.n = n;
        if (m < 0) {
            throw new IllegalArgumentException("number of edges must be non-negative");
        }
        this.m = m;
        this.rng = rng;
        this.loops = loops;
        this.multipleEdges = multipleEdges;
    }

    @Override
    public void generateGraph(Graph<V, E> target, VertexFactory<V> vertexFactory, Map<String, V> resultMap) {
        boolean createMultipleEdges;
        if (this.n == 0) {
            return;
        }
        boolean createLoops = this.loops;
        if (createLoops) {
            if (target instanceof AbstractBaseGraph) {
                AbstractBaseGraph abg = (AbstractBaseGraph)target;
                if (!abg.isAllowingLoops()) {
                    throw new IllegalArgumentException("Provided graph does not support self-loops");
                }
            } else {
                createLoops = false;
            }
        }
        if (createMultipleEdges = this.multipleEdges) {
            if (target instanceof AbstractBaseGraph) {
                AbstractBaseGraph abg = (AbstractBaseGraph)target;
                if (!abg.isAllowingMultipleEdges()) {
                    throw new IllegalArgumentException("Provided graph does not support multiple edges between the same vertices");
                }
            } else {
                createMultipleEdges = false;
            }
        }
        if (this.m > GnmRandomGraphGenerator.computeMaximumAllowedEdges(this.n, target.getType().isDirected(), createLoops, createMultipleEdges)) {
            throw new IllegalArgumentException("number of edges is not valid for the graph type \n-> invalid number of edges=" + this.m + " for: graph type=" + target.getClass() + ", number of vertices=" + this.n);
        }
        HashMap<Integer, V> vertices = new HashMap<Integer, V>(this.n);
        int previousVertexSetSize = target.vertexSet().size();
        for (int i = 0; i < this.n; ++i) {
            V currVertex = vertexFactory.createVertex();
            target.addVertex(currVertex);
            vertices.put(i, currVertex);
        }
        if (target.vertexSet().size() != previousVertexSetSize + this.n) {
            throw new IllegalArgumentException("Vertex factory did not produce " + this.n + " distinct vertices.");
        }
        int edgesCounter = 0;
        while (edgesCounter < this.m) {
            Object s = vertices.get(this.rng.nextInt(this.n));
            Object t = vertices.get(this.rng.nextInt(this.n));
            boolean addEdge = false;
            if (s.equals(t)) {
                if (createLoops) {
                    addEdge = true;
                }
            } else if (createMultipleEdges) {
                addEdge = true;
            } else if (!target.containsEdge(s, t)) {
                addEdge = true;
            }
            if (!addEdge) continue;
            try {
                E resultEdge = target.addEdge(s, t);
                if (resultEdge == null) continue;
                ++edgesCounter;
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        }
    }

    static <V, E> int computeMaximumAllowedEdges(int n, boolean isDirected, boolean createLoops, boolean createMultipleEdges) {
        int maxAllowedEdges;
        if (n == 0) {
            return 0;
        }
        try {
            maxAllowedEdges = isDirected ? Math.multiplyExact(n, n - 1) : (n % 2 == 0 ? Math.multiplyExact(n / 2, n - 1) : Math.multiplyExact(n, (n - 1) / 2));
            if (createLoops) {
                if (createMultipleEdges) {
                    return Integer.MAX_VALUE;
                }
                maxAllowedEdges = isDirected ? Math.addExact(maxAllowedEdges, Math.multiplyExact(2, n)) : Math.addExact(maxAllowedEdges, n);
            } else if (createMultipleEdges && n > 1) {
                return Integer.MAX_VALUE;
            }
        }
        catch (ArithmeticException e) {
            return Integer.MAX_VALUE;
        }
        return maxAllowedEdges;
    }
}

