/*
 * Decompiled with CFR 0.152.
 */
package org.jgrapht.graph.specifics;

import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jgrapht.alg.util.Pair;
import org.jgrapht.alg.util.UnorderedPair;
import org.jgrapht.graph.AbstractBaseGraph;
import org.jgrapht.graph.EdgeSetFactory;
import org.jgrapht.graph.specifics.ArrayUnenforcedSetEdgeSetFactory;
import org.jgrapht.graph.specifics.UndirectedEdgeContainer;
import org.jgrapht.graph.specifics.UndirectedSpecifics;
import org.jgrapht.util.ArrayUnenforcedSet;

public class FastLookupUndirectedSpecifics<V, E>
extends UndirectedSpecifics<V, E> {
    private static final long serialVersionUID = 225772727571597846L;
    protected Map<Pair<V, V>, ArrayUnenforcedSet<E>> touchingVerticesToEdgeMap = new HashMap<Pair<V, V>, ArrayUnenforcedSet<E>>();

    public FastLookupUndirectedSpecifics(AbstractBaseGraph<V, E> abstractBaseGraph) {
        this(abstractBaseGraph, new LinkedHashMap(), new ArrayUnenforcedSetEdgeSetFactory());
    }

    public FastLookupUndirectedSpecifics(AbstractBaseGraph<V, E> abstractBaseGraph, Map<V, UndirectedEdgeContainer<V, E>> vertexMap) {
        this(abstractBaseGraph, vertexMap, new ArrayUnenforcedSetEdgeSetFactory());
    }

    public FastLookupUndirectedSpecifics(AbstractBaseGraph<V, E> abstractBaseGraph, Map<V, UndirectedEdgeContainer<V, E>> vertexMap, EdgeSetFactory<V, E> edgeSetFactory) {
        super(abstractBaseGraph, vertexMap, edgeSetFactory);
    }

    @Override
    public Set<E> getAllEdges(V sourceVertex, V targetVertex) {
        if (this.abstractBaseGraph.containsVertex(sourceVertex) && this.abstractBaseGraph.containsVertex(targetVertex)) {
            Set edges = this.touchingVerticesToEdgeMap.get(new UnorderedPair<V, V>(sourceVertex, targetVertex));
            return edges == null ? Collections.emptySet() : new ArrayUnenforcedSet(edges);
        }
        return null;
    }

    @Override
    public E getEdge(V sourceVertex, V targetVertex) {
        List edges = this.touchingVerticesToEdgeMap.get(new UnorderedPair<V, V>(sourceVertex, targetVertex));
        if (edges == null || edges.isEmpty()) {
            return null;
        }
        return edges.get(0);
    }

    @Override
    public void addEdgeToTouchingVertices(E e) {
        Object source = this.abstractBaseGraph.getEdgeSource(e);
        Object target = this.abstractBaseGraph.getEdgeTarget(e);
        this.getEdgeContainer(source).addEdge(e);
        UnorderedPair vertexPair = new UnorderedPair(source, target);
        ArrayUnenforcedSet<E> edgeSet = this.touchingVerticesToEdgeMap.get(vertexPair);
        if (edgeSet != null) {
            edgeSet.add(e);
        } else {
            edgeSet = new ArrayUnenforcedSet();
            edgeSet.add(e);
            this.touchingVerticesToEdgeMap.put(vertexPair, edgeSet);
        }
        if (!source.equals(target)) {
            this.getEdgeContainer(target).addEdge(e);
        }
    }

    @Override
    public void removeEdgeFromTouchingVertices(E e) {
        UnorderedPair vertexPair;
        ArrayUnenforcedSet<E> edgeSet;
        Object source = this.abstractBaseGraph.getEdgeSource(e);
        Object target = this.abstractBaseGraph.getEdgeTarget(e);
        this.getEdgeContainer(source).removeEdge(e);
        if (!source.equals(target)) {
            this.getEdgeContainer(target).removeEdge(e);
        }
        if ((edgeSet = this.touchingVerticesToEdgeMap.get(vertexPair = new UnorderedPair(source, target))) != null) {
            edgeSet.remove(e);
            if (edgeSet.isEmpty()) {
                this.touchingVerticesToEdgeMap.remove(vertexPair);
            }
        }
    }
}

