/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.io;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Optional;
import java.util.zip.GZIPInputStream;
import javax.annotation.Nullable;
import org.apache.commons.io.IOUtils;
import org.semanticweb.owlapi.io.OWLOntologyDocumentSourceBase;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLDocumentFormat;
import org.semanticweb.owlapi.model.OWLRuntimeException;
import org.semanticweb.owlapi.util.OWLAPIPreconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GZipStreamDocumentSource
extends OWLOntologyDocumentSourceBase {
    private static final Logger LOGGER = LoggerFactory.getLogger(GZipStreamDocumentSource.class);
    @Nullable
    private byte[] buffer;

    public GZipStreamDocumentSource(InputStream is) {
        super("gzipinputstream:ontology", null, null);
        this.readIntoBuffer(is);
    }

    public GZipStreamDocumentSource(InputStream stream, IRI documentIRI, @Nullable OWLDocumentFormat format, @Nullable String mime) {
        super(documentIRI, format, mime);
        this.readIntoBuffer(stream);
    }

    private void readIntoBuffer(InputStream reader) {
        try {
            this.buffer = IOUtils.toByteArray(reader);
        }
        catch (IOException e) {
            throw new OWLRuntimeException(e);
        }
    }

    @Override
    public Optional<InputStream> getInputStream() {
        if (this.buffer == null) {
            return OWLAPIPreconditions.emptyOptional();
        }
        try {
            return OWLAPIPreconditions.optional(new GZIPInputStream(new ByteArrayInputStream(this.buffer)));
        }
        catch (IOException e) {
            LOGGER.error("Buffer cannot be opened", e);
            this.failedOnStreams.set(true);
            return OWLAPIPreconditions.emptyOptional();
        }
    }
}

