/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.model;

import java.util.Collection;
import java.util.Objects;
import java.util.stream.Stream;
import org.semanticweb.owlapi.model.HasOperands;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLPairwiseBooleanVisitor;
import org.semanticweb.owlapi.model.OWLPairwiseVisitor;
import org.semanticweb.owlapi.model.OWLPairwiseVoidVisitor;
import org.semanticweb.owlapi.util.OWLAPIStreamUtils;

public interface OWLNaryAxiom<C extends OWLObject>
extends OWLAxiom,
HasOperands<C> {
    @Override
    public Stream<C> operands();

    public Collection<? extends OWLNaryAxiom<C>> asPairwiseAxioms();

    default public <T> Collection<T> walkPairwise(OWLPairwiseVisitor<T, C> visitor) {
        return OWLAPIStreamUtils.asList(OWLAPIStreamUtils.pairs(this.operands()).map(v -> visitor.visit(v.i, v.j)).filter(Objects::nonNull));
    }

    default public <T> Collection<T> walkAllPairwise(OWLPairwiseVisitor<T, C> visitor) {
        return OWLAPIStreamUtils.asList(OWLAPIStreamUtils.allPairs(this.operands()).map(v -> visitor.visit(v.i, v.j)).filter(Objects::nonNull));
    }

    default public void forEach(OWLPairwiseVoidVisitor<C> visitor) {
        OWLAPIStreamUtils.pairs(this.operands()).forEach((? super T v) -> visitor.visit(v.i, v.j));
    }

    default public boolean anyMatch(OWLPairwiseBooleanVisitor<C> visitor) {
        return OWLAPIStreamUtils.pairs(this.operands()).anyMatch((? super T v) -> visitor.visit(v.i, v.j));
    }

    default public boolean allMatch(OWLPairwiseBooleanVisitor<C> visitor) {
        return OWLAPIStreamUtils.pairs(this.operands()).allMatch((? super T v) -> visitor.visit(v.i, v.j));
    }

    default public void forEachAllPairs(OWLPairwiseVoidVisitor<C> visitor) {
        OWLAPIStreamUtils.allPairs(this.operands()).forEach((? super T v) -> visitor.visit(v.i, v.j));
    }

    default public boolean anyMatchAllPairs(OWLPairwiseBooleanVisitor<C> visitor) {
        return OWLAPIStreamUtils.allPairs(this.operands()).anyMatch((? super T v) -> visitor.visit(v.i, v.j));
    }

    default public boolean allMatchAllPairs(OWLPairwiseBooleanVisitor<C> visitor) {
        return OWLAPIStreamUtils.allPairs(this.operands()).allMatch((? super T v) -> visitor.visit(v.i, v.j));
    }

    public Collection<? extends OWLAxiom> splitToAnnotatedPairs();
}

