/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import org.semanticweb.owlapi.model.AxiomType;
import org.semanticweb.owlapi.model.HasObjectPropertiesInSignature;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLEquivalentObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLSubPropertyChainOfAxiom;
import org.semanticweb.owlapi.model.parameters.Imports;
import org.semanticweb.owlapi.search.Searcher;
import org.semanticweb.owlapi.util.OWLAPIPreconditions;
import org.semanticweb.owlapi.util.OWLAPIStreamUtils;

public class OWLObjectPropertyManager {
    private final OWLDataFactory df;
    private final OWLOntology ontology;
    private final Map<OWLObjectPropertyExpression, Set<OWLObjectPropertyExpression>> hierarchy = new HashMap<OWLObjectPropertyExpression, Set<OWLObjectPropertyExpression>>();
    private final Map<OWLObjectPropertyExpression, Set<OWLObjectPropertyExpression>> reflexiveTransitiveClosure = new HashMap<OWLObjectPropertyExpression, Set<OWLObjectPropertyExpression>>();
    private final Set<OWLObjectPropertyExpression> compositeProperties = new HashSet<OWLObjectPropertyExpression>();
    private final Set<OWLObjectPropertyExpression> nonSimpleProperties = new HashSet<OWLObjectPropertyExpression>();
    private final Map<OWLObjectPropertyExpression, Set<OWLObjectPropertyExpression>> partialOrdering = new HashMap<OWLObjectPropertyExpression, Set<OWLObjectPropertyExpression>>();
    private boolean compositeDirty;
    private boolean hierarchyDirty;
    private boolean reflexiveTransitiveClosureDirty;
    private boolean simpleDirty;
    private boolean partialOrderingDirty;

    public OWLObjectPropertyManager(OWLOntology ont) {
        this.ontology = OWLAPIPreconditions.checkNotNull(ont, "ontology cannot be null");
        this.df = this.ontology.getOWLOntologyManager().getOWLDataFactory();
        this.reset();
    }

    public static Collection<Set<OWLObjectPropertyExpression>> getEquivalentObjectProperties(Stream<OWLOntology> ontologies) {
        OWLAPIPreconditions.checkNotNull(ontologies, "ontologies cannot be null");
        HashSet result = new HashSet();
        HashSet processed = new HashSet();
        Stream properties = ontologies.flatMap(HasObjectPropertiesInSignature::objectPropertiesInSignature);
        properties.forEach(p -> {
            if (!processed.contains(p)) {
                OWLObjectPropertyManager.tarjan(ontologies, p, 0, new LinkedList<OWLObjectPropertyExpression>(), new HashMap<OWLObjectPropertyExpression, Integer>(), new HashMap<OWLObjectPropertyExpression, Integer>(), result, processed, new HashSet<OWLObjectPropertyExpression>());
            }
        });
        ArrayList<Set<OWLObjectPropertyExpression>> equivs = new ArrayList<Set<OWLObjectPropertyExpression>>(result);
        Collections.sort(equivs, (o1, o2) -> Integer.compare(o1.size(), o2.size()));
        block0: for (int i = 0; i < equivs.size(); ++i) {
            for (int j = i; j < equivs.size(); ++j) {
                if (!((Set)equivs.get(j)).containsAll((Collection)equivs.get(i))) continue;
                equivs.remove(i);
                continue block0;
            }
        }
        return equivs;
    }

    public static void tarjan(Stream<OWLOntology> ontologies, OWLObjectPropertyExpression prop, int index, Deque<OWLObjectPropertyExpression> stack, Map<OWLObjectPropertyExpression, Integer> indexMap, Map<OWLObjectPropertyExpression, Integer> lowlinkMap, Set<Set<OWLObjectPropertyExpression>> result, Set<OWLObjectPropertyExpression> processed, Set<OWLObjectPropertyExpression> stackProps) {
        OWLAPIPreconditions.checkNotNull(ontologies, "ontologies cannot be null");
        OWLAPIPreconditions.checkNotNull(prop, "prop cannot be null");
        OWLAPIPreconditions.checkNotNull(stack, "stack cannot be null");
        OWLAPIPreconditions.checkNotNull(indexMap, "indexMap cannot be null");
        OWLAPIPreconditions.checkNotNull(lowlinkMap, "lowlinkMap cannot be null");
        OWLAPIPreconditions.checkNotNull(result, "result cannot be null");
        OWLAPIPreconditions.checkNotNull(processed, "processed cannot be null");
        OWLAPIPreconditions.checkNotNull(stackProps, "stackProps cannot be null");
        processed.add(prop);
        indexMap.put(prop, index);
        lowlinkMap.put(prop, index);
        stack.push(prop);
        stackProps.add(prop);
        ontologies.flatMap(ont -> ont.objectSubPropertyAxiomsForSubProperty(prop)).filter(ax -> ((OWLObjectPropertyExpression)ax.getSubProperty()).equals(prop)).forEach(ax -> OWLObjectPropertyManager.callTarjanAndPut(ontologies, prop, index, stack, indexMap, lowlinkMap, result, processed, stackProps, (OWLObjectPropertyExpression)ax.getSuperProperty()));
        if (lowlinkMap.get(prop).equals(indexMap.get(prop))) {
            OWLObjectPropertyExpression propPrime;
            HashSet<OWLObjectPropertyExpression> scc = new HashSet<OWLObjectPropertyExpression>();
            do {
                propPrime = stack.pop();
                stackProps.remove(propPrime);
                scc.add(propPrime);
            } while (!propPrime.equals(prop));
            if (scc.size() > 1) {
                result.add(scc);
            }
        }
    }

    protected static void callTarjanAndPut(Stream<OWLOntology> ontologies, OWLObjectPropertyExpression prop, int index, Deque<OWLObjectPropertyExpression> stack, Map<OWLObjectPropertyExpression, Integer> indexMap, Map<OWLObjectPropertyExpression, Integer> lowlinkMap, Set<Set<OWLObjectPropertyExpression>> result, Set<OWLObjectPropertyExpression> processed, Set<OWLObjectPropertyExpression> stackProps, OWLObjectPropertyExpression supProp) {
        if (!indexMap.containsKey(supProp)) {
            OWLObjectPropertyManager.tarjan(ontologies, supProp, index + 1, stack, indexMap, lowlinkMap, result, processed, stackProps);
            OWLObjectPropertyManager.put(prop, lowlinkMap, supProp);
        } else if (stackProps.contains(supProp)) {
            OWLObjectPropertyManager.putIndex(prop, indexMap, lowlinkMap, supProp);
        }
    }

    protected static void putIndex(OWLObjectPropertyExpression prop, Map<OWLObjectPropertyExpression, Integer> indexMap, Map<OWLObjectPropertyExpression, Integer> lowlinkMap, OWLObjectPropertyExpression supProp) {
        lowlinkMap.put(prop, Math.min(lowlinkMap.get(prop), indexMap.get(supProp)));
    }

    protected static void put(OWLObjectPropertyExpression prop, Map<OWLObjectPropertyExpression, Integer> lowlinkMap, OWLObjectPropertyExpression supProp) {
        OWLObjectPropertyManager.putIndex(prop, lowlinkMap, lowlinkMap, supProp);
    }

    private static Set<OWLObjectPropertyExpression> getReflexiveTransitiveClosure(OWLObjectPropertyExpression prop, Map<OWLObjectPropertyExpression, Set<OWLObjectPropertyExpression>> map, Set<OWLObjectPropertyExpression> rtc, Set<OWLObjectPropertyExpression> processed) {
        OWLAPIPreconditions.checkNotNull(prop, "prop cannot be null");
        OWLAPIPreconditions.checkNotNull(map, "map cannot be null");
        OWLAPIPreconditions.checkNotNull(rtc, "rtc cannot be null");
        OWLAPIPreconditions.checkNotNull(processed, "processed cannot be null");
        if (processed.contains(prop)) {
            return rtc;
        }
        rtc.add(prop);
        processed.add(prop);
        Set<OWLObjectPropertyExpression> supers = map.get(prop);
        if (supers == null) {
            return rtc;
        }
        supers.forEach(sup -> OWLObjectPropertyManager.getReflexiveTransitiveClosure(sup, map, rtc, processed));
        return rtc;
    }

    private static Set<OWLObjectPropertyExpression> getKeyValue(OWLObjectPropertyExpression key, Map<OWLObjectPropertyExpression, Set<OWLObjectPropertyExpression>> map) {
        return map.computeIfAbsent(key, k -> new HashSet(4));
    }

    private void reset() {
        this.compositeDirty = true;
        this.hierarchyDirty = true;
        this.reflexiveTransitiveClosureDirty = true;
        this.simpleDirty = true;
        this.partialOrderingDirty = true;
    }

    public boolean isComposite(OWLObjectPropertyExpression expression) {
        OWLAPIPreconditions.checkNotNull(expression, "expression cannot be null");
        return this.getCompositeProperties().contains(expression);
    }

    protected Stream<OWLObjectPropertyExpression> inverseProperties(OWLObjectPropertyExpression p1) {
        return Searcher.inverse(this.ontology.inverseObjectPropertyAxioms(p1), p1);
    }

    protected Stream<OWLOntology> ontologies() {
        return Imports.INCLUDED.stream(this.ontology);
    }

    protected <T extends OWLAxiom> Stream<T> axioms(AxiomType<T> t) {
        return this.ontologies().flatMap(o -> o.axioms(t));
    }

    public Set<OWLObjectPropertyExpression> getCompositeProperties() {
        if (this.compositeDirty) {
            this.compositeProperties.clear();
            this.compositeProperties.add(this.df.getOWLTopObjectProperty());
            this.compositeProperties.add(this.df.getOWLBottomObjectProperty());
            this.axioms(AxiomType.TRANSITIVE_OBJECT_PROPERTY).forEach(ax -> this.mark((OWLObjectPropertyExpression)ax.getProperty()));
            this.axioms(AxiomType.SUB_PROPERTY_CHAIN_OF).forEach(ax -> this.mark(ax.getSuperProperty()));
            this.compositeDirty = false;
        }
        return this.compositeProperties;
    }

    protected void mark(OWLObjectPropertyExpression p) {
        this.compositeProperties.add(p);
        this.compositeProperties.add(p.getInverseProperty());
        this.inverseProperties(p).forEach(i -> {
            this.compositeProperties.add((OWLObjectPropertyExpression)i);
            this.compositeProperties.add(i.getInverseProperty());
        });
    }

    public Map<OWLObjectPropertyExpression, Set<OWLObjectPropertyExpression>> getPropertyHierarchy() {
        if (this.hierarchyDirty) {
            HashMap map = new HashMap();
            this.axioms(AxiomType.SUB_OBJECT_PROPERTY).forEach(ax -> this.getKeyValueSymmetric(map, (OWLObjectPropertyExpression)ax.getSubProperty(), (OWLObjectPropertyExpression)ax.getSuperProperty()));
            this.axioms(AxiomType.EQUIVALENT_OBJECT_PROPERTIES).forEach(ax -> this.pairwise(map, (OWLEquivalentObjectPropertiesAxiom)ax));
            this.axioms(AxiomType.INVERSE_OBJECT_PROPERTIES).forEach(ax -> {
                this.getKeyValueASymmetric(map, ax.getFirstProperty(), ax.getSecondProperty());
                this.getKeyValueASymmetric(map, ax.getSecondProperty(), ax.getFirstProperty());
            });
            this.axioms(AxiomType.SYMMETRIC_OBJECT_PROPERTY).forEach(ax -> this.getKeyValueASymmetric(map, (OWLObjectPropertyExpression)ax.getProperty(), (OWLObjectPropertyExpression)ax.getProperty()));
            this.hierarchy.clear();
            this.hierarchy.putAll(map);
            this.hierarchyDirty = false;
        }
        return this.hierarchy;
    }

    protected void pairwise(Map<OWLObjectPropertyExpression, Set<OWLObjectPropertyExpression>> map, OWLEquivalentObjectPropertiesAxiom ax) {
        ax.walkPairwise((p1, p2) -> {
            if (!p1.equals(p2)) {
                this.getKeyValueSymmetric(map, (OWLObjectPropertyExpression)p1, (OWLObjectPropertyExpression)p2);
                this.getKeyValueSymmetric(map, (OWLObjectPropertyExpression)p2, (OWLObjectPropertyExpression)p1);
            }
            return null;
        });
    }

    protected void getKeyValueSymmetric(Map<OWLObjectPropertyExpression, Set<OWLObjectPropertyExpression>> map, OWLObjectPropertyExpression p1, OWLObjectPropertyExpression p2) {
        OWLObjectPropertyManager.getKeyValue(p1, map).add(p2);
        OWLObjectPropertyManager.getKeyValue(p1.getInverseProperty(), map).add(p2.getInverseProperty());
    }

    protected void getKeyValueASymmetric(Map<OWLObjectPropertyExpression, Set<OWLObjectPropertyExpression>> map, OWLObjectPropertyExpression p1, OWLObjectPropertyExpression p2) {
        OWLObjectPropertyManager.getKeyValue(p1, map).add(p2.getInverseProperty());
        OWLObjectPropertyManager.getKeyValue(p1.getInverseProperty(), map).add(p2);
    }

    public Map<OWLObjectPropertyExpression, Set<OWLObjectPropertyExpression>> getHierarchyReflexiveTransitiveClosure() {
        if (this.reflexiveTransitiveClosureDirty) {
            HashMap rtcMap = new HashMap();
            Map<OWLObjectPropertyExpression, Set<OWLObjectPropertyExpression>> propertyHierarchy = this.getPropertyHierarchy();
            this.getReferencedProperties().forEach(prop -> rtcMap.put(prop, OWLObjectPropertyManager.getReflexiveTransitiveClosure(prop, propertyHierarchy, new HashSet<OWLObjectPropertyExpression>(), new HashSet<OWLObjectPropertyExpression>())));
            this.reflexiveTransitiveClosure.clear();
            this.reflexiveTransitiveClosure.putAll(rtcMap);
            this.reflexiveTransitiveClosureDirty = false;
        }
        return this.reflexiveTransitiveClosure;
    }

    public boolean isSubPropertyOf(OWLObjectPropertyExpression sub, OWLObjectPropertyExpression sup) {
        OWLAPIPreconditions.checkNotNull(sub, "sub cannot be null");
        OWLAPIPreconditions.checkNotNull(sup, "sup cannot be null");
        return this.getHierarchyReflexiveTransitiveClosure().get(sub).contains(sup);
    }

    public boolean isNonSimple(OWLObjectPropertyExpression expression) {
        OWLAPIPreconditions.checkNotNull(expression, "expression cannot be null");
        return this.getNonSimpleProperties().contains(expression);
    }

    public Set<OWLObjectPropertyExpression> getNonSimpleProperties() {
        if (this.simpleDirty) {
            this.nonSimpleProperties.clear();
            Map<OWLObjectPropertyExpression, Set<OWLObjectPropertyExpression>> reflexiveTransitiveClosureMap = this.getHierarchyReflexiveTransitiveClosure();
            this.getReferencedProperties().filter(this::isComposite).forEach(prop -> {
                this.nonSimpleProperties.add((OWLObjectPropertyExpression)prop);
                this.nonSimpleProperties.addAll((Collection)reflexiveTransitiveClosureMap.get(prop));
            });
            this.nonSimpleProperties.addAll(OWLAPIStreamUtils.asList(this.nonSimpleProperties.stream().map(p -> p.getInverseProperty())));
            this.simpleDirty = false;
        }
        return this.nonSimpleProperties;
    }

    public Map<OWLObjectPropertyExpression, Set<OWLObjectPropertyExpression>> getPropertyPartialOrdering() {
        if (this.partialOrderingDirty) {
            this.partialOrdering.clear();
            HashMap<OWLObjectPropertyExpression, Set<OWLObjectPropertyExpression>> map = new HashMap<OWLObjectPropertyExpression, Set<OWLObjectPropertyExpression>>(this.getPropertyHierarchy());
            this.axioms(AxiomType.SUB_PROPERTY_CHAIN_OF).forEach(ax -> ax.getPropertyChain().forEach(p -> this.map((Map<OWLObjectPropertyExpression, Set<OWLObjectPropertyExpression>>)map, (OWLSubPropertyChainOfAxiom)ax, (OWLObjectPropertyExpression)p)));
            HashMap ordering = new HashMap();
            this.getReferencedProperties().forEach(prop -> ordering.put(prop, OWLObjectPropertyManager.getReflexiveTransitiveClosure(prop, map, new HashSet<OWLObjectPropertyExpression>(), new HashSet<OWLObjectPropertyExpression>())));
            this.partialOrdering.putAll(ordering);
            this.partialOrderingDirty = false;
        }
        return this.partialOrdering;
    }

    protected void map(Map<OWLObjectPropertyExpression, Set<OWLObjectPropertyExpression>> map, OWLSubPropertyChainOfAxiom ax, OWLObjectPropertyExpression prop) {
        map.computeIfAbsent(prop, k -> new HashSet()).add(ax.getSuperProperty());
        map.computeIfAbsent(prop.getInverseProperty(), k -> new HashSet()).add(ax.getSuperProperty().getInverseProperty());
    }

    public boolean isLessThan(OWLObjectPropertyExpression propA, OWLObjectPropertyExpression propB) {
        OWLAPIPreconditions.checkNotNull(propA, "propA cannot be null");
        OWLAPIPreconditions.checkNotNull(propB, "propB cannot be null");
        Set<OWLObjectPropertyExpression> set = this.getPropertyPartialOrdering().get(propA);
        return set != null && set.contains(propB);
    }

    private Stream<OWLObjectPropertyExpression> getReferencedProperties() {
        return this.ontologies().flatMap(HasObjectPropertiesInSignature::objectPropertiesInSignature);
    }

    public Collection<Set<OWLObjectPropertyExpression>> getEquivalentObjectProperties() {
        return OWLObjectPropertyManager.getEquivalentObjectProperties(this.ontology.importsClosure());
    }
}

