/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.utilities;

import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.lang.reflect.ParameterizedType;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Qualifier;
import javax.inject.Singleton;
import org.semanticweb.owlapi.model.OntologyConfigurator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Injector {
    private static final Logger LOGGER = LoggerFactory.getLogger(Injector.class);
    private Map<Object, List<Supplier<?>>> supplierOverrides = new ConcurrentHashMap(16, 0.75f, 1);
    private Map<Object, Class<?>> typesOverrides = new ConcurrentHashMap(16, 0.75f, 1);
    private Map<Object, List<Class<?>>> typesCache = new ConcurrentHashMap(16, 0.75f, 1);

    public Injector() {
    }

    public Injector(Injector i) {
        this.supplierOverrides.putAll(i.supplierOverrides);
        this.typesOverrides.putAll(i.typesOverrides);
        this.typesCache.putAll(i.typesCache);
    }

    public Injector bind(Class<?> t, Class<?> c, Annotation ... annotations) {
        this.typesOverrides.put(this.key(c, annotations), t);
        return this;
    }

    public Injector bindToOne(Object t, Class<?> c, Annotation ... annotations) {
        Supplier<Object> s = () -> t;
        return this.bindToOne(s, c, annotations);
    }

    public Injector bindToOne(Supplier<?> t, Class<?> c, Annotation ... annotations) {
        this.supplierOverrides.put(this.key(c, annotations), Collections.singletonList(t));
        return this;
    }

    public <T> Injector bindOneMore(T t, Class<T> c, Annotation ... annotations) {
        Supplier<Object> s = () -> t;
        return this.bindOneMore(s, c, annotations);
    }

    public <T> Injector bindOneMore(Supplier<T> t, Class<T> c, Annotation ... annotations) {
        this.supplierOverrides.computeIfAbsent(this.key(c, annotations), x -> new ArrayList()).add(t);
        return this;
    }

    protected Object key(Class<?> c, Annotation ... annotations) {
        if (annotations.length == 0) {
            return c;
        }
        return new Key().with(c, annotations);
    }

    public <T> T inject(T t) {
        LOGGER.debug("Injecting object {}", (Object)t);
        ArrayList<Object> methodsToInject = new ArrayList<Object>();
        for (Class<?> c = t.getClass(); c != null; c = c.getSuperclass()) {
            for (Method m : c.getDeclaredMethods()) {
                Inject annotation = m.getAnnotation(Inject.class);
                if (annotation == null) continue;
                methodsToInject.add(m);
            }
        }
        for (Method method : methodsToInject) {
            Parameter[] parameterTypes = method.getParameters();
            Object[] args = new Object[parameterTypes.length];
            for (int i = 0; i < parameterTypes.length; ++i) {
                Parameter arg = parameterTypes[i];
                Annotation[] qualifiers = Injector.qualifiers(arg.getAnnotations());
                if (Collection.class.isAssignableFrom(arg.getType())) {
                    Class type = (Class)((ParameterizedType)arg.getParameterizedType()).getActualTypeArguments()[0];
                    args[i] = this.load(type, qualifiers).collect(Collectors.toSet());
                    continue;
                }
                args[i] = this.load(arg.getType(), qualifiers).findAny().orElse(null);
            }
            try {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Injecting values {} on method {}.", (Object)Arrays.toString(args), (Object)method);
                }
                method.invoke(t, args);
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                LOGGER.error("Injection failed", e);
            }
        }
        return t;
    }

    private static Annotation[] qualifiers(Annotation[] anns) {
        ArrayList<Annotation> qualifiers = new ArrayList<Annotation>();
        for (Annotation a : anns) {
            if (!(a instanceof Qualifier) && a.annotationType().getAnnotation(Qualifier.class) == null) continue;
            qualifiers.add(a);
        }
        return qualifiers.toArray(new Qualifier[qualifiers.size()]);
    }

    public <T> T getImplementation(Class<T> c, Annotation ... qualifiers) {
        return this.load(c, qualifiers).findAny().orElse(null);
    }

    public <T> T getImplementation(Class<T> c, OntologyConfigurator v, Annotation ... qualifiers) {
        return new Injector(this).bindToOne(v, OntologyConfigurator.class, new Annotation[0]).getImplementation(c, qualifiers);
    }

    public <T> T getImplementation(Class<T> c, Map<Object, List<Supplier<?>>> overrides, Annotation ... qualifiers) {
        Injector i = new Injector(this);
        overrides.forEach((a, b) -> i.supplierOverrides.put(a, (List<Supplier<?>>)b));
        return i.getImplementation(c, qualifiers);
    }

    protected List<ClassLoader> classLoaders() {
        return Arrays.asList(Thread.currentThread().getContextClassLoader(), ClassLoader.getSystemClassLoader(), this.getClass().getClassLoader());
    }

    protected <T> Stream<T> load(Class<T> type, Annotation ... qualifiers) {
        Object key = this.key(type, qualifiers);
        Class<?> c = this.typesOverrides.get(key);
        if (c != null) {
            return Stream.of(type.cast(this.instantiate(c, key)));
        }
        List suppliers = this.supplierOverrides.getOrDefault(key, Collections.emptyList());
        if (!suppliers.isEmpty()) {
            return suppliers.stream().map(Supplier::get).map(type::cast);
        }
        List cached = this.typesCache.getOrDefault(key, Collections.emptyList());
        if (!cached.isEmpty()) {
            return cached.stream().map(s -> this.instantiate((Class)s, key)).map(type::cast);
        }
        String name = "META-INF/services/" + type.getName();
        LOGGER.debug("Loading file {}", (Object)name);
        return this.prepareClass(this.urls(name).flatMap(this::entries).distinct(), key, type).map(s -> this.instantiate((Class)s, key));
    }

    private static <T> Constructor<T> injectableConstructor(Class<T> c) {
        try {
            Constructor<?>[] constructors = c.getConstructors();
            if (constructors.length == 1) {
                return constructors[0];
            }
            Optional<Constructor> findAny = Arrays.stream(constructors).filter(m -> m.getAnnotation(Inject.class) != null).findAny();
            if (!findAny.isPresent()) {
                LOGGER.error("No injectable constructor found for {}", (Object)c);
            }
            return findAny.orElse(null);
        }
        catch (SecurityException e) {
            LOGGER.error("No injectable constructor found for {} because of security restrictions", (Object)c);
            LOGGER.error("Security restriction accessing constructor list", e);
            return null;
        }
    }

    private Object[] paramInstances(Parameter[] params) {
        Object[] toReturn = new Object[params.length];
        for (int i = 0; i < toReturn.length; ++i) {
            Iterator iterator = this.load(params[i].getType(), params[i].getAnnotations()).iterator();
            if (iterator.hasNext()) {
                toReturn[i] = iterator.next();
                continue;
            }
            LOGGER.error("No instantiation found for {}", (Object)params[i]);
        }
        return toReturn;
    }

    private <T> Stream<Class<T>> prepareClass(Stream<String> types, Object key, Class<T> witness) {
        List<Class<?>> l = this.typesCache.get(key);
        if (l != null) {
            return l.stream().map(x -> x);
        }
        ArrayList list = new ArrayList();
        try {
            Iterator iterator = types.iterator();
            while (iterator.hasNext()) {
                list.add(Class.forName((String)iterator.next()));
            }
            ArrayList listToCache = new ArrayList(list);
            this.typesCache.computeIfAbsent(key, x -> listToCache);
            return list.stream();
        }
        catch (ClassNotFoundException | IllegalArgumentException | SecurityException e) {
            LOGGER.error("Instantiation failed", e);
            return null;
        }
    }

    private <T> T instantiate(Class<T> s, Object key) {
        try {
            Constructor<T> c = Injector.injectableConstructor(s);
            if (c == null) {
                LOGGER.error("Instantiation failed: no constructors found for {}", (Object)s);
                return null;
            }
            Object[] paramInstances = this.paramInstances(c.getParameters());
            Object newInstance = c.newInstance(paramInstances);
            if (s.getAnnotation(Singleton.class) != null) {
                this.supplierOverrides.put(key, Collections.singletonList(() -> newInstance));
            }
            return s.cast(newInstance);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | SecurityException | InvocationTargetException e) {
            LOGGER.error("Instantiation failed", e);
            return null;
        }
    }

    private Stream<URL> urls(String name) {
        ArrayList<URL> l = new ArrayList<URL>();
        try {
            for (ClassLoader cl : this.classLoaders()) {
                if (cl == null) continue;
                Enumeration<URL> resources = cl.getResources(name);
                while (resources.hasMoreElements()) {
                    URL e = resources.nextElement();
                    l.add(e);
                    LOGGER.debug("Loading URL for service {}", (Object)e);
                }
            }
            if (l.isEmpty()) {
                LOGGER.debug("No files found for {}", (Object)name);
            }
        }
        catch (IOException e) {
            LOGGER.error("Error accessing services files", e);
        }
        return l.stream();
    }

    /*
     * Exception decompiling
     */
    private Stream<String> entries(URL c) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static class Key {
        Class<?> c;
        Annotation[] anns;
        int hash = 0;

        public boolean equals(@Nullable Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof Key)) {
                return false;
            }
            Key k = (Key)obj;
            return Objects.equals(this.c, k.c) && Arrays.equals(this.anns, k.anns);
        }

        public Key with(Class<?> cl, Annotation[] a) {
            this.c = cl;
            this.anns = a;
            this.hash = this.c.hashCode() * 37 + Arrays.hashCode(this.anns);
            return this;
        }

        public int hashCode() {
            return this.hash;
        }
    }
}

