/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapitools.builders;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Stream;
import javax.inject.Inject;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.SWRLAtom;
import org.semanticweb.owlapi.model.SWRLRule;
import org.semanticweb.owlapi.util.OWLAPIStreamUtils;
import org.semanticweb.owlapitools.builders.BaseBuilder;

public class BuilderSWRLRule
extends BaseBuilder<SWRLRule, BuilderSWRLRule> {
    private final List<SWRLAtom> body = new ArrayList<SWRLAtom>();
    private final List<SWRLAtom> head = new ArrayList<SWRLAtom>();

    public BuilderSWRLRule(SWRLRule expected, OWLDataFactory df) {
        this(df);
        this.withBody(expected.body()).withHead(expected.head()).withAnnotations(expected.annotations());
    }

    @Inject
    public BuilderSWRLRule(OWLDataFactory df) {
        super(df);
    }

    public BuilderSWRLRule withBody(SWRLAtom arg) {
        this.body.add(arg);
        return this;
    }

    public BuilderSWRLRule withHead(SWRLAtom arg) {
        this.head.add(arg);
        return this;
    }

    public BuilderSWRLRule withBody(Collection<SWRLAtom> arg) {
        this.body.addAll(arg);
        return this;
    }

    public BuilderSWRLRule withBody(Stream<SWRLAtom> arg) {
        OWLAPIStreamUtils.add(this.body, arg);
        return this;
    }

    public BuilderSWRLRule withHead(Collection<SWRLAtom> arg) {
        this.head.addAll(arg);
        return this;
    }

    public BuilderSWRLRule withHead(Stream<SWRLAtom> arg) {
        OWLAPIStreamUtils.add(this.head, arg);
        return this;
    }

    @Override
    public SWRLRule buildObject() {
        return this.df.getSWRLRule(this.body, this.head, this.annotations);
    }

    public int bodySize() {
        return this.body.size();
    }

    public int headSize() {
        return this.head.size();
    }
}

