/*
 * Decompiled with CFR 0.152.
 */
package de.jpdigital.owl.apigenerator.cli;

import de.jpdigital.owl.apigenerator.core.IriConstantsGenerationFailedExpection;
import de.jpdigital.owl.apigenerator.core.IriConstantsGenerator;
import de.jpdigital.owl.apigenerator.core.OntologyLoaderGenerationFailedException;
import de.jpdigital.owl.apigenerator.core.OntologyLoaderGenerator;
import de.jpdigital.owl.apigenerator.core.OntologyOwlApi;
import de.jpdigital.owl.apigenerator.core.RepositoryGenerationFailedException;
import de.jpdigital.owl.apigenerator.core.RepositoryGenerator;
import java.nio.file.Path;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import picocli.CommandLine;

@CommandLine.Command(name="OwlApiGeneratorCli", mixinStandardHelpOptions=true, version={"1.0.0-SNAPSHOT"}, description={"Generates an ontology specific API for an OWL ontology"})
public class OwlApiGeneratorCli
implements Callable<Integer> {
    private static final Logger LOGGER = LogManager.getFormatterLogger(OwlApiGeneratorCli.class);
    @CommandLine.Option(names={"--no-class-iris"}, negatable=true, defaultValue="true", description={"Generate IRI constants for classses?"})
    private boolean generateIriConstantsForClasses;
    @CommandLine.Option(names={"--no-obj-props-iris"}, negatable=true, defaultValue="true", description={"Generate IRI constants for object properties?"})
    private boolean generateIriConstantsForObjectProperties;
    @CommandLine.Option(names={"--no-data-props-iris"}, negatable=true, defaultValue="true", description={"Generate IRI constants for data properties?"})
    private boolean generateIriConstantsForDataProperties;
    @CommandLine.Option(names={"--no-individual-iris"}, negatable=true, defaultValue="true", description={"Generate IRI constants for individuals?"})
    private boolean generateIriConstantsForIndividuals;
    @CommandLine.Option(names={"--no-annotation-props-iris"}, negatable=true, defaultValue="true", description={"Generate IRI constants for annotation properties?"})
    private boolean generateIriConstantsForAnnotationProperties;
    @CommandLine.Option(names={"--no-repositories"}, negatable=true, defaultValue="true", description={"Generate repostories?"})
    private boolean generateRepositories;
    @CommandLine.Option(names={"--no-loader"}, negatable=true, defaultValue="true", description={"Generate OntologyLoader?"})
    private boolean generateOntologyLoader;
    @CommandLine.Parameters(index="0", description={"The output directory. The generated sources will be placed here."})
    private Path outputDirPath;
    @CommandLine.Parameters(index="1..*", description={"The ontology(ies) for which the API is generated. The files are loaded in the order they are provided. The last ontology is used as source and must import all other ontologies."})
    private List<Path> ontologyPaths;

    public static void main(String[] args) {
        int exitCode = new CommandLine(new OwlApiGeneratorCli()).execute(args);
        System.exit(exitCode);
    }

    @Override
    public Integer call() throws Exception {
        LOGGER.info("Loading ontology files...");
        LOGGER.debug("Output directory path: %s", (Object)this.outputDirPath);
        LOGGER.debug("Ontology paths: %s", (Object)this.ontologyPaths.stream().map(Path::toString).collect(Collectors.toList()));
        OntologyOwlApi ontologyOwlApi = OntologyOwlApi.loadOntologies(this.ontologyPaths);
        LOGGER.info("Generating IRI constants...");
        IriConstantsGenerator iriConstantsGenerator = IriConstantsGenerator.buildIriConstantsGenerator(ontologyOwlApi, this.outputDirPath);
        try {
            if (this.generateIriConstantsForClasses) {
                iriConstantsGenerator.generateClassIriConstants();
            }
            if (this.generateIriConstantsForObjectProperties) {
                iriConstantsGenerator.generateObjectPropertyIriConstants();
            }
            if (this.generateIriConstantsForDataProperties) {
                iriConstantsGenerator.generateDataPropertyIriConstants();
            }
            if (this.generateIriConstantsForIndividuals) {
                iriConstantsGenerator.generateIndividualPropertyIriConstants();
            }
            if (this.generateIriConstantsForAnnotationProperties) {
                iriConstantsGenerator.generateAnnotationIriConstants();
            }
        }
        catch (IriConstantsGenerationFailedExpection ex) {
            LOGGER.error("Error while generating IRI constants: ", (Throwable)ex);
            return -1;
        }
        if (this.generateRepositories) {
            LOGGER.info("Generating repositories...");
            RepositoryGenerator repositoryGenerator = RepositoryGenerator.buildRepositoryGenerator(ontologyOwlApi, this.outputDirPath);
            try {
                repositoryGenerator.generateRepositoryClasses();
            }
            catch (RepositoryGenerationFailedException ex) {
                LOGGER.error("Failed to generate repositories: ", (Throwable)ex);
            }
        }
        if (this.generateOntologyLoader) {
            LOGGER.info("Generating ontology loader...");
            OntologyLoaderGenerator ontologyLoaderGenerator = OntologyLoaderGenerator.buildDirectoryOntologyLoaderGenerator(ontologyOwlApi, this.outputDirPath);
            try {
                ontologyLoaderGenerator.generateOntologyLoader();
            }
            catch (OntologyLoaderGenerationFailedException ex) {
                LOGGER.error("Failed to generate OntologyLoaders: ", (Throwable)ex);
            }
        }
        return 0;
    }
}

