/*
 * Decompiled with CFR 0.152.
 */
package de.jpdigital.owl.apigenerator.core;

import de.jpdigital.owl.apigenerator.core.IriBundle;
import de.jpdigital.owl.apigenerator.core.IriBundleBuilder;
import de.jpdigital.owl.apigenerator.core.IriConstantsGenerationFailedExpection;
import de.jpdigital.owl.apigenerator.core.OntologyOwlApi;
import de.jpdigital.owl.apigenerator.core.OwlEntityType;
import de.jpdigital.owl.apigenerator.core.TemplateService;
import de.jpdigital.owl.apigenerator.core.UnexpectedErrorException;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.semanticweb.owlapi.model.HasIRI;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.parameters.Imports;

public class IriConstantsGenerator {
    private static final String CONSTANT_NAME = "constantName";
    private final OntologyOwlApi ontologyOwlApi;
    private final Path outputDir;

    private IriConstantsGenerator(OntologyOwlApi ontologyOwlApi, Path outputDir) {
        this.ontologyOwlApi = ontologyOwlApi;
        this.outputDir = outputDir;
    }

    public static IriConstantsGenerator buildIriConstantsGenerator(OntologyOwlApi ontologyOwlApi, Path outputDir) {
        if (!Files.isDirectory(outputDir, new LinkOption[0])) {
            throw new IllegalArgumentException(String.format("The provided path \"%s\" is not a directory.", outputDir.toString()));
        }
        if (!Files.isWritable(outputDir)) {
            throw new IllegalArgumentException(String.format("The provided output directory \"%s\" is not writable.", outputDir.toString()));
        }
        Objects.requireNonNull(ontologyOwlApi, "ontologyOwlApi can't be null");
        return new IriConstantsGenerator(ontologyOwlApi, outputDir);
    }

    public void generateClassIriConstants() throws IriConstantsGenerationFailedExpection {
        this.generateIriConstants(this.ontologyOwlApi.getOntology().classesInSignature(Imports.INCLUDED).map(owlClass -> owlClass), OwlEntityType.CLASS);
    }

    public void generateObjectPropertyIriConstants() throws IriConstantsGenerationFailedExpection {
        this.generateIriConstants(this.ontologyOwlApi.getOntology().objectPropertiesInSignature(Imports.INCLUDED).map(objProp -> objProp), OwlEntityType.OBJECT_PROPERTY);
    }

    public void generateDataPropertyIriConstants() throws IriConstantsGenerationFailedExpection {
        this.generateIriConstants(this.ontologyOwlApi.getOntology().dataPropertiesInSignature(Imports.INCLUDED).map(dataProp -> dataProp), OwlEntityType.DATA_PROPERTY);
    }

    public void generateIndividualPropertyIriConstants() throws IriConstantsGenerationFailedExpection {
        this.generateIriConstants(this.ontologyOwlApi.getOntology().individualsInSignature(Imports.INCLUDED).map(individual -> individual), OwlEntityType.INDIVIDUAL);
    }

    public void generateAnnotationIriConstants() throws IriConstantsGenerationFailedExpection {
        this.generateIriConstants(this.ontologyOwlApi.getOntology().annotationPropertiesInSignature(Imports.INCLUDED).map(annotation -> annotation), OwlEntityType.ANNOTIATION_PROPERTY);
    }

    private void generateIriConstants(Stream<HasIRI> hasIris, OwlEntityType entityType) throws IriConstantsGenerationFailedExpection {
        Set iriSet = hasIris.map(hasIri -> hasIri.getIRI()).filter(iri -> !iri.toString().startsWith("http://www.w3.org/")).collect(Collectors.toSet());
        HashMap<String, IriBundle> iriBundles = new HashMap<String, IriBundle>();
        for (IRI iri2 : iriSet) {
            IriBundle iriBundle;
            String namespace = iri2.getNamespace();
            if (iriBundles.containsKey(namespace)) {
                iriBundle = (IriBundle)iriBundles.get(namespace);
            } else {
                IriBundleBuilder builder = new IriBundleBuilder(iri2, entityType);
                iriBundle = builder.build();
                iriBundles.put(namespace, iriBundle);
            }
            iriBundle.addIri(iri2);
        }
        for (IriBundle iriBundle : iriBundles.values()) {
            this.writeConstantsFile(iriBundle);
        }
    }

    private void writeConstantsFile(IriBundle iriBundle) throws IriConstantsGenerationFailedExpection {
        HashMap<String, Object> dataModel = new HashMap<String, Object>();
        dataModel.put("license", "");
        dataModel.put("package", iriBundle.getPackageName());
        dataModel.put("baseIri", iriBundle.getNamespace());
        dataModel.put("className", iriBundle.getClassName());
        List<Map<String, String>> constants = iriBundle.getIris().stream().map(iri -> this.generateIriConstant((IRI)iri)).collect(Collectors.toList());
        this.preventDuplicateConstantNames(constants);
        dataModel.put("iris", constants);
        TemplateService templateService = TemplateService.getTemplateService();
        String result = templateService.processTemplate("Iris.java.ftl", dataModel);
        Path packageDir = this.outputDir.resolve(iriBundle.getPackagePath());
        Path classFile = packageDir.resolve(String.format("%s.java", iriBundle.getClassName()));
        try {
            Files.createDirectories(packageDir, new FileAttribute[0]);
            Files.write(classFile, result.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
        }
        catch (IOException ex) {
            throw new UnexpectedErrorException(ex);
        }
    }

    private Map<String, String> generateIriConstant(IRI iri) {
        HashMap<String, String> constant = new HashMap<String, String>();
        String iriString = iri.getIRIString();
        String constantName = this.ensureCamelCase(iri.getFragment().replace("-", "")).replaceAll("(.)([\\p{Lu}])", "$1_$2").toUpperCase(Locale.ROOT);
        constant.put(CONSTANT_NAME, constantName);
        constant.put("value", iriString);
        return constant;
    }

    private String ensureCamelCase(String name) {
        Matcher matcher = Pattern.compile("([A-Z])([A-Z]*)([A-Z])").matcher(name);
        int last = 0;
        StringBuilder builder = new StringBuilder();
        while (matcher.find()) {
            builder.append(name.substring(last, matcher.start()));
            builder.append(matcher.group(1));
            builder.append(matcher.group(2).toLowerCase(Locale.ROOT));
            builder.append(matcher.group(3));
            last = matcher.end();
        }
        builder.append(name.substring(last));
        return builder.toString();
    }

    private void preventDuplicateConstantNames(List<Map<String, String>> constants) {
        HashMap<String, Integer> nameCount = new HashMap<String, Integer>();
        for (Map<String, String> constant : constants) {
            if (nameCount.containsKey(constant.get(CONSTANT_NAME))) {
                int count = (Integer)nameCount.get(constant.get(CONSTANT_NAME)) + 1;
                nameCount.put(constant.get(CONSTANT_NAME), count);
                String constantName = constant.get(CONSTANT_NAME);
                constant.put(CONSTANT_NAME, String.format("%s%d", constantName, count));
                continue;
            }
            nameCount.put(constant.get(CONSTANT_NAME), 1);
        }
    }
}

