/*
 * Decompiled with CFR 0.152.
 */
package de.jpdigital.owl.apigenerator.core;

import de.jpdigital.owl.apigenerator.core.OntologyLoadingException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import openllet.owlapi.OpenlletReasonerFactory;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.semanticweb.owlapi.apibinding.OWLManager;
import org.semanticweb.owlapi.model.OWLAnnotationProperty;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyCreationException;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.semanticweb.owlapi.model.parameters.Imports;
import org.semanticweb.owlapi.reasoner.OWLReasoner;

public class OntologyOwlApi {
    private static final Logger LOGGER = LogManager.getLogger(OntologyOwlApi.class);
    private final OWLOntology ontology;
    private final List<OWLOntology> loadedOntologies;
    private final OWLOntologyManager ontologyManager;
    private final OWLReasoner reasoner;

    public OntologyOwlApi(OWLOntology ontology, List<OWLOntology> loadedOntologies, OWLOntologyManager ontologyManager, OWLReasoner reasoner) {
        this.ontology = ontology;
        this.loadedOntologies = loadedOntologies;
        this.ontologyManager = ontologyManager;
        this.reasoner = reasoner;
    }

    public static OntologyOwlApi loadOntologies(String[] ontologyFiles) throws OntologyLoadingException {
        List<Path> ontologyFilePaths = Arrays.asList(ontologyFiles).stream().map(path -> Paths.get(path, new String[0])).collect(Collectors.toList());
        return OntologyOwlApi.loadOntologies(ontologyFilePaths);
    }

    public static OntologyOwlApi loadOntologies(List<Path> ontologyFiles) throws OntologyLoadingException {
        LOGGER.info("Trying to load ontologies from these paths: {}...", (Object)ontologyFiles.stream().map(Path::toString).collect(Collectors.toList()));
        for (Path path : ontologyFiles) {
            LOGGER.info("Trying to load ontology from path {}...", (Object)path.toAbsolutePath().toString());
            if (!Files.exists(path, new LinkOption[0])) {
                throw new OntologyLoadingException(String.format("Ontology file %s does not exist.", path.toAbsolutePath().toString()));
            }
            if (Files.isReadable(path)) continue;
            throw new OntologyLoadingException(String.format("Ontology file %s is not readable.", path.toAbsolutePath().toString()));
        }
        OWLOntologyManager ontologyManager = OWLManager.createConcurrentOWLOntologyManager();
        ArrayList<OWLOntology> ontologies = new ArrayList<OWLOntology>();
        for (Path file : ontologyFiles) {
            OWLOntology ontology;
            try (InputStream inputStream = Files.newInputStream(file, new OpenOption[0]);){
                ontology = ontologyManager.loadOntologyFromOntologyDocument(Objects.requireNonNull(inputStream, String.format("Failed to load ontology file %s.", file.toAbsolutePath().toString())));
            }
            catch (IOException | OWLOntologyCreationException ex) {
                throw new OntologyLoadingException(ex);
            }
            ontologies.add(ontology);
        }
        OWLOntology ontology = (OWLOntology)ontologies.get(ontologies.size() - 1);
        OpenlletReasonerFactory reasonerFactory = new OpenlletReasonerFactory();
        OWLReasoner reasoner = reasonerFactory.createReasoner(ontology);
        return new OntologyOwlApi(ontology, ontologies, ontologyManager, reasoner);
    }

    public OWLOntology getOntology() {
        return this.ontology;
    }

    public List<OWLOntology> getLoadedOntologies() {
        return Collections.unmodifiableList(this.loadedOntologies);
    }

    public OWLOntologyManager getOntologyManager() {
        return this.ontologyManager;
    }

    public OWLReasoner getReasoner() {
        return this.reasoner;
    }

    public List<OWLClass> getAllClasses() {
        return this.ontology.classesInSignature(Imports.INCLUDED).collect(Collectors.toList());
    }

    public List<OWLObjectProperty> getAllObjectProperties() {
        return this.ontology.objectPropertiesInSignature(Imports.INCLUDED).collect(Collectors.toList());
    }

    public List<OWLDataProperty> getAllDataProperties() {
        return this.ontology.dataPropertiesInSignature(Imports.INCLUDED).collect(Collectors.toList());
    }

    public List<OWLNamedIndividual> getAllIndividuals() {
        return this.ontology.individualsInSignature(Imports.INCLUDED).collect(Collectors.toList());
    }

    public List<OWLAnnotationProperty> getAllAnnotationProperties() {
        return this.ontology.annotationPropertiesInSignature(Imports.INCLUDED).collect(Collectors.toList());
    }
}

