/*
 * Decompiled with CFR 0.152.
 */
package openllet.aterm.pure;

import java.util.List;
import openllet.aterm.AFun;
import openllet.aterm.ATerm;
import openllet.aterm.ATermAppl;
import openllet.aterm.ATermList;
import openllet.aterm.ATermPlaceholder;
import openllet.aterm.Visitor;
import openllet.aterm.pure.ATermImpl;
import openllet.aterm.pure.PureFactory;
import openllet.atom.OpenError;
import openllet.shared.hash.HashFunctions;
import openllet.shared.hash.SharedObject;

public class ATermPlaceholderImpl
extends ATermImpl
implements ATermPlaceholder {
    private final ATerm _type;

    protected ATermPlaceholderImpl(PureFactory factory, ATerm type) {
        super(factory);
        this._type = type;
        this.setHashCode(HashFunctions.doobs(new Object[]{type}));
    }

    @Override
    public int getType() {
        return 5;
    }

    @Override
    public SharedObject duplicate() {
        return this;
    }

    @Override
    public boolean equivalent(SharedObject obj) {
        if (obj instanceof ATermPlaceholder) {
            ATermPlaceholder peer = (ATermPlaceholder)((Object)obj);
            if (peer.getType() != this.getType()) {
                return false;
            }
            return peer.getPlaceholder() == this._type;
        }
        return false;
    }

    @Override
    public boolean match(ATerm pattern, List<Object> list) {
        ATermAppl appl;
        AFun afun;
        ATerm t;
        if (pattern.getType() == 5 && (t = ((ATermPlaceholder)pattern).getPlaceholder()).getType() == 1 && (afun = (appl = (ATermAppl)t).getAFun()).getName().equals("placeholder") && afun.getArity() == 0 && !afun.isQuoted()) {
            list.add(t);
            return true;
        }
        return super.match(pattern, list);
    }

    @Override
    public ATerm make(List<Object> args) {
        ATermAppl appl = (ATermAppl)this._type;
        AFun fun = appl.getAFun();
        String name = fun.getName();
        if (!fun.isQuoted()) {
            if (fun.getArity() == 0) {
                switch (name) {
                    case "term": {
                        ATerm t = (ATerm)args.get(0);
                        args.remove(0);
                        return t;
                    }
                    case "list": {
                        ATermList l = (ATermList)args.get(0);
                        args.remove(0);
                        return l;
                    }
                    case "bool": {
                        Boolean b = (Boolean)args.get(0);
                        args.remove(0);
                        return this._factory.makeAppl(this._factory.makeAFun(b.toString(), 0, false));
                    }
                    case "int": {
                        Integer i = (Integer)args.get(0);
                        args.remove(0);
                        return this._factory.makeInt(i);
                    }
                    case "real": {
                        Double d = (Double)args.get(0);
                        args.remove(0);
                        return this._factory.makeReal(d);
                    }
                    case "blob": {
                        byte[] data = (byte[])args.get(0);
                        args.remove(0);
                        return this._factory.makeBlob(data);
                    }
                    case "placeholder": {
                        ATerm t = (ATerm)args.get(0);
                        args.remove(0);
                        return this._factory.makePlaceholder(t);
                    }
                    case "str": {
                        String str = (String)args.get(0);
                        args.remove(0);
                        return this._factory.makeAppl(this._factory.makeAFun(str, 0, true));
                    }
                    case "id": {
                        String str = (String)args.get(0);
                        args.remove(0);
                        return this._factory.makeAppl(this._factory.makeAFun(str, 0, false));
                    }
                    case "fun": {
                        String str = (String)args.get(0);
                        args.remove(0);
                        return this._factory.makeAppl(this._factory.makeAFun(str, 0, false));
                    }
                }
                throw new OpenError("Unknow ATerm function name : " + name);
            }
            if ("appl".equals(name)) {
                ATermList oldargs = appl.getArguments();
                String newname = (String)args.get(0);
                args.remove(0);
                ATermList newargs = (ATermList)oldargs.make(args);
                AFun newfun = this._factory.makeAFun(newname, newargs.getLength(), false);
                return this._factory.makeApplList(newfun, newargs);
            }
        }
        throw new OpenError("illegal pattern: " + this);
    }

    @Override
    public ATerm getPlaceholder() {
        return this._type;
    }

    public ATerm setPlaceholder(ATerm newtype) {
        return this.getPureFactory().makePlaceholder(newtype);
    }

    @Override
    public ATerm accept(Visitor<ATerm> v) {
        return v.visitPlaceholder(this);
    }

    @Override
    public int getNrSubTerms() {
        return 1;
    }

    @Override
    public ATerm getSubTerm(int index) {
        return this._type;
    }

    @Override
    public ATerm setSubTerm(int index, ATerm t) {
        if (index == 1) {
            return this.setPlaceholder(t);
        }
        throw new OpenError("no " + index + "-th child!");
    }
}

