/*
 * Decompiled with CFR 0.152.
 */
package openllet.aterm.pure;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import openllet.aterm.AFun;
import openllet.aterm.ATerm;
import openllet.aterm.ATermAppl;
import openllet.aterm.ATermBlob;
import openllet.aterm.ATermFactory;
import openllet.aterm.ATermInt;
import openllet.aterm.ATermList;
import openllet.aterm.ATermLong;
import openllet.aterm.ATermPlaceholder;
import openllet.aterm.ATermReal;
import openllet.aterm.ParseError;
import openllet.aterm.pure.AFunImpl;
import openllet.aterm.pure.ATermApplImpl;
import openllet.aterm.pure.ATermBlobImpl;
import openllet.aterm.pure.ATermIntImpl;
import openllet.aterm.pure.ATermListImpl;
import openllet.aterm.pure.ATermLongImpl;
import openllet.aterm.pure.ATermPlaceholderImpl;
import openllet.aterm.pure.ATermReader;
import openllet.aterm.pure.ATermRealImpl;
import openllet.aterm.pure.binary.BAFReader;
import openllet.aterm.pure.binary.BinaryReader;
import openllet.aterm.pure.owl.FunAll;
import openllet.aterm.pure.owl.FunAllDifferent;
import openllet.aterm.pure.owl.FunAnd;
import openllet.aterm.pure.owl.FunAsymmetric;
import openllet.aterm.pure.owl.FunBottomDataProperty;
import openllet.aterm.pure.owl.FunBottomObjectProperty;
import openllet.aterm.pure.owl.FunBuiltin;
import openllet.aterm.pure.owl.FunCard;
import openllet.aterm.pure.owl.FunComplementOf;
import openllet.aterm.pure.owl.FunDatatypeDefinition;
import openllet.aterm.pure.owl.FunDifferent;
import openllet.aterm.pure.owl.FunDisjointClasses;
import openllet.aterm.pure.owl.FunDisjointProperties;
import openllet.aterm.pure.owl.FunDisjointPropertyWith;
import openllet.aterm.pure.owl.FunDisjointWith;
import openllet.aterm.pure.owl.FunDomain;
import openllet.aterm.pure.owl.FunEmpty;
import openllet.aterm.pure.owl.FunEquivalentClasses;
import openllet.aterm.pure.owl.FunEquivalentProperty;
import openllet.aterm.pure.owl.FunFacet;
import openllet.aterm.pure.owl.FunFunctionnal;
import openllet.aterm.pure.owl.FunInv;
import openllet.aterm.pure.owl.FunInverseFunctional;
import openllet.aterm.pure.owl.FunInverseProperty;
import openllet.aterm.pure.owl.FunIrreflexive;
import openllet.aterm.pure.owl.FunLiteral;
import openllet.aterm.pure.owl.FunMax;
import openllet.aterm.pure.owl.FunMin;
import openllet.aterm.pure.owl.FunNot;
import openllet.aterm.pure.owl.FunOr;
import openllet.aterm.pure.owl.FunProp;
import openllet.aterm.pure.owl.FunRange;
import openllet.aterm.pure.owl.FunReflexive;
import openllet.aterm.pure.owl.FunRestrictedDatatype;
import openllet.aterm.pure.owl.FunRule;
import openllet.aterm.pure.owl.FunSameAs;
import openllet.aterm.pure.owl.FunSelf;
import openllet.aterm.pure.owl.FunSome;
import openllet.aterm.pure.owl.FunSubClassOf;
import openllet.aterm.pure.owl.FunSubProperty;
import openllet.aterm.pure.owl.FunSymmetric;
import openllet.aterm.pure.owl.FunTop;
import openllet.aterm.pure.owl.FunTopDataProperty;
import openllet.aterm.pure.owl.FunTopObjectProperty;
import openllet.aterm.pure.owl.FunTransitive;
import openllet.aterm.pure.owl.FunType;
import openllet.aterm.pure.owl.FunValue;
import openllet.aterm.pure.owl.FunVar;
import openllet.atom.OpenError;
import openllet.shared.hash.SharedObject;
import openllet.shared.hash.SharedObjectFactory;

public class PureFactory
extends SharedObjectFactory
implements ATermFactory {
    public static final int FIX_POINT = 240146486;
    private final ATermList _empty;
    private static ATerm[] array0 = new ATerm[0];

    private static boolean isBase64(int c) {
        return Character.isLetterOrDigit(c) || c == 43 || c == 47;
    }

    public static int abbrevSize(int strTerm) {
        int abbrev;
        int size = 1;
        if (abbrev == 0) {
            return 2;
        }
        for (abbrev = strTerm; abbrev > 0; abbrev /= 64) {
            ++size;
        }
        return size;
    }

    public PureFactory() {
        ATermListImpl protoList = new ATermListImpl(this);
        protoList.init(240146486, null, null);
        this._empty = this.build(protoList);
        ((ATermListImpl)this._empty).init(240146486, null, null);
    }

    @Override
    public ATermList makeList() {
        return this._empty;
    }

    @Override
    public ATermList makeList(ATerm singleton) {
        return this.makeList(singleton, this._empty);
    }

    @Override
    public AFun makeAFun(String name, int arity, boolean isQuoted) {
        return this.build(new AFunImpl(this, name, arity, isQuoted));
    }

    @Override
    public ATermInt makeInt(int value) {
        return this.build(new ATermIntImpl(this, value));
    }

    @Override
    public ATermLong makeLong(long value) {
        return this.build(new ATermLongImpl(this, value));
    }

    @Override
    public ATermReal makeReal(double value) {
        return this.build(new ATermRealImpl(this, value));
    }

    @Override
    public ATermPlaceholder makePlaceholder(ATerm type) {
        return this.build(new ATermPlaceholderImpl(this, type));
    }

    @Override
    public ATermBlob makeBlob(byte[] data) {
        return this.build(new ATermBlobImpl(this, data));
    }

    @Override
    public ATermList makeList(ATerm first, ATermList next) {
        return this.build(new ATermListImpl(this, first, next));
    }

    @Override
    public ATermAppl makeAppl(AFun fun, ATerm[] args) {
        return this.build(new ATermApplImpl(this, fun, args));
    }

    @Override
    public ATermAppl makeApplList(AFun fun, ATermList list) {
        ATerm[] arg_array = new ATerm[list.getLength()];
        int i = 0;
        for (ATerm term : list) {
            arg_array[i++] = term;
        }
        return this.makeAppl(fun, arg_array);
    }

    @Override
    public ATermAppl makeAppl(AFun fun) {
        return this.makeAppl(fun, array0);
    }

    @Override
    public ATermAppl makeAppl(AFun fun, ATerm arg) {
        ATerm[] argarray1 = new ATerm[]{arg};
        return this.makeAppl(fun, argarray1);
    }

    @Override
    public ATermAppl makeAppl(AFun fun, ATerm arg1, ATerm arg2) {
        ATerm[] argarray2 = new ATerm[]{arg1, arg2};
        return this.makeAppl(fun, argarray2);
    }

    @Override
    public ATermAppl makeAppl(AFun fun, ATerm arg1, ATerm arg2, ATerm arg3) {
        ATerm[] argarray3 = new ATerm[]{arg1, arg2, arg3};
        return this.makeAppl(fun, argarray3);
    }

    @Override
    public ATermAppl makeAppl(AFun fun, ATerm arg1, ATerm arg2, ATerm arg3, ATerm arg4) {
        ATerm[] argarray4 = new ATerm[]{arg1, arg2, arg3, arg4};
        return this.makeAppl(fun, argarray4);
    }

    @Override
    public ATermAppl makeAppl(AFun fun, ATerm arg1, ATerm arg2, ATerm arg3, ATerm arg4, ATerm arg5) {
        ATerm[] argarray5 = new ATerm[]{arg1, arg2, arg3, arg4, arg5};
        return this.makeAppl(fun, argarray5);
    }

    @Override
    public ATermAppl makeAppl(AFun fun, ATerm arg1, ATerm arg2, ATerm arg3, ATerm arg4, ATerm arg5, ATerm arg6) {
        ATerm[] args = new ATerm[]{arg1, arg2, arg3, arg4, arg5, arg6};
        return this.makeAppl(fun, args);
    }

    public ATermAppl makeAppl(AFun fun, ATerm arg1, ATerm arg2, ATerm arg3, ATerm arg4, ATerm arg5, ATerm arg6, ATerm arg7) {
        ATerm[] args = new ATerm[]{arg1, arg2, arg3, arg4, arg5, arg6, arg7};
        return this.makeAppl(fun, args);
    }

    public ATermList getEmpty() {
        return this._empty;
    }

    private static ATerm parseAbbrev(ATermReader reader) throws IOException {
        int c = reader.read();
        int abbrev = 0;
        while (PureFactory.isBase64(c)) {
            abbrev *= 64;
            if (c >= 65 && c <= 90) {
                abbrev += c - 65;
            } else if (c >= 97 && c <= 122) {
                abbrev += c - 97 + 26;
            } else if (c >= 48 && c <= 57) {
                abbrev += c - 48 + 52;
            } else if (c == 43) {
                abbrev += 62;
            } else if (c == 47) {
                abbrev += 63;
            } else {
                throw new OpenError("not a base-64 digit: " + c);
            }
            c = reader.read();
        }
        ATerm result = reader.getTerm(abbrev);
        return result;
    }

    private ATerm parseNumber(ATermReader reader) throws IOException {
        ATerm result;
        StringBuilder str = new StringBuilder();
        do {
            str.append((char)reader.getLastChar());
        } while (Character.isDigit(reader.read()));
        if (reader.getLastChar() != 46 && reader.getLastChar() != 101 && reader.getLastChar() != 69 && reader.getLastChar() != 108 && reader.getLastChar() != 76) {
            int val;
            try {
                val = Integer.parseInt(str.toString());
            }
            catch (NumberFormatException e) {
                throw new ParseError("malformed int", e);
            }
            result = this.makeInt(val);
        } else if (reader.getLastChar() == 108 || reader.getLastChar() == 76) {
            long val;
            reader.read();
            try {
                val = Long.parseLong(str.toString());
            }
            catch (NumberFormatException e) {
                throw new ParseError("malformed long", e);
            }
            result = this.makeLong(val);
        } else {
            double val;
            if (reader.getLastChar() == 46) {
                str.append('.');
                reader.read();
                if (!Character.isDigit(reader.getLastChar())) {
                    throw new ParseError("digit expected");
                }
                do {
                    str.append((char)reader.getLastChar());
                } while (Character.isDigit(reader.read()));
            }
            if (reader.getLastChar() == 101 || reader.getLastChar() == 69) {
                str.append((char)reader.getLastChar());
                reader.read();
                if (reader.getLastChar() == 45 || reader.getLastChar() == 43) {
                    str.append((char)reader.getLastChar());
                    reader.read();
                }
                if (!Character.isDigit(reader.getLastChar())) {
                    throw new ParseError("digit expected!");
                }
                do {
                    str.append((char)reader.getLastChar());
                } while (Character.isDigit(reader.read()));
            }
            try {
                val = Double.valueOf(str.toString());
            }
            catch (NumberFormatException e) {
                throw new ParseError("malformed real", e);
            }
            result = this.makeReal(val);
        }
        return result;
    }

    private static String parseId(ATermReader reader) throws IOException {
        int c = reader.getLastChar();
        StringBuilder buf = new StringBuilder(32);
        do {
            buf.append((char)c);
        } while (Character.isLetterOrDigit(c = reader.read()) || c == 95 || c == 45 || c == 43 || c == 42 || c == 36);
        return buf.toString();
    }

    private String parseString(ATermReader reader) throws IOException {
        boolean escaped;
        StringBuilder str = new StringBuilder();
        do {
            int lastChar;
            escaped = false;
            if (reader.read() == 92) {
                reader.read();
                escaped = true;
            }
            if ((lastChar = reader.getLastChar()) == -1) {
                throw new ParseError("Unterminated quoted function symbol: " + str);
            }
            if (escaped) {
                switch (lastChar) {
                    case 110: {
                        str.append('\n');
                        break;
                    }
                    case 116: {
                        str.append('\t');
                        break;
                    }
                    case 98: {
                        str.append('\b');
                        break;
                    }
                    case 114: {
                        str.append('\r');
                        break;
                    }
                    case 102: {
                        str.append('\f');
                        break;
                    }
                    case 92: {
                        str.append('\\');
                        break;
                    }
                    case 39: {
                        str.append('\'');
                        break;
                    }
                    case 34: {
                        str.append('\"');
                        break;
                    }
                    case 48: 
                    case 49: 
                    case 50: 
                    case 51: 
                    case 52: 
                    case 53: 
                    case 54: 
                    case 55: {
                        str.append(reader.readOct());
                        break;
                    }
                    default: {
                        str.append('\\').append((char)reader.getLastChar());
                        break;
                    }
                }
                continue;
            }
            if (lastChar == 34) continue;
            str.append((char)lastChar);
        } while (escaped || reader.getLastChar() != 34);
        return str.toString();
    }

    private ATermList parseATerms(ATermReader reader) throws IOException {
        ATerm[] terms = this.parseATermsArray(reader);
        ATermList result = this._empty;
        for (int i = terms.length - 1; i >= 0; --i) {
            result = this.makeList(terms[i], result);
        }
        return result;
    }

    private ATerm[] parseATermsArray(ATermReader reader) throws IOException {
        ArrayList<ATerm> list = new ArrayList<ATerm>();
        ATerm term = this.parseFromReader(reader);
        list.add(term);
        while (reader.getLastChar() == 44) {
            reader.readSkippingWS();
            term = this.parseFromReader(reader);
            list.add(term);
        }
        ATerm[] array = new ATerm[list.size()];
        ListIterator iter = list.listIterator();
        int index = 0;
        while (iter.hasNext()) {
            array[index++] = (ATerm)iter.next();
        }
        return array;
    }

    private ATerm parseFromReader(ATermReader reader) throws IOException {
        ATerm result;
        int start = reader.getPosition();
        switch (reader.getLastChar()) {
            case -1: {
                throw new ParseError("premature EOF encountered.");
            }
            case 35: {
                return PureFactory.parseAbbrev(reader);
            }
            case 91: {
                int c = reader.readSkippingWS();
                if (c == -1) {
                    throw new ParseError("premature EOF encountered.");
                }
                if (c == 93) {
                    c = reader.readSkippingWS();
                    result = this._empty;
                    break;
                }
                result = this.parseATerms(reader);
                if (reader.getLastChar() != 93) {
                    throw new ParseError("expected ']' but got '" + (char)reader.getLastChar() + "'");
                }
                c = reader.readSkippingWS();
                break;
            }
            case 60: {
                int c = reader.readSkippingWS();
                ATerm ph = this.parseFromReader(reader);
                if (reader.getLastChar() != 62) {
                    throw new ParseError("expected '>' but got '" + (char)reader.getLastChar() + "'");
                }
                c = reader.readSkippingWS();
                result = this.makePlaceholder(ph);
                break;
            }
            case 34: {
                String funname = this.parseString(reader);
                int c = reader.readSkippingWS();
                if (reader.getLastChar() == 40) {
                    c = reader.readSkippingWS();
                    if (c == -1) {
                        throw new ParseError("premature EOF encountered.");
                    }
                    if (reader.getLastChar() == 41) {
                        result = this.makeAppl(this.makeAFun(funname, 0, true));
                    } else {
                        ATerm[] list = this.parseATermsArray(reader);
                        if (reader.getLastChar() != 41) {
                            throw new ParseError("_expected ')' but got '" + reader.getLastChar() + "'");
                        }
                        result = this.makeAppl(this.makeAFun(funname, list.length, true), list);
                    }
                    c = reader.readSkippingWS();
                    break;
                }
                result = this.makeAppl(this.makeAFun(funname, 0, true));
                break;
            }
            case 40: {
                int c = reader.readSkippingWS();
                if (c == -1) {
                    throw new ParseError("premature EOF encountered.");
                }
                if (reader.getLastChar() == 41) {
                    result = this.makeAppl(this.makeAFun("", 0, false));
                } else {
                    ATerm[] list = this.parseATermsArray(reader);
                    if (reader.getLastChar() != 41) {
                        throw new ParseError("_expected ')' but got '" + (char)reader.getLastChar() + "'");
                    }
                    result = this.makeAppl(this.makeAFun("", list.length, false), list);
                }
                c = reader.readSkippingWS();
                break;
            }
            case 45: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: {
                result = this.parseNumber(reader);
                int c = reader.skipWS();
                break;
            }
            default: {
                int c = reader.getLastChar();
                if (Character.isLetter(c)) {
                    String funname = PureFactory.parseId(reader);
                    c = reader.skipWS();
                    if (reader.getLastChar() == 40) {
                        c = reader.readSkippingWS();
                        if (c == -1) {
                            throw new ParseError("premature EOF encountered.");
                        }
                        if (reader.getLastChar() == 41) {
                            result = this.makeAppl(this.makeAFun(funname, 0, false));
                        } else {
                            ATerm[] list = this.parseATermsArray(reader);
                            if (reader.getLastChar() != 41) {
                                throw new ParseError("_expected ')' but got '" + (char)reader.getLastChar() + "'");
                            }
                            result = this.makeAppl(this.makeAFun(funname, list.length, false), list);
                        }
                        c = reader.readSkippingWS();
                        break;
                    }
                    result = this.makeAppl(this.makeAFun(funname, 0, false));
                    break;
                }
                throw new ParseError("illegal character: '" + (char)reader.getLastChar() + "'");
            }
        }
        if (reader.getLastChar() == 123) {
            if (reader.readSkippingWS() == 125) {
                reader.readSkippingWS();
            } else {
                if (reader.getLastChar() != 125) {
                    throw new ParseError("'}' _expected '" + (char)reader.getLastChar() + "'");
                }
                reader.readSkippingWS();
            }
        }
        if (reader.getLastChar() == 58) {
            reader.read();
        }
        if (reader.getLastChar() == 63) {
            reader.readSkippingWS();
        }
        int end = reader.getPosition();
        reader.storeNextTerm(result, end - start);
        return result;
    }

    @Override
    public ATerm parse(String trm) {
        try {
            ATermReader reader = new ATermReader(new StringReader(trm), trm.length());
            reader.readSkippingWS();
            ATerm result = this.parseFromReader(reader);
            return result;
        }
        catch (IOException e) {
            throw new ParseError("premature end of string", e);
        }
    }

    @Override
    public ATerm make(String trm) {
        return this.parse(trm);
    }

    @Override
    public ATerm make(String pattern, List<Object> args) {
        return this.make(this.parse(pattern), args);
    }

    @Override
    public ATerm make(String pattern, Object arg1) {
        LinkedList<Object> args = new LinkedList<Object>();
        args.add(arg1);
        return this.make(pattern, args);
    }

    @Override
    public ATerm make(String pattern, Object arg1, Object arg2) {
        LinkedList<Object> args = new LinkedList<Object>();
        args.add(arg1);
        args.add(arg2);
        return this.make(pattern, args);
    }

    @Override
    public ATerm make(String pattern, Object arg1, Object arg2, Object arg3) {
        LinkedList<Object> args = new LinkedList<Object>();
        args.add(arg1);
        args.add(arg2);
        args.add(arg3);
        return this.make(pattern, args);
    }

    @Override
    public ATerm make(ATerm pattern, List<Object> args) {
        return pattern.make(args);
    }

    public ATerm parsePattern(String pattern) throws ParseError {
        return this.parse(pattern);
    }

    protected boolean isDeepEqual(ATerm t1, ATerm t2) {
        if (t1.getType() != t2.getType()) {
            return false;
        }
        throw new UnsupportedOperationException("Not yet implemented! " + t1 + ", " + t2);
    }

    private ATerm readFromSharedTextFile(ATermReader reader) throws IOException {
        reader.initializeSharing();
        return this.parseFromReader(reader);
    }

    private ATerm readFromTextFile(ATermReader reader) throws IOException {
        return this.parseFromReader(reader);
    }

    @Override
    public ATerm readFromTextFile(InputStream stream) throws IOException {
        ATermReader reader = new ATermReader(new BufferedReader(new InputStreamReader(stream)));
        reader.readSkippingWS();
        return this.readFromTextFile(reader);
    }

    @Override
    public ATerm readFromSharedTextFile(InputStream stream) throws IOException {
        ATermReader reader = new ATermReader(new BufferedReader(new InputStreamReader(stream)));
        reader.readSkippingWS();
        if (reader.getLastChar() != 33) {
            throw new IOException("not a openllet.shared.hash text file!");
        }
        reader.readSkippingWS();
        return this.readFromSharedTextFile(reader);
    }

    @Override
    public ATerm readFromBinaryFile(InputStream stream) throws IOException {
        return this.readFromBinaryFile(stream, false);
    }

    private ATerm readFromBinaryFile(InputStream stream, boolean headerRead) throws ParseError, IOException {
        BAFReader r = new BAFReader(this, stream);
        return r.readFromBinaryFile(headerRead);
    }

    private ATerm readSAFFromOldStyleStream(InputStream stream) throws IOException {
        int nrOfBytesRead;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        byte[] buffer = new byte[4096];
        while ((nrOfBytesRead = stream.read(buffer, 0, buffer.length)) != -1) {
            baos.write(buffer, 0, nrOfBytesRead);
        }
        return BinaryReader.readTermFromSAFString(this, baos.toByteArray());
    }

    @Override
    public ATerm readFromFile(InputStream stream) throws IOException {
        int firstToken;
        do {
            if ((firstToken = stream.read()) != -1) continue;
            throw new IOException("Premature EOF.");
        } while (Character.isWhitespace((char)firstToken));
        char typeByte = (char)firstToken;
        switch (typeByte) {
            case '!': {
                ATermReader reader = new ATermReader(new BufferedReader(new InputStreamReader(stream)));
                reader.readSkippingWS();
                return this.readFromSharedTextFile(reader);
            }
            case '?': {
                return this.readSAFFromOldStyleStream(stream);
            }
            case '-': 
            case '[': 
            case '_': {
                return this.readShiftFromFile(stream, typeByte);
            }
        }
        if (Character.isLetterOrDigit(typeByte)) {
            return this.readShiftFromFile(stream, typeByte);
        }
        if (firstToken == 0) {
            try (BufferedInputStream bis = new BufferedInputStream(stream);){
                if (BAFReader.isBinaryATerm(bis)) {
                    ATerm aTerm = this.readFromBinaryFile(bis, true);
                    return aTerm;
                }
            }
        }
        throw new OpenError("Unsupported file type : " + typeByte);
    }

    private ATerm readShiftFromFile(InputStream stream, char typeByte) throws IOException {
        try (BufferedReader buffer = new BufferedReader(new InputStreamReader(stream));){
            ATermReader reader = new ATermReader(buffer);
            reader.last_char = typeByte;
            ATerm aTerm = this.readFromTextFile(reader);
            return aTerm;
        }
    }

    @Override
    public ATerm readFromFile(String filename) throws IOException {
        try (FileInputStream fis = new FileInputStream(filename);){
            ATerm aTerm = this.readFromFile(fis);
            return aTerm;
        }
    }

    @Override
    public ATerm importTerm(ATerm term) {
        ATerm result;
        SharedObject object = (SharedObject)((Object)term);
        if (this.contains(object)) {
            return term;
        }
        switch (term.getType()) {
            case 1: {
                ATermAppl appl = (ATermAppl)term;
                AFun fun = (AFun)this.importTerm(appl.getAFun());
                int nrOfArguments = appl.getArity();
                ATerm[] newArguments = new ATerm[nrOfArguments];
                for (int i = nrOfArguments - 1; i >= 0; --i) {
                    newArguments[i] = this.importTerm(appl.getArgument(i));
                }
                result = this.makeAppl(fun, newArguments);
                break;
            }
            case 4: {
                ATermList list = (ATermList)term;
                if (list.isEmpty()) {
                    result = this._empty;
                    break;
                }
                ATerm first = this.importTerm((ATerm)list.getFirst());
                ATermList next = (ATermList)this.importTerm(list.getNext());
                result = this.makeList(first, next);
                break;
            }
            case 2: {
                ATermInt integer = (ATermInt)term;
                result = this.makeInt(integer.getInt());
                break;
            }
            case 8: {
                ATermLong elongatedType = (ATermLong)term;
                result = this.makeLong(elongatedType.getLong());
                break;
            }
            case 3: {
                ATermReal real = (ATermReal)term;
                result = this.makeReal(real.getReal());
                break;
            }
            case 5: {
                ATermPlaceholder placeHolder = (ATermPlaceholder)term;
                result = this.makePlaceholder(this.importTerm(placeHolder.getPlaceholder()));
                break;
            }
            case 7: {
                AFun afun = (AFun)term;
                return this.makeAFun(afun.getName(), afun.getArity(), afun.isQuoted());
            }
            default: {
                throw new OpenError("Unknown term type id: " + term.getType());
            }
        }
        return result;
    }

    @Override
    public FunAnd and() {
        return this.build(new FunAnd(this));
    }

    @Override
    public FunLiteral literal() {
        return this.build(new FunLiteral(this));
    }

    @Override
    public FunOr or() {
        return this.build(new FunOr(this));
    }

    @Override
    public FunSome some() {
        return this.build(new FunSome(this));
    }

    @Override
    public FunAll all() {
        return this.build(new FunAll(this));
    }

    @Override
    public FunNot not() {
        return this.build(new FunNot(this));
    }

    @Override
    public FunMax max() {
        return this.build(new FunMax(this));
    }

    @Override
    public FunMin min() {
        return this.build(new FunMin(this));
    }

    @Override
    public FunValue value() {
        return this.build(new FunValue(this));
    }

    @Override
    public FunSelf self() {
        return this.build(new FunSelf(this));
    }

    @Override
    public FunCard card() {
        return this.build(new FunCard(this));
    }

    @Override
    public FunInv inv() {
        return this.build(new FunInv(this));
    }

    @Override
    public FunSubClassOf subClassOf() {
        return this.build(new FunSubClassOf(this));
    }

    @Override
    public FunEquivalentClasses equivalentClasses() {
        return this.build(new FunEquivalentClasses(this));
    }

    @Override
    public FunSameAs sameAs() {
        return this.build(new FunSameAs(this));
    }

    @Override
    public FunDisjointWith disjointWith() {
        return this.build(new FunDisjointWith(this));
    }

    @Override
    public FunDisjointClasses disjointClasses() {
        return this.build(new FunDisjointClasses(this));
    }

    @Override
    public FunDisjointPropertyWith disjointPropertyWith() {
        return this.build(new FunDisjointPropertyWith(this));
    }

    @Override
    public FunDisjointProperties disjointProperties() {
        return this.build(new FunDisjointProperties(this));
    }

    @Override
    public FunComplementOf complementOf() {
        return this.build(new FunComplementOf(this));
    }

    @Override
    public FunVar var() {
        return this.build(new FunVar(this));
    }

    @Override
    public FunType type() {
        return this.build(new FunType(this));
    }

    @Override
    public FunProp prop() {
        return this.build(new FunProp(this));
    }

    @Override
    public FunDifferent different() {
        return this.build(new FunDifferent(this));
    }

    @Override
    public FunAllDifferent allDifferent() {
        return this.build(new FunAllDifferent(this));
    }

    @Override
    public FunAsymmetric asymmetric() {
        return this.build(new FunAsymmetric(this));
    }

    @Override
    public FunFunctionnal functional() {
        return this.build(new FunFunctionnal(this));
    }

    @Override
    public FunInverseFunctional inverseFunctional() {
        return this.build(new FunInverseFunctional(this));
    }

    @Override
    public FunIrreflexive irreflexive() {
        return this.build(new FunIrreflexive(this));
    }

    @Override
    public FunReflexive reflexive() {
        return this.build(new FunReflexive(this));
    }

    @Override
    public FunSymmetric symmetric() {
        return this.build(new FunSymmetric(this));
    }

    @Override
    public FunTransitive transitive() {
        return this.build(new FunTransitive(this));
    }

    @Override
    public FunSubProperty subProperty() {
        return this.build(new FunSubProperty(this));
    }

    @Override
    public FunEquivalentProperty equivalentProperty() {
        return this.build(new FunEquivalentProperty(this));
    }

    @Override
    public FunInverseProperty inverseProperty() {
        return this.build(new FunInverseProperty(this));
    }

    @Override
    public FunDomain domain() {
        return this.build(new FunDomain(this));
    }

    @Override
    public FunRange range() {
        return this.build(new FunRange(this));
    }

    @Override
    public FunRule rule() {
        return this.build(new FunRule(this));
    }

    @Override
    public FunBuiltin builtin() {
        return this.build(new FunBuiltin(this));
    }

    @Override
    public FunDatatypeDefinition datatypeDefinition() {
        return this.build(new FunDatatypeDefinition(this));
    }

    @Override
    public FunRestrictedDatatype restrictedDatatype() {
        return this.build(new FunRestrictedDatatype(this));
    }

    @Override
    public FunFacet facet() {
        return this.build(new FunFacet(this));
    }

    @Override
    public FunEmpty empty() {
        return this.build(new FunEmpty(this));
    }

    @Override
    public FunTop top() {
        return this.build(new FunTop(this));
    }

    @Override
    public FunTopObjectProperty topObjectProperty() {
        return this.build(new FunTopObjectProperty(this));
    }

    @Override
    public FunTopDataProperty topDataProperty() {
        return this.build(new FunTopDataProperty(this));
    }

    @Override
    public FunBottomObjectProperty bottomObjectProperty() {
        return this.build(new FunBottomObjectProperty(this));
    }

    @Override
    public FunBottomDataProperty bottomDataProperty() {
        return this.build(new FunBottomDataProperty(this));
    }
}

