/*
 * Decompiled with CFR 0.152.
 */
package openllet.aterm.pure.binary;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.List;
import openllet.aterm.AFun;
import openllet.aterm.ATerm;
import openllet.aterm.ATermAppl;
import openllet.aterm.ATermBlob;
import openllet.aterm.ATermInt;
import openllet.aterm.ATermList;
import openllet.aterm.ATermLong;
import openllet.aterm.ATermPlaceholder;
import openllet.aterm.ATermReal;
import openllet.aterm.pure.PureFactory;
import openllet.aterm.pure.binary.ATermConstruct;
import openllet.atom.OpenError;

public class BinaryReader {
    private static final int ISSHAREDFLAG = 128;
    private static final int TYPEMASK = 15;
    private static final int ISFUNSHARED = 64;
    private static final int APPLQUOTED = 32;
    private static final int INITIALSHAREDTERMSARRAYSIZE = 1024;
    private static final int STACKSIZE = 256;
    private final PureFactory _factory;
    private int _sharedTermIndex;
    private ATerm[] _sharedTerms;
    private final List<AFun> _applSignatures;
    private ATermConstruct[] _stack;
    private int _stackPosition;
    private int _tempType = -1;
    private byte[] _tempBytes = null;
    private int _tempBytesIndex = 0;
    private int _tempArity = -1;
    private boolean _tempIsQuoted = false;
    private ByteBuffer _currentBuffer;
    private boolean _isDone = false;
    private static final int SEVENBITS = 127;
    private static final int SIGNBIT = 128;
    private static final int BYTEMASK = 255;
    private static final int BYTEBITS = 8;
    private static final int LONGBITS = 8;

    public BinaryReader(PureFactory factory) {
        this._factory = factory;
        this._sharedTerms = new ATerm[1024];
        this._applSignatures = new ArrayList<AFun>();
        this._sharedTermIndex = 0;
        this._stack = new ATermConstruct[256];
        this._stackPosition = -1;
    }

    private void ensureSharedTermsCapacity() {
        int sharedTermsArraySize = this._sharedTerms.length;
        if (this._sharedTermIndex + 1 >= sharedTermsArraySize) {
            ATerm[] newSharedTermsArray = new ATerm[sharedTermsArraySize << 1];
            System.arraycopy(this._sharedTerms, 0, newSharedTermsArray, 0, sharedTermsArraySize);
            this._sharedTerms = newSharedTermsArray;
        }
    }

    public void deserialize(ByteBuffer buffer) {
        this._currentBuffer = buffer;
        if (this._tempType != -1) {
            this.readData();
        }
        while (buffer.hasRemaining()) {
            byte header = buffer.get();
            if ((header & 0x80) == 128) {
                int index = this.readInt();
                ATerm term = this._sharedTerms[index];
                ++this._stackPosition;
                this.linkTerm(term);
            } else {
                int type = header & 0xF;
                ATermConstruct ac = new ATermConstruct(type, this._sharedTermIndex++);
                this.ensureSharedTermsCapacity();
                this._stack[++this._stackPosition] = ac;
                switch (type) {
                    case 1: {
                        this.touchAppl(header);
                        break;
                    }
                    case 4: {
                        this.touchList();
                        break;
                    }
                    case 2: {
                        this.touchInt();
                        break;
                    }
                    case 3: {
                        this.touchReal();
                        break;
                    }
                    case 8: {
                        this.touchLong();
                        break;
                    }
                    case 6: {
                        this.touchBlob();
                        break;
                    }
                    case 5: {
                        this.touchPlaceholder();
                        break;
                    }
                    default: {
                        throw new OpenError("Unknown type id: " + type + ". Current buffer position: " + this._currentBuffer.position());
                    }
                }
            }
            this.ensureStackCapacity();
        }
    }

    private void ensureStackCapacity() {
        int stackSize = this._stack.length;
        if (this._stackPosition + 1 >= stackSize) {
            ATermConstruct[] newStack = new ATermConstruct[stackSize << 1];
            System.arraycopy(this._stack, 0, newStack, 0, this._stack.length);
            this._stack = newStack;
        }
    }

    public boolean isDone() {
        return this._isDone;
    }

    public ATerm getRoot() {
        if (!this._isDone) {
            throw new OpenError("Can't retrieve the root of the tree while it's still being constructed.");
        }
        return this._sharedTerms[0];
    }

    private void resetTemp() {
        this._tempType = -1;
        this._tempBytes = null;
        this._tempBytesIndex = 0;
    }

    private void readData() {
        int length = this._tempBytes.length;
        int bytesToRead = length - this._tempBytesIndex;
        int remaining = this._currentBuffer.remaining();
        if (remaining < bytesToRead) {
            bytesToRead = remaining;
        }
        this._currentBuffer.get(this._tempBytes, this._tempBytesIndex, bytesToRead);
        this._tempBytesIndex += bytesToRead;
        if (this._tempBytesIndex == length) {
            if (this._tempType == 1) {
                AFun fun = this._factory.makeAFun(new String(this._tempBytes), this._tempArity, this._tempIsQuoted);
                this._applSignatures.add(fun);
                ATermConstruct ac = this._stack[this._stackPosition];
                if (this._tempArity == 0) {
                    ATermAppl term = this._factory.makeAppl(fun);
                    this._sharedTerms[ac.termIndex] = term;
                    this.linkTerm(term);
                } else {
                    ac.tempTerm = fun;
                    ac.subTerms = new ATerm[this._tempArity];
                }
            } else if (this._tempType == 6) {
                ATermConstruct ac = this._stack[this._stackPosition];
                ATermBlob term = this._factory.makeBlob(this._tempBytes);
                this._sharedTerms[ac.termIndex] = term;
                this.linkTerm(term);
            } else {
                throw new OpenError("Unsupported chunkified type: " + this._tempType);
            }
            this.resetTemp();
        }
    }

    private void touchAppl(byte header) {
        if ((header & 0x40) == 64) {
            int key = this.readInt();
            AFun fun = this._applSignatures.get(key);
            int arity = fun.getArity();
            ATermConstruct ac = this._stack[this._stackPosition];
            if (arity == 0) {
                ATermAppl term = this._factory.makeAppl(fun);
                this._sharedTerms[ac.termIndex] = term;
                this.linkTerm(term);
            } else {
                ac.tempTerm = fun;
                ac.subTerms = new ATerm[arity];
            }
        } else {
            this._tempIsQuoted = (header & 0x20) == 32;
            this._tempArity = this.readInt();
            int nameLength = this.readInt();
            this._tempType = 1;
            this._tempBytes = new byte[nameLength];
            this._tempBytesIndex = 0;
            this.readData();
        }
    }

    private void touchList() {
        int size = this.readInt();
        ATermConstruct ac = this._stack[this._stackPosition];
        ac.subTerms = new ATerm[size];
        if (size == 0) {
            ATermList term = this._factory.makeList();
            this._sharedTerms[ac.termIndex] = term;
            this.linkTerm(term);
        }
    }

    private void touchInt() {
        int value = this.readInt();
        ATermConstruct ac = this._stack[this._stackPosition];
        ATermInt term = this._factory.makeInt(value);
        this._sharedTerms[ac.termIndex] = term;
        this.linkTerm(term);
    }

    private void touchReal() {
        double value = this.readDouble();
        ATermConstruct ac = this._stack[this._stackPosition];
        ATermReal term = this._factory.makeReal(value);
        this._sharedTerms[ac.termIndex] = term;
        this.linkTerm(term);
    }

    private void touchLong() {
        long value = this.readLong();
        ATermConstruct ac = this._stack[this._stackPosition];
        ATermLong term = this._factory.makeLong(value);
        this._sharedTerms[ac.termIndex] = term;
        this.linkTerm(term);
    }

    private void touchBlob() {
        int length = this.readInt();
        this._tempType = 6;
        this._tempBytes = new byte[length];
        this._tempBytesIndex = 0;
        this.readData();
    }

    private void touchPlaceholder() {
        ATermConstruct ac = this._stack[this._stackPosition];
        ac.subTerms = new ATerm[1];
    }

    private ATerm buildTerm(ATermConstruct ac) {
        ATerm constructedTerm;
        ATerm[] subTerms = ac.subTerms;
        int type = ac.type;
        if (type == 1) {
            AFun fun = (AFun)ac.tempTerm;
            constructedTerm = this._factory.makeAppl(fun, subTerms);
        } else if (type == 4) {
            ATermList list = this._factory.makeList();
            for (int i = subTerms.length - 1; i >= 0; --i) {
                list = this._factory.makeList(subTerms[i], list);
            }
            constructedTerm = list;
        } else if (type == 5) {
            ATermPlaceholder placeholder = this._factory.makePlaceholder(subTerms[0]);
            constructedTerm = placeholder;
        } else {
            throw new OpenError("Unable to construct term.\n");
        }
        return constructedTerm;
    }

    private void linkTerm(ATerm aTerm) {
        ATerm term = aTerm;
        while (this._stackPosition != 0) {
            ATermConstruct parent = this._stack[--this._stackPosition];
            ATerm[] subTerms = parent.subTerms;
            if (subTerms != null && subTerms.length > parent.subTermIndex) {
                subTerms[parent.subTermIndex++] = term;
                if (parent.subTerms.length != parent.subTermIndex) {
                    return;
                }
            } else {
                throw new OpenError("Encountered a term that didn't fit anywhere. Type: " + term.getType());
            }
            this._sharedTerms[parent.termIndex] = term = this.buildTerm(parent);
        }
        if (this._stackPosition == 0) {
            this._isDone = true;
        }
    }

    private int readInt() {
        byte part = this._currentBuffer.get();
        int result = part & 0x7F;
        if ((part & 0x80) == 0) {
            return result;
        }
        part = this._currentBuffer.get();
        result |= (part & 0x7F) << 7;
        if ((part & 0x80) == 0) {
            return result;
        }
        part = this._currentBuffer.get();
        result |= (part & 0x7F) << 14;
        if ((part & 0x80) == 0) {
            return result;
        }
        part = this._currentBuffer.get();
        result |= (part & 0x7F) << 21;
        if ((part & 0x80) == 0) {
            return result;
        }
        part = this._currentBuffer.get();
        return result |= (part & 0x7F) << 28;
    }

    private double readDouble() {
        long result = this.readLong();
        return Double.longBitsToDouble(result);
    }

    private long readLong() {
        long result = 0L;
        for (int i = 0; i < 8; ++i) {
            result |= ((long)this._currentBuffer.get() & 0xFFL) << i * 8;
        }
        return result;
    }

    public static ATerm readTermFromSAFFile(PureFactory pureFactory, File file) throws IOException {
        BinaryReader binaryReader = new BinaryReader(pureFactory);
        ByteBuffer byteBuffer = ByteBuffer.allocate(65536);
        ByteBuffer sizeBuffer = ByteBuffer.allocate(2);
        try (FileInputStream fis = new FileInputStream(file);
             FileChannel fc = fis.getChannel();){
            byteBuffer.limit(1);
            int bytesRead = fc.read(byteBuffer);
            if (bytesRead != 1) {
                throw new IOException("Unable to read SAF identification token.\n");
            }
            do {
                sizeBuffer.clear();
                bytesRead = fc.read(sizeBuffer);
                if (bytesRead <= 0) break;
                if (bytesRead != 2) {
                    throw new IOException("Unable to read block size bytes from file: " + bytesRead + ".\n");
                }
                sizeBuffer.flip();
                int blockSize = (sizeBuffer.get() & 0xFF) + ((sizeBuffer.get() & 0xFF) << 8);
                if (blockSize == 0) {
                    blockSize = 65536;
                }
                byteBuffer.clear();
                byteBuffer.limit(blockSize);
                bytesRead = fc.read(byteBuffer);
                byteBuffer.flip();
                if (bytesRead != blockSize) {
                    throw new IOException("Unable to read bytes from file " + bytesRead + " vs " + blockSize + ".");
                }
                binaryReader.deserialize(byteBuffer);
            } while (bytesRead > 0);
            if (!binaryReader.isDone()) {
                throw new OpenError("Term incomplete, missing data.\n");
            }
        }
        return binaryReader.getRoot();
    }

    public static ATerm readTermFromSAFString(PureFactory pureFactory, byte[] data) {
        int blockSize;
        BinaryReader binaryReader = new BinaryReader(pureFactory);
        int length = data.length;
        int position = 0;
        do {
            blockSize = data[position++] & 0xFF;
            if ((blockSize += (data[position++] & 0xFF) << 8) == 0) {
                blockSize = 65536;
            }
            ByteBuffer byteBuffer = ByteBuffer.allocate(blockSize);
            byteBuffer.put(data, position, blockSize);
            byteBuffer.flip();
            binaryReader.deserialize(byteBuffer);
        } while ((position += blockSize) < length);
        if (!binaryReader.isDone()) {
            throw new OpenError("Term incomplete, missing data.\n");
        }
        return binaryReader.getRoot();
    }
}

