/*
 * Decompiled with CFR 0.152.
 */
package openllet.core;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import openllet.aterm.ATermAppl;
import openllet.core.tableau.completion.incremental.DependencyIndex;
import openllet.core.utils.SetUtils;
import openllet.core.utils.intset.IntSet;
import openllet.core.utils.intset.IntSetFactory;
import openllet.shared.tools.Log;

public class DependencySet {
    public static final Logger _logger = Log.getLogger(DependencySet.class);
    public static final int NO_BRANCH = -1;
    public static final DependencySet EMPTY = new DependencySet();
    public static final DependencySet INDEPENDENT = new DependencySet(0);
    public static final IntSet ZERO = IntSetFactory.create(0);
    public static final DependencySet DUMMY = new DependencySet(1);
    private final IntSet _depends;
    private int _branch = -1;
    private volatile Set<ATermAppl> _explain;

    private DependencySet() {
        this._depends = IntSetFactory.create();
        this.setExplain(Collections.emptySet());
    }

    public DependencySet(int branch) {
        this._depends = IntSetFactory.create(branch);
        this.setExplain(Collections.emptySet());
    }

    private DependencySet(int branch, IntSet depends, Set<ATermAppl> explain) {
        this._branch = branch;
        this._depends = depends;
        this.setExplain(explain);
    }

    public DependencySet(ATermAppl explainAtom) {
        this._depends = ZERO;
        this.setExplain(SetUtils.singleton(explainAtom));
    }

    public DependencySet(Set<ATermAppl> explain) {
        this._depends = ZERO;
        this.setExplain(explain);
    }

    public DependencySet copy(int newBranch) {
        return new DependencySet(newBranch, this._depends, this._explain);
    }

    public boolean contains(int b) {
        return this._depends.contains(b);
    }

    public void add(int b) {
        this._depends.add(b);
    }

    public void remove(int b) {
        this._depends.remove(b);
    }

    public boolean isIndependent() {
        return this.max() <= 0;
    }

    public int getBranch() {
        return this._branch;
    }

    public int size() {
        return this._depends.size();
    }

    public int max() {
        return this._depends.isEmpty() ? -1 : this._depends.max();
    }

    public DependencySet union(DependencySet ds, boolean doExplanation) {
        IntSet newDepends = this._depends.union(ds._depends);
        Set<ATermAppl> newExplain = doExplanation ? SetUtils.union(this._explain, ds._explain) : Collections.emptySet();
        return new DependencySet(this._branch, newDepends, newExplain);
    }

    public DependencySet union(Set<ATermAppl> explain, boolean doExplanation) {
        if (!doExplanation || explain.isEmpty()) {
            return this;
        }
        return new DependencySet(this._branch, this._depends.copy(), SetUtils.union(this._explain, explain));
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("DS{branch:");
        switch (this._branch) {
            case -1: {
                sb.append("NO_BRANCH(-1)");
                break;
            }
            default: {
                sb.append(this._branch);
            }
        }
        sb.append(", depends:");
        sb.append(this._depends);
        if (_logger.isLoggable(Level.FINE)) {
            sb.append(", explain:");
            sb.append(this._explain);
        }
        sb.append("}");
        return sb.toString();
    }

    public void removeExplain(ATermAppl assertion) {
        if (this.getExplain().contains(assertion)) {
            this.setExplain(new HashSet<ATermAppl>());
            DependencyIndex._logger.fine("             Explain: removed ");
        }
    }

    public IntSet getDepends() {
        return this._depends;
    }

    public void setExplain(Set<ATermAppl> explain) {
        this._explain = explain;
    }

    public Set<ATermAppl> getExplain() {
        return this._explain;
    }

    public DependencySet cache() {
        return this.isIndependent() ? INDEPENDENT : DUMMY;
    }
}

