/*
 * Decompiled with CFR 0.152.
 */
package openllet.core.boxes.rbox;

import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import openllet.aterm.ATerm;
import openllet.aterm.ATermAppl;
import openllet.aterm.ATermList;
import openllet.atom.OpenError;
import openllet.core.DependencySet;
import openllet.core.FSMBuilder;
import openllet.core.OpenlletOptions;
import openllet.core.PropertyType;
import openllet.core.boxes.rbox.Role;
import openllet.core.boxes.rbox.RoleImpl;
import openllet.core.exceptions.UnsupportedFeatureException;
import openllet.core.taxonomy.Taxonomy;
import openllet.core.utils.ATermUtils;
import openllet.core.utils.SetUtils;
import openllet.shared.tools.Logging;

public interface RBox
extends Logging {
    public Taxonomy<ATermAppl> getObjectTaxonomy();

    public void setObjectTaxonomy(Taxonomy<ATermAppl> var1);

    public Taxonomy<ATermAppl> getDataTaxonomy();

    public void setDataTaxonomy(Taxonomy<ATermAppl> var1);

    public Taxonomy<ATermAppl> getAnnotationTaxonomy();

    public void setAnnotationTaxonomy(Taxonomy<ATermAppl> var1);

    public Map<ATermAppl, Role> getRoles();

    public Set<Role> getReflexiveRoles();

    public Map<Role, Map<ATermAppl, Set<Set<ATermAppl>>>> getDomainAssertions();

    public Map<Role, Map<ATermAppl, Set<Set<ATermAppl>>>> getRangeAssertions();

    public FSMBuilder getFsmBuilder();

    public boolean isObjectTaxonomyPrepared();

    public boolean isDataTaxonomyPrepared();

    public boolean isAnnotationTaxonomyPrepared();

    default public Role getRole(ATerm r) {
        return null != r ? this.getRoles().get(r) : null;
    }

    default public Role getDefinedRole(ATerm r) {
        Role role = this.getRoles().get(r);
        if (role == null) {
            throw new OpenError(r + " is not defined as a property");
        }
        return role;
    }

    default public Role addRole(ATermAppl r) {
        Role role = this.getRole(r);
        if (role == null) {
            role = new RoleImpl(r, PropertyType.UNTYPED);
            this.getRoles().put(r, role);
        }
        return role;
    }

    public void propogateDomain(Role var1, Map<ATermAppl, Set<Set<ATermAppl>>> var2);

    public void propogateRange(Role var1, Map<ATermAppl, Set<Set<ATermAppl>>> var2);

    public void computeImmediateSubRoles(Role var1, Map<ATerm, DependencySet> var2);

    public void computeSubRoles(Role var1, Set<Role> var2, Set<ATermList> var3, Map<ATerm, DependencySet> var4, DependencySet var5);

    default public boolean addRange(ATerm p, ATermAppl range, Set<ATermAppl> explanation) {
        Set<Set<ATermAppl>> allExplanations;
        Role r = this.getRole(p);
        if (r == null) {
            throw new IllegalArgumentException(p + " is not defined as a property");
        }
        Map<ATermAppl, Set<Set<ATermAppl>>> ranges = this.getRangeAssertions().get(r);
        if (ranges == null) {
            ranges = new ConcurrentHashMap<ATermAppl, Set<Set<ATermAppl>>>();
            this.getRangeAssertions().put(r, ranges);
        }
        if ((allExplanations = ranges.get(range)) == null) {
            allExplanations = new HashSet<Set<ATermAppl>>();
            ranges.put(range, allExplanations);
        }
        return allExplanations.add(explanation);
    }

    default public boolean addRange(ATerm p, ATermAppl range) {
        Set<ATermAppl> ds = Collections.singleton(ATermUtils.makeRange(p, range));
        return this.addRange(p, range, ds);
    }

    default public Role addObjectRole(ATermAppl r) {
        Role role = this.getRole(r);
        PropertyType roleType = role == null ? PropertyType.UNTYPED : role.getType();
        switch (roleType) {
            case DATATYPE: {
                role = null;
                break;
            }
            case OBJECT: {
                break;
            }
            default: {
                if (role == null) {
                    role = new RoleImpl(r, PropertyType.OBJECT);
                    this.getRoles().put(r, role);
                } else {
                    role.setType(PropertyType.OBJECT);
                }
                ATermAppl invR = ATermUtils.makeInv(r);
                RoleImpl invRole = new RoleImpl(invR, PropertyType.OBJECT);
                this.getRoles().put(invR, invRole);
                role.setInverse(invRole);
                invRole.setInverse(role);
                this.addSubRole(ATermUtils.BOTTOM_OBJECT_PROPERTY, role.getName(), DependencySet.INDEPENDENT);
                this.addSubRole(role.getName(), ATermUtils.TOP_OBJECT_PROPERTY, DependencySet.INDEPENDENT);
                this.addSubRole(ATermUtils.BOTTOM_OBJECT_PROPERTY, role.getName(), DependencySet.INDEPENDENT);
                this.addSubRole(role.getName(), ATermUtils.TOP_OBJECT_PROPERTY, DependencySet.INDEPENDENT);
            }
        }
        return role;
    }

    default public Role addDatatypeRole(ATermAppl r) {
        Role role = this.getRole(r);
        if (role == null) {
            role = new RoleImpl(r, PropertyType.DATATYPE);
            this.getRoles().put(r, role);
            this.addSubRole(ATermUtils.BOTTOM_DATA_PROPERTY, role.getName(), DependencySet.INDEPENDENT);
            this.addSubRole(role.getName(), ATermUtils.TOP_DATA_PROPERTY, DependencySet.INDEPENDENT);
        } else {
            switch (role.getType()) {
                case DATATYPE: {
                    break;
                }
                case OBJECT: {
                    role = null;
                    break;
                }
                default: {
                    role.setType(PropertyType.DATATYPE);
                    this.addSubRole(ATermUtils.BOTTOM_DATA_PROPERTY, role.getName(), DependencySet.INDEPENDENT);
                    this.addSubRole(role.getName(), ATermUtils.TOP_DATA_PROPERTY, DependencySet.INDEPENDENT);
                }
            }
        }
        return role;
    }

    default public Role addAnnotationRole(ATermAppl r) {
        Role role = this.getRole(r);
        if (role == null) {
            role = new RoleImpl(r, PropertyType.ANNOTATION);
            this.getRoles().put(r, role);
        } else {
            switch (role.getType()) {
                case ANNOTATION: {
                    break;
                }
                case OBJECT: {
                    role = null;
                    break;
                }
                default: {
                    role.setType(PropertyType.ANNOTATION);
                }
            }
        }
        return role;
    }

    default public boolean addSubRole(ATerm sub, ATerm sup) {
        DependencySet ds = OpenlletOptions.USE_TRACING ? new DependencySet(ATermUtils.makeSubProp(sub, sup)) : DependencySet.INDEPENDENT;
        return this.addSubRole(sub, sup, ds);
    }

    default public boolean addSubRole(ATerm sub, ATerm sup, DependencySet ds) {
        Role roleSup = this.getRole(sup);
        Role roleSub = this.getRole(sub);
        if (roleSup == null) {
            return false;
        }
        if (sub.getType() == 4) {
            roleSup.addSubRoleChain((ATermList)sub, ds);
        } else {
            if (roleSub == null) {
                return false;
            }
            roleSup.addSubRole(roleSub, ds);
            roleSub.addSuperRole(roleSup, ds);
        }
        return true;
    }

    default public boolean addEquivalentRole(ATerm s, ATerm r) {
        DependencySet ds = OpenlletOptions.USE_TRACING ? new DependencySet(ATermUtils.makeEqProp(s, r)) : DependencySet.INDEPENDENT;
        return this.addEquivalentRole(r, s, ds);
    }

    default public boolean addEquivalentRole(ATerm s, ATerm r, DependencySet ds) {
        Role roleS = this.getRole(s);
        Role roleR = this.getRole(r);
        if (roleS == null || roleR == null) {
            return false;
        }
        roleR.addSubRole(roleS, ds);
        roleR.addSuperRole(roleS, ds);
        roleS.addSubRole(roleR, ds);
        roleS.addSuperRole(roleR, ds);
        if (roleR.getInverse() != null) {
            roleR.getInverse().addSubRole(roleS.getInverse(), ds);
            roleR.getInverse().addSuperRole(roleS.getInverse(), ds);
            roleS.getInverse().addSubRole(roleR.getInverse(), ds);
            roleS.getInverse().addSuperRole(roleR.getInverse(), ds);
        }
        return true;
    }

    default public boolean addDisjointRole(ATerm s, ATerm r, DependencySet ds) {
        Role roleS = this.getRole(s);
        Role roleR = this.getRole(r);
        if (roleS == null || roleR == null) {
            return false;
        }
        roleR.addDisjointRole(roleS, ds);
        roleS.addDisjointRole(roleR, ds);
        return true;
    }

    default public boolean addDomain(ATerm p, ATermAppl domain, Set<ATermAppl> explanation) {
        Set<Set<ATermAppl>> allExplanations;
        Role r = this.getRole(p);
        if (r == null) {
            throw new IllegalArgumentException(p + " is not defined as a property");
        }
        Map<ATermAppl, Set<Set<ATermAppl>>> domains = this.getDomainAssertions().get(r);
        if (domains == null) {
            domains = new ConcurrentHashMap<ATermAppl, Set<Set<ATermAppl>>>();
            this.getDomainAssertions().put(r, domains);
        }
        if ((allExplanations = domains.get(domain)) == null) {
            allExplanations = SetUtils.create();
            domains.put(domain, allExplanations);
        }
        return allExplanations.add(explanation);
    }

    default public boolean addDomain(ATerm p, ATermAppl a) {
        Set<ATermAppl> explain = Collections.singleton(ATermUtils.makeDomain(p, a));
        return this.addDomain(p, a, explain);
    }

    default public boolean addInverseRole(ATerm s, ATerm r, DependencySet ds) {
        Role roleS = this.getRole(s);
        Role roleR = this.getRole(r);
        if (roleS == null || roleR == null || !roleS.isObjectRole() || !roleR.isObjectRole()) {
            return false;
        }
        this.addEquivalentRole(roleS.getInverse().getName(), r, ds);
        return true;
    }

    public Iterator<ATermAppl> getAssertedDomains(Role var1);

    public Iterator<ATermAppl> getAssertedRanges(Role var1);

    default public boolean isRole(ATerm r) {
        return this.getRoles().containsKey(r);
    }

    default public void prepare() {
        Set<Role> complexRoles = SetUtils.create();
        block0: for (Role role : this.getRoles().values()) {
            ConcurrentHashMap<ATerm, DependencySet> subExplain = new ConcurrentHashMap<ATerm, DependencySet>();
            Iterator<Role> subRoles = SetUtils.create();
            Set<ATermList> set = SetUtils.create();
            this.computeSubRoles(role, (Set<Role>)((Object)subRoles), set, (Map<ATerm, DependencySet>)subExplain, DependencySet.INDEPENDENT);
            role.setSubRolesAndChains((Set<Role>)((Object)subRoles), set, (Map<ATerm, DependencySet>)subExplain);
            Iterator<Object> iterator = subRoles.iterator();
            while (iterator.hasNext()) {
                Role s = iterator.next();
                DependencySet explainSub = role.getExplainSub(s.getName());
                s.addSuperRole(role, explainSub);
            }
            for (ATermList chain : set) {
                if (chain.getLength() == 2 && ((ATerm)chain.getFirst()).equals(chain.getLast()) && subRoles.contains(this.getRole((ATerm)chain.getFirst()))) continue;
                role.setHasComplexSubRole(true);
                complexRoles.add(role);
                continue block0;
            }
        }
        for (Role s : complexRoles) {
            this.getFsmBuilder().build(s);
        }
        for (Role role : this.getRoles().values()) {
            Role invR = role.getInverse();
            if (invR != null) {
                if (invR.isTransitive() && !role.isTransitive()) {
                    role.setTransitive(true, invR.getExplainTransitive());
                } else if (role.isTransitive() && !invR.isTransitive()) {
                    invR.setTransitive(true, role.getExplainTransitive());
                }
                if (invR.isFunctional() && !role.isInverseFunctional()) {
                    role.setInverseFunctional(true, invR.getExplainFunctional());
                }
                if (role.isFunctional() && !invR.isInverseFunctional()) {
                    invR.setInverseFunctional(true, role.getExplainFunctional());
                }
                if (invR.isInverseFunctional() && !role.isFunctional()) {
                    role.setFunctional(true, invR.getExplainInverseFunctional());
                }
                if (invR.isAsymmetric() && !role.isAsymmetric()) {
                    role.setAsymmetric(true, invR.getExplainAsymmetric());
                }
                if (role.isAsymmetric() && !invR.isAsymmetric()) {
                    invR.setAsymmetric(true, role.getExplainAsymmetric());
                }
                if (invR.isReflexive() && !role.isReflexive()) {
                    role.setReflexive(true, invR.getExplainReflexive());
                }
                if (role.isReflexive() && !invR.isReflexive()) {
                    invR.setReflexive(true, role.getExplainReflexive());
                }
                for (Role role2 : role.getDisjointRoles()) {
                    invR.addDisjointRole(role2.getInverse(), role.getExplainDisjointRole(role2));
                }
            }
            for (Role role3 : role.getSubRoles()) {
                if (role.isForceSimple()) {
                    role3.setForceSimple(true);
                }
                if (role3.isSimple()) continue;
                role.setSimple(false);
            }
        }
        for (Role r : this.getRoles().values()) {
            if (r.isForceSimple()) {
                if (!r.isSimple()) {
                    this.ignoreTransitivity(r);
                }
            } else {
                boolean isTransitive = r.isTransitive();
                DependencySet transitiveDS = r.getExplainTransitive();
                for (Role s : r.getSubRoles()) {
                    if (!s.isTransitive()) continue;
                    if (r.isSubRoleOf(s) && r != s) {
                        isTransitive = true;
                        transitiveDS = r.getExplainSub(s.getName()).union(s.getExplainTransitive(), true);
                    }
                    r.addTransitiveSubRole(s);
                }
                if (isTransitive != r.isTransitive()) {
                    r.setTransitive(isTransitive, transitiveDS);
                }
            }
            if (r.isFunctional()) {
                r.addFunctionalSuper(r);
            }
            for (Role s : r.getSuperRoles()) {
                DependencySet ds;
                DependencySet dependencySet;
                if (s.equals(r)) continue;
                DependencySet dependencySet2 = dependencySet = OpenlletOptions.USE_TRACING ? r.getExplainSuper(s.getName()) : DependencySet.INDEPENDENT;
                if (s.isFunctional()) {
                    ds = OpenlletOptions.USE_TRACING ? dependencySet.union(s.getExplainFunctional(), true) : DependencySet.INDEPENDENT;
                    r.setFunctional(true, ds);
                    r.addFunctionalSuper(s);
                }
                if (s.isIrreflexive() && !r.isIrreflexive()) {
                    ds = OpenlletOptions.USE_TRACING ? dependencySet.union(s.getExplainIrreflexive(), true) : DependencySet.INDEPENDENT;
                    r.setIrreflexive(true, ds);
                }
                if (s.isAsymmetric() && !r.isAsymmetric()) {
                    ds = OpenlletOptions.USE_TRACING ? dependencySet.union(s.getExplainAsymmetric(), true) : DependencySet.INDEPENDENT;
                    r.setAsymmetric(true, ds);
                }
                for (Iterator<Object> iterator : s.getDisjointRoles().toArray(new RoleImpl[0])) {
                    DependencySet ds2 = OpenlletOptions.USE_TRACING ? dependencySet.union(s.getExplainDisjointRole((Role)((Object)iterator)), true) : DependencySet.INDEPENDENT;
                    r.addDisjointRole((Role)((Object)iterator), ds2);
                    iterator.addDisjointRole(r, ds2);
                }
            }
            if (r.isReflexive() && !r.isAnon()) {
                this.getReflexiveRoles().add(r);
            }
            this.getLogger().fine(() -> r.debugString());
        }
        this.setObjectTaxonomy(null);
        this.setDataTaxonomy(null);
        this.setAnnotationTaxonomy(null);
    }

    default public void propagateDomainRange() {
        for (Role role : this.getRoles().values()) {
            role.resetDomainRange();
        }
        for (Role role : this.getRoles().values()) {
            Role invRole = role.getInverse();
            if (invRole != null) {
                Map<ATermAppl, Set<Set<ATermAppl>>> invDomains = this.getDomainAssertions().get(invRole);
                Map<ATermAppl, Set<Set<ATermAppl>>> invRanges = this.getRangeAssertions().get(invRole);
                this.propogateDomain(role, invRanges);
                this.propogateRange(role, invDomains);
            }
            Map<ATermAppl, Set<Set<ATermAppl>>> domains = this.getDomainAssertions().get(role);
            Map<ATermAppl, Set<Set<ATermAppl>>> ranges = this.getRangeAssertions().get(role);
            this.propogateDomain(role, domains);
            this.propogateRange(role, ranges);
        }
    }

    default public boolean removeDomain(ATerm p, ATermAppl domain) {
        if (!OpenlletOptions.USE_TRACING) {
            return false;
        }
        Role r = this.getRole(p);
        if (r == null) {
            return false;
        }
        Map<ATermAppl, Set<Set<ATermAppl>>> domains = this.getDomainAssertions().get(r);
        if (domains == null) {
            return false;
        }
        Set<Set<ATermAppl>> allExplanations = domains.get(domain);
        if (allExplanations == null) {
            return false;
        }
        Set<ATermAppl> explanation = Collections.singleton(ATermUtils.makeDomain(p, domain));
        if (!allExplanations.remove(explanation)) {
            return false;
        }
        if (allExplanations.isEmpty()) {
            domains.remove(domain);
        }
        return true;
    }

    default public boolean removeRange(ATerm p, ATermAppl range) {
        if (!OpenlletOptions.USE_TRACING) {
            return false;
        }
        Role r = this.getRole(p);
        if (r == null) {
            return false;
        }
        Map<ATermAppl, Set<Set<ATermAppl>>> ranges = this.getRangeAssertions().get(r);
        if (ranges == null) {
            return false;
        }
        Set<Set<ATermAppl>> allExplanations = ranges.get(range);
        if (allExplanations == null) {
            return false;
        }
        Set<ATermAppl> explanation = Collections.singleton(ATermUtils.makeRange(p, range));
        if (!allExplanations.remove(explanation)) {
            return false;
        }
        if (allExplanations.isEmpty()) {
            ranges.remove(range);
        }
        return true;
    }

    default public void ignoreTransitivity(Role role) {
        Role namedRole = role.isAnon() ? role.getInverse() : role;
        String msg = "Unsupported axiom: Ignoring transitivity and/or complex subproperty axioms for " + namedRole;
        if (!OpenlletOptions.IGNORE_UNSUPPORTED_AXIOMS) {
            throw new UnsupportedFeatureException(msg);
        }
        this.getLogger().warning(msg);
        role.removeSubRoleChains();
        role.setHasComplexSubRole(false);
        role.setSimple(true);
        role.setFSM(null);
        role.getInverse().removeSubRoleChains();
        role.getInverse().setHasComplexSubRole(false);
        role.getInverse().setSimple(true);
        role.getInverse().setFSM(null);
    }

    default public ATermList inverse(ATermList roles) {
        ATermList invList = ATermUtils.EMPTY_LIST;
        ATermList list = roles;
        while (!list.isEmpty()) {
            ATermAppl r = (ATermAppl)list.getFirst();
            Role role = this.getRole(r);
            Role invR = role.getInverse();
            if (invR == null) {
                System.err.println("Property " + r + " was supposed to be an ObjectProperty but it is not!");
            } else {
                invList = invList.insert(invR.getName());
            }
            list = list.getNext();
        }
        return invList;
    }
}

